.NOLIST
; Most of the definitions found here are from three header files:
; WinUser.h, WinGDI.h, WinBase.h, and Winnt.h

;------------------ Structures ----------------

POINT STRUCT
  X   DWORD ?
  Y   DWORD ?
POINT ENDS

RECT STRUCT
  left      DWORD ?
  top       DWORD ?
  right     DWORD ?
  bottom    DWORD ?
RECT ENDS

MSGStruct STRUCT
  msgWnd        DWORD ?
  msgMessage    DWORD ?
  msgWparam     DWORD ?
  msgLparam     DWORD ?
  msgTime       DWORD ?
  msgPt         POINT <>
MSGStruct ENDS

WNDCLASS STRUC
  style           DWORD ?
  lpfnWndProc     DWORD ?
  cbClsExtra      DWORD ?
  cbWndExtra      DWORD ?
  hInstance       DWORD ?
  hIcon           DWORD ?
  hCursor         DWORD ?
  hbrBackground   DWORD ?
  lpszMenuName    DWORD ?
  lpszClassName   DWORD ?
WNDCLASS ENDS

;
PAINTSTRUCT STRUCT
	hdc				DWORD ?
	fErase			DWORD ?
	rcPaint			RECT      <>
	fRestore		DWORD ?
	fIncUpdate		DWORD ?
	rgbReserved	BYTE      32 DUP (?)
PAINTSTRUCT ENDS


;-------------- Function Prototypes ------------------------

CreateWindowExA PROTO,	; create and register a window class
	exWinStyle:DWORD,
	className:PTR BYTE,
	winName:PTR BYTE,
	winStyle:DWORD,
	X:DWORD,
	Y:DWORD,
	rWidth:DWORD,
	rHeight:DWORD,
	hWndParent:DWORD,
	hMenu:DWORD,
	hInstance:DWORD,
	lpParam:DWORD

DefWindowProcA PROTO,	; default Windows message handler
	hWnd:DWORD,
	locMsg:DWORD,
	wParam:DWORD,
	lParam:DWORD
	
TranslateMessage proto, pMsg: ptr BYTE

DispatchMessageA PROTO,	; dispatch a message to the application
	pMsg:PTR BYTE

ExitProcess PROTO,	; exit the current process
	exitCode:DWORD

FormatMessageA PROTO,	; format a message
	dwFlags:DWORD,
	lpSource:DWORD,
	msgID:DWORD,
	languageID:DWORD,
	lpBuffer:PTR BYTE,
	nSize:DWORD,
	pArgs:DWORD

GetLastError PROTO	; get most recent error return value

GetMessageA PROTO,
	lpMsg:PTR BYTE,
	hWnd:DWORD,
	firstMsg:DWORD,
	lastMsg:DWORD

GetModuleHandleA PROTO,
	pString:PTR BYTE

GetWindowDC PROTO,	; get the current window's device context
	hWind:DWORD

GetWindowRect PROTO,	; get the current window's rectangle
	hWind:DWORD,
	pRect:PTR RECT

LoadCursorA PROTO,	; load a cursor resource
	hInstance:DWORD,
	pString:PTR BYTE

LoadIconA PROTO,	; loan an icon resource
	hInstance:DWORD,
	pString:PTR BYTE

LocalFree PROTO,	; free up local memory, using its handle
	hMem:DWORD

MessageBoxA PROTO,	; display a pop-up message box
	hWnd:DWORD,
	lpText:PTR BYTE,
	lpCaption:PTR BYTE,
	style:DWORD

PostQuitMessage PROTO,	; tell Windows to terminate the app
	exitCode:DWORD

RegisterClassA PROTO,	; register a new window class
	pWndClass:PTR WNDCLASS

ShowWindow PROTO,	; show a window
	hWnd:DWORD,
	showState:DWORD

UpdateWindow PROTO,	; draw(redraw) a window
	hWnd:DWORD

Comment !
SelectObject PROTO,	; GDI32.LIB
	hdc:DWORD
	hGDIobject:DWORD
DeleteObject PROTO,	; GDI32.LIB
	hGDIobject:DWORD
!

; 
AdjustWindowRectEx PROTO, lpRect: PTR RECT, dwStyle: DWORD, bMenu: DWORD, dwExStyle: DWORD
MoveToEx 			PROTO, hdc: DWORD, X: DWORD, Y: DWORD, lpPoint: PTR POINT
LineTo 				PROTO, hdc: DWORD, nXEnd: DWORD, nYEnd: DWORD
Rectangle 			PROTO, hdc: DWORD, nLeftRect: DWORD, nTopRect: DWORD, nRightRect: DWORD, nBottomRect: DWORD
BeginPaint 			PROTO, hWnd: DWORD, lpPaint: PTR PAINTSTRUCT
EndPaint 			PROTO, hWnd: DWORD, lpPaint: PTR PAINTSTRUCT
CreateSolidBrush 	PROTO, crColor: DWORD
CreatePen			PROTO, fnPenStyle: DWORD, nWidth: DWORD, crColor: DWORD
DeleteObject		PROTO, hObject: DWORD
SelectObject		PROTO, hdc: DWORD, hgdiobj: DWORD
SetClassLongA 		PROTO, hWnd: DWORD, nIndex: DWORD, dwNewLong: DWORD
SetTimer 			PROTO, hWnd: DWORD, nIDEvent: DWORD, uElapse: DWORD, lpTimerFunc: PTR BYTE
KillTimer 			PROTO, hWnd: DWORD, uIDEvent: DWORD
GetTickCount 		PROTO
TextOutA 			PROTO hdc: DWORD, nXStart: DWORD, nYStart: DWORD, lpString: PTR BYTE, cbString: DWORD
InvalidateRect		PROTO hWnd: DWORD, lpRect: PTR BYTE, bErase: DWORD
SetBkMode			PROTO hdc: DWORD, iBkMode: DWORD


; Redefine Win32 Names to standard API names.
GetModuleHandle	TEXTEQU <GetModuleHandleA>
LoadCursor			TEXTEQU <LoadCursorA>
LoadIcon  			TEXTEQU <LoadIconA>
RegisterClass   		TEXTEQU <RegisterClassA>
CreateWindowEx  	TEXTEQU <CreateWindowExA>
DispatchMessage 	TEXTEQU <DispatchMessageA>
GetMessage     		TEXTEQU <GetMessageA>
DefWindowProc   	TEXTEQU <DefWindowProcA>
FormatMessage  	TEXTEQU <FormatMessageA>
MessageBox      		TEXTEQU <MessageBoxA>
SetClassLong		TEXTEQU <SetClassLongA>
TextOut				TEXTEQU <TextOutA>

; RegisterClass Constants (from Winuser.h)
COLOR_WINDOW        = 5		; std window color
COLOR_BACKGROUND    = 2		; 2=blue F=gray
IDI_APPLICATION     = 32512		; application icon
IDC_ARROW           = 07f00h		; mouse cursor--arrow
CW_USEDEFAULT       = 80000000h		; default window size & position

; Window Style Constants
WS_OVERLAPPED       =     00000000h
WS_BORDER           =     00800000h
WS_DLGFRAME         =     00400000h
WS_SYSMENU          =     00080000h
WS_MAXIMIZEBOX      =     00010000h
WS_MINIMIZEBOX      =     00020000h
WS_THICKFRAME       =     00040000h
WS_CAPTION          =     WS_BORDER+WS_DLGFRAME
WS_VISIBLE          =     10000000h

; Window show constants
SW_SHOW             =     05h

; Error Handler Variables
FORMAT_MESSAGE_ALLOCATE_BUFFER     = 100h
FORMAT_MESSAGE_FROM_SYSTEM         = 1000h

; Window Messages
WM_KEYDOWN			=  0100h
WM_KEYUP				=  0101h
WM_TIMER				=  0113h
WM_PAINT				=  000Fh
WM_CLOSE            		=  0010h	; close window
WM_CREATE           		=  01h		; create window
WM_LBUTTONDOWN      =   0201h		; left mouse button down

;MB_ICONERROR  =  010h	; stop sign icon
MB_ICONHAND            = 10h
MB_ICONQUESTION        = 20h
MB_ICONEXCLAMATION     = 30h
MB_ICONASTERISK        = 40h

MB_USERICON            = 80h
MB_ICONWARNING         = MB_ICONEXCLAMATION
MB_ICONERROR           = MB_ICONHAND
MB_ICONINFORMATION     = MB_ICONASTERISK
MB_ICONSTOP            = MB_ICONHAND

; Message Box Buttons
MB_OK         = 0
MB_OKCANCEL   = 1
MB_ABORTRETRYIGNORE = 2
MB_YESNOCANCEL = 3
MB_YESNO       = 4
MB_RETRYCANCEL = 5
MB_CANCELTRYCONTINUE = 6

; 
TRANSPARENT	= 1
OPAQUE		= 2
;
PS_SOLID		= 0
; 
GCL_HBRBACKGROUND	= -10

.LIST