#include <ntddk.h>
#include <WINDEF.H>
#include <strsafe.h>

#include "Verify.h"
#include "CommonFunc.h"

ULONG* CallerVerifyTable;
LONG	NumOfCallerVerify;

ULONG* HookedCallIndexTable;
LONG   NumOfHookedCallIndex;

extern PSYSTEM_DESCRIPTOR_TABLE KeServiceDescriptorTable;


BOOLEAN InitVerify ()
{
	ULONG ulLimit = KeServiceDescriptorTable->ntoskrnl.ServiceLimit;
	KdPrint(("DEBUG: Calling InitVerify \n"));

	CallerVerifyTable = (ULONG*)ExAllocatePool (NonPagedPool,
												MAX_NUM_OF_VERIFY*sizeof(ULONG));

	if (CallerVerifyTable == NULL)
	{
		KdPrint(("ERROR: Cannot allocate pool for caller verify \n"));
		return FALSE;
	}

	HookedCallIndexTable = (ULONG*)ExAllocatePool (NonPagedPool,ulLimit * sizeof(ULONG));
	if (HookedCallIndexTable == NULL)
	{
		KdPrint(("ERROR: Cannot allocate pool for call index verify \n"));
		return FALSE;
	}
	

	NumOfHookedCallIndex = 0;
	NumOfCallerVerify = 0;

	RtlZeroMemory(CallerVerifyTable,MAX_NUM_OF_VERIFY*sizeof(ULONG));
	RtlZeroMemory(HookedCallIndexTable,ulLimit*sizeof(ULONG));

	return TRUE;
}

void UninitVerify ()
{
	if (HookedCallIndexTable)
		ExFreePool (HookedCallIndexTable);
	if (CallerVerifyTable)
		ExFreePool (CallerVerifyTable);
}

BOOLEAN VerifyCaller (
	ULONG ulPid)
{
	LONG i;

	if (!ulPid)
	{
		return FALSE;
	}
	for (i = 0 ; i < MAX_NUM_OF_VERIFY ; i++ )
	{
		if (CallerVerifyTable[i] == ulPid)
		{
			return TRUE;
		}
	}
	return FALSE;
}

BOOLEAN VerifyCallIndex (
	ULONG ulIndex)
{
	LONG i;

	for (i = 0; i < NumOfHookedCallIndex ; i++)
	{
		if (HookedCallIndexTable[i] == ulIndex)
		{
			return TRUE;
		}
	}
	return FALSE;
}

void AddIndexVerify (
	BOOLEAN bIsMainTable,
	ULONG ulIndex)
{
	HookedCallIndexTable[NumOfHookedCallIndex] = ulIndex;
	InterlockedIncrement(&NumOfHookedCallIndex);
}

void AddProcVerify (
	ULONG ulPid)
{
	LONG i;

	if (NumOfCallerVerify == MAX_NUM_OF_VERIFY || !ulPid)
	{
		return ;
	}
	for (i = 0 ; i< MAX_NUM_OF_VERIFY ; i++)
	{
		if (!CallerVerifyTable[i])
		{
			CallerVerifyTable[i] = ulPid;
			InterlockedIncrement(&NumOfCallerVerify);
			return ;
		}
	}
}


void DeleteProcVerify (
	ULONG ulPid)
{
	LONG i;

	if (!ulPid)
	{
		return ;
	}
	for (i = 0 ; i < MAX_NUM_OF_VERIFY ; i++)
	{
		if (CallerVerifyTable[i] == ulPid)
		{
			CallerVerifyTable[i] = 0;
			InterlockedDecrement(&NumOfCallerVerify);
			return ;
		}
	}
}