#pragma once

#include <ntddk.h>
#include <WINDEF.H>

#define IMG_IMPORT_ORDER 1
#define IMG_RELOC_ORDER  5
#define IMG_EXP_ORDER 0

#define SEC_IMAGE     0x01000000

#define CAN_READ 2
#define CAN_WRITE 4
#define CAN_EXEC 8

#define SECTION_SHARED 0x10000000
#define SECTION_EXEC   0x20000000
#define SECTION_READ   0x40000000
#define SECTION_WRITE  0x80000000

#define _min(a,b) (a<=b? a:b)

typedef struct _LOADED_KERNEL_INFO
{
	PVOID OriginalKernelBase;
	PVOID NewKernelBase;
	PVOID NewPsdt;
	PKEVENT NotifyEvent;
	LONG LoadedStatus;
} LOADED_KERNEL_INFO, *PLOADED_KERNEL_INFO;

typedef struct _MAPPED_INFO
{
	PVOID pBase;
	HANDLE hAssociateFile;
	HANDLE hAssociateSection;
}MAPPED_INFO;

typedef struct _REMAP_INFO
{
	PVOID ps;
	PVOID pmdl;
}REMAP_INFO;

NTSTATUS LoadKernel(
	PLOADED_KERNEL_INFO plki);

void UnloadKernel();