#include <ntifs.h>
#include <WINDEF.H>
#include <strsafe.h>

#include "ntimage.h"
#include "KrnlLdr.h"
#include "CommonFunc.h"


#pragma warning(disable:4995)
/*
 *this module is a common module that using for loading a new kernel
 *to bypass all hooks of original kernel
 **/


PVOID pStoreBuffer;

extern PSYSTEM_DESCRIPTOR_TABLE KeServiceDescriptorTable;

void RemovePEHeader(
	PVOID pBase)
{
	PIMAGE_DOS_HEADER pImgDosHeader;
	PIMAGE_NT_HEADERS pImgNtHeader;

	KdPrint(("DEBUG: calling : RevomePEHeader \n"));
	CHECK_IRQL

	if (pBase == NULL)
	{
		return;
	}

	pImgDosHeader = (PIMAGE_DOS_HEADER)pBase;
	pImgNtHeader =(PIMAGE_NT_HEADERS)((ULONG)pBase + pImgDosHeader->e_lfanew);

	_try
	{
		RtlZeroMemory(pBase , pImgNtHeader->FileHeader.SizeOfOptionalHeader + sizeof(IMAGE_FILE_HEADER) + pImgDosHeader->e_lfanew);
	}
	_except(EXCEPTION_EXECUTE_HANDLER)
	{
		/**/
	}

}

NTSTATUS RelocModule(
	PVOID pModule,
	PVOID pOldModule)
/*
 *Function:
 *	To relocate the code and data of module
 *	
 *Params:
 *	pModule:
 *		the base of module which will be relocated
 *	pRefBase:
 *		the reference base ,if pRefBase == null , the reference base will set to value of pModule
 *
 *Comment:
 *	we just regard the type of all relocation entry as IMAGE_REL_BASED_HIGHLOW
 *	
 *Return:
 *	status value
 *	
 **/
{
	PIMAGE_DOS_HEADER pImgDosHeader;
	PIMAGE_NT_HEADERS pImgNtHeader;
	PIMAGE_OPTIONAL_HEADER pImgOptHeader;
	PIMAGE_DATA_DIRECTORY pImgDataDir;
	PIMAGE_BASE_RELOCATION pImgBaseReloc;

	ULONG	RelocValueByNew;
	ULONG   RelocValueByOld;

	ULONG   i,Num;
	USHORT* RelocArray;
	ULONG	ulAddrOfReloc;
	ULONG   ulSizeOfReloc;
	ULONG	ulRVA;
	ULONG m;

	ULONG ulTemp;

	KdPrint(("DEBUG: Calling  RelocModule \n"));
	CHECK_IRQL

	if (pModule == NULL)
	{
		return STATUS_UNSUCCESSFUL;
	}
	if (pOldModule == NULL)
	{
		pOldModule = pModule;
	}

	//Get Dos header
	pImgDosHeader = (PIMAGE_DOS_HEADER)pModule;
	//get nt header
	pImgNtHeader = (PIMAGE_NT_HEADERS)((ULONG)pModule + pImgDosHeader->e_lfanew);
	//get optional headers
	pImgOptHeader = &(pImgNtHeader->OptionalHeader);
	
	//calculate RelocValue with reference base is pRefBase
	RelocValueByNew = (ULONG)pModule - pImgOptHeader->ImageBase;
	//calculate RelocaValue with reference base is pModule
	RelocValueByOld = (ULONG)pOldModule - pImgOptHeader->ImageBase;

	//get data directory
	pImgDataDir = pImgOptHeader->DataDirectory;
	//get relocation info
	pImgBaseReloc = (PIMAGE_BASE_RELOCATION)((ULONG)pModule + pImgDataDir[IMG_RELOC_ORDER].VirtualAddress);
	//get size of relocation
	ulSizeOfReloc = pImgDataDir[IMAGE_DIRECTORY_ENTRY_BASERELOC].Size;

	KdPrint(("Relocation size : %x \n",ulSizeOfReloc));
	
	m = 0;
	do 
	{
		//point to TypeOffset array
		RelocArray = (USHORT*)((ULONG)pImgBaseReloc + sizeof(IMAGE_BASE_RELOCATION));
		//calculate the number of elements of TypeOffset Array
		Num = (pImgBaseReloc->SizeOfBlock - sizeof(IMAGE_BASE_RELOCATION) )/ sizeof(USHORT);
		if (!Num)
		{
			continue;
		}
		KdPrint(("DEBUG: ---->>> Relocation Block NO.%d This block has %d entries <<<---- \n",++m,Num));
		//relocate this block
		for (i = 0 ; i < Num ; i++)
		{
			if (RelocArray[i] && (RelocArray[i] >> 12) == IMAGE_REL_BASED_HIGHLOW)
			{
				//calculate the RVA of a relocation entry
				ulRVA = (RelocArray[i] & 0xFFF) + pImgBaseReloc->VirtualAddress;
				//calculate address of relocation entry
				ulAddrOfReloc = ulRVA + (ULONG)pModule;
				//output info
				//KdPrint(("Relocation %d.%d --> RVA: %X Address: %X \n",m,i,ulRVA,ulAddrOfReloc));
				
				// we will verify whether this section should be relocated by testing if original data
				// equals 0xcccccccc

				ulTemp = *(ULONG*)ulAddrOfReloc;
				if (ulTemp != 0xcccccccc)
				{
					*(ULONG*)ulAddrOfReloc = ulTemp+RelocValueByOld;
				}
			}
			else
			{
				KdPrint(("DEBUG: We found a invalid relocation entry \n"));
			}
		}
		//decrease size of relocation
		ulSizeOfReloc -= pImgBaseReloc->SizeOfBlock;
		//point to next IMAGE_BASE_RELOCATION struct
		pImgBaseReloc = (PIMAGE_BASE_RELOCATION)((ULONG)pImgBaseReloc + pImgBaseReloc->SizeOfBlock);

	} while (ulSizeOfReloc);

	return STATUS_SUCCESS;
}


NTSTATUS GetSystemDir(
	IN char* chBuffer)
{
	NTSTATUS st;

	HANDLE hDir;
	OBJECT_ATTRIBUTES ObjDir;
	UNICODE_STRING usDirName;

	HANDLE hSymbolic;
	OBJECT_ATTRIBUTES ObjSymbolic;
	UNICODE_STRING usSymbolicName;
	UNICODE_STRING usSymbolic;

	ANSI_STRING asSymbolic;
	WCHAR	wchBuffer[256]={0};

	KdPrint(("DEBUG: calling GetSystemDir \n"));
	CHECK_IRQL

	/*
	 * 0: verify the params
	 **/
	if (chBuffer == NULL)
	{
		return STATUS_UNSUCCESSFUL;
	}

	/*
	 * 1: open the directory object which named KnownDlls
	 **/
	RtlInitUnicodeString (&usDirName,L"\\KnownDlls");
	InitializeObjectAttributes( &ObjDir,
								&usDirName,
								OBJ_CASE_INSENSITIVE|OBJ_KERNEL_HANDLE,
								NULL,
								NULL);
	st = ZwOpenDirectoryObject ( &hDir,
								DIRECTORY_QUERY,
								&ObjDir);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("cannot open Dir object 0x%x \n",st));
		goto __failed;
	}

	/*
	 * 2: open the symbolic object which named KnownDllPath
	 **/
	RtlInitUnicodeString (&usSymbolicName , L"KnownDllPath");
	InitializeObjectAttributes(&ObjSymbolic,&usSymbolicName,OBJ_CASE_INSENSITIVE|OBJ_KERNEL_HANDLE,hDir,NULL);
	st = ZwOpenSymbolicLinkObject (&hSymbolic,
									GENERIC_READ,
									&ObjSymbolic);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("cannot open sysmbolic 0x%x \n",st));
		goto __failed;
	}

	/*
	 * 3: query the info of symbolic object
	 **/ 
	usSymbolic.Buffer = wchBuffer;
	usSymbolic.MaximumLength = 256*sizeof(WCHAR);
	usSymbolic.Length =0;
	st = ZwQuerySymbolicLinkObject ( hSymbolic,
									&usSymbolic,
									NULL);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("cannot query symbolic 0x%x \n",st));
		goto __failed;
	}

	KdPrint(("KnownDllPath: %wZ \n",&usSymbolic));

	/*
	 * 3: convert the unicode string to ansi string
	 **/
	st = RtlUnicodeStringToAnsiString( &asSymbolic,
										&usSymbolic,
										TRUE);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("cannot convert unicode string to ansi string 0x%x \n",st));
		goto __failed;
	}
	_try
	{
		strcpy(chBuffer,asSymbolic.Buffer);
		st = STATUS_SUCCESS;
	}
	_except(EXCEPTION_EXECUTE_HANDLER)
	{
		st = GetExceptionCode();
	}

__failed:
	if (hDir)
	{
		ZwClose (hDir);
	}
	if (hSymbolic)
	{
		ZwClose (hSymbolic);
	}
	return st;
}


NTSTATUS
FixKernelSDT(
	PVOID pOriginalImageBase,
	PVOID pNewImageBase,
	PSYSTEM_DESCRIPTOR_TABLE* ppNewSdt)
{
	ULONG i;
	ULONG ulRVA;
	ULONG ulDist;
	PSYSTEM_DESCRIPTOR_TABLE NewPsdt;

	KdPrint(("DEBUG: Calling FixKernelSDT \n"));
	CHECK_IRQL

	ulDist = (ULONG)pNewImageBase - (ULONG)pOriginalImageBase;
	NewPsdt = (PSYSTEM_DESCRIPTOR_TABLE)((ULONG)KeServiceDescriptorTable + ulDist);
	_try
	{
		NewPsdt->ntoskrnl.ServiceLimit = KeServiceDescriptorTable->ntoskrnl.ServiceLimit;
		if (KeServiceDescriptorTable->ntoskrnl.CounterTable!=NULL)
		{
			ulRVA = (ULONG)(KeServiceDescriptorTable->ntoskrnl.CounterTable) - (ULONG)pOriginalImageBase;
			NewPsdt->ntoskrnl.CounterTable = (PVOID)(ulRVA + (ULONG)pNewImageBase);
			* (NewPsdt->ntoskrnl.CounterTable) = *(KeServiceDescriptorTable->ntoskrnl.CounterTable);
		}
		if (KeServiceDescriptorTable->ntoskrnl.ArgumentTable!=NULL)
		{
			ulRVA = (ULONG)(KeServiceDescriptorTable->ntoskrnl.ArgumentTable ) -(ULONG)pOriginalImageBase;
			NewPsdt->ntoskrnl.ArgumentTable = (PBYTE)((ULONG)pNewImageBase + ulRVA);
			RtlCopyMemory(NewPsdt->ntoskrnl.ArgumentTable,
							KeServiceDescriptorTable->ntoskrnl.ArgumentTable,
							KeServiceDescriptorTable->ntoskrnl.ServiceLimit);
		}
		if (KeServiceDescriptorTable->ntoskrnl.ServiceTable !=NULL)
		{
			ulRVA = (ULONG)(KeServiceDescriptorTable->ntoskrnl.ServiceTable) - (ULONG)pOriginalImageBase;
			NewPsdt->ntoskrnl.ServiceTable = (PVOID*)((ULONG)pNewImageBase + ulRVA);
			for (i = 0; i< KeServiceDescriptorTable->ntoskrnl.ServiceLimit ; i++)
			{
				(ULONG)(NewPsdt->ntoskrnl.ServiceTable[i]) += ulDist;
				KdPrint(("SST: %x -> 0x%08x \n",i,NewPsdt->ntoskrnl.ServiceTable[i]));
			}
		}
	}
	_except(EXCEPTION_EXECUTE_HANDLER)
	{
		KdPrint(("occur a exception while fix sdt of new kernel error: %x \n",GetExceptionCode()));
		return GetExceptionCode();
	}
	*ppNewSdt = NewPsdt;
	return STATUS_SUCCESS;
}


NTSTATUS MapFileToMem(
	char* chPath,
	PVOID* ppImageBase,
	PULONG pulImageSize)
{
	HANDLE hFile =0;
	OBJECT_ATTRIBUTES FileObjAttr;
	IO_STATUS_BLOCK isb;
	UNICODE_STRING usFilePath;
	ANSI_STRING asFilePath;

	LARGE_INTEGER liOffset;
	IMAGE_DOS_HEADER ImgDosHeader;
	IMAGE_NT_HEADERS ImgNtHeader;
	PIMAGE_SECTION_HEADER pImgSectHeaders = NULL;

	ULONG ulImageSize;
	ULONG ulSizeOfSections;

	ULONG i;
	ULONG ulRvaOfReloc;
	ULONG ulReadLen;
	PVOID pImgBufPoi;

	NTSTATUS st = STATUS_UNSUCCESSFUL;

	KdPrint(("DEBUG: CALLING  MapFileMem \n"));
	CHECK_IRQL

	/*
	 *
	 **/
	if (chPath == NULL || ppImageBase== NULL || pulImageSize==NULL)
	{
		return STATUS_UNSUCCESSFUL;
	}

	RtlInitAnsiString (&asFilePath,chPath);
	
	st = RtlAnsiStringToUnicodeString (&usFilePath,
										&asFilePath,
										TRUE);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("ERROR: Cannot convert ANSI_STRING to UNICODE_STRING [0x%08x]\n",st));
		return st;
	}

	/*
	 *
	 **/

	InitializeObjectAttributes(&FileObjAttr,
								&usFilePath,
								OBJ_KERNEL_HANDLE|OBJ_CASE_INSENSITIVE,
								0,
								NULL);
	st = ZwCreateFile (&hFile,
						FILE_READ_DATA,
						&FileObjAttr,
						&isb,
						NULL,
						FILE_ATTRIBUTE_NORMAL,
						FILE_SHARE_READ,
						FILE_OPEN,
						FILE_NON_DIRECTORY_FILE | FILE_SYNCHRONOUS_IO_NONALERT,
						NULL,
						0);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("ERROR: Cannot open file[0x%08x]",st));
		return st;
	}

	/*
	 *
	 **/
	RtlZeroMemory(&liOffset,sizeof(LARGE_INTEGER));

	st = ZwReadFile (hFile,
					 0,
					 NULL,
					 NULL,
					 &isb,
					 (PVOID)&ImgDosHeader,
					 sizeof(IMAGE_DOS_HEADER),
					 &liOffset,
					 NULL);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("ERROR: Cannot read IMAGE_DOS_HEADER [0x%08x]\n",st));
		goto __clear;
	}
	KdPrint(("DEBUG: Read IMAGE_DOS_HEADER %x/%x\n",isb.Information,sizeof(IMAGE_DOS_HEADER)));

	/*
	 *
	 **/

	liOffset.LowPart = ImgDosHeader.e_lfanew;

	st = ZwReadFile (hFile,
					 0,
					 NULL,
					 NULL,
					 &isb,
					 (PVOID)&ImgNtHeader,
					 sizeof(IMAGE_NT_HEADERS),
					 &liOffset,
					 NULL);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("ERROR: Cannot read IMAGE_NT_HEADERS [0x%08x]\n",st));
		goto __clear;
	}

	KdPrint(("DEBUG : Read IMAGE_NT_HEADERS %x/%x\n",isb.Information,sizeof(IMAGE_NT_HEADERS)));
	/*
	 *
	 **/

	ulImageSize = ImgNtHeader.OptionalHeader.SizeOfImage;

	KdPrint(("DEBUG: size of image is %x \n",ulImageSize));

	pStoreBuffer = ExAllocatePoolWithTag (NonPagedPool,
											ulImageSize,
											'lnrK');
	if (pStoreBuffer == NULL)
	{
		KdPrint(("ERROR: Cannot allocate a buffer to store image \n"));
		st = STATUS_UNSUCCESSFUL;
		goto __clear;
	}

	RtlZeroMemory(pStoreBuffer,ulImageSize);

	ulSizeOfSections = ImgNtHeader.FileHeader.NumberOfSections*sizeof(IMAGE_SECTION_HEADER);

	KdPrint(("DEBUG: size of sections of image is %x \n",ulSizeOfSections));

	pImgSectHeaders =(PIMAGE_SECTION_HEADER)ExAllocatePool (NonPagedPool,
															ulSizeOfSections);
	if (pImgSectHeaders == NULL)
	{
		KdPrint(("EEROR: Cannot allocate a buffer to store sections of image \n"));
		st = STATUS_UNSUCCESSFUL;
		goto __clear;
	}

	RtlZeroMemory(pImgSectHeaders,ulSizeOfSections);

	/*
	 *
	 **/

	liOffset.LowPart = ImgDosHeader.e_lfanew + sizeof(IMAGE_NT_HEADERS);

	st = ZwReadFile (hFile,
					 0,
					 NULL,
					 NULL,
					 &isb,
					 (PVOID)pImgSectHeaders,
					 ulSizeOfSections,
					 &liOffset,
					 NULL);

	if (!NT_SUCCESS(st))
	{
		KdPrint(("ERROR: Cannot read sections table of image [0x%08x] \n",st));
		goto __clear;
	}

	KdPrint(("DEBUG: Read sections table of image %x/%x \n",isb.Information,ulSizeOfSections));
	/*
	 *
	 **/

	/*
	 * we calculate the rva of relocation block cuz we just wanna load a section
	 * which attribute must be not discardable and including code , or it must be
	 * a relocation section . nothing else we will load , just fill the memory of
	 * section with 0xcc == int 3
	 **/
	ulRvaOfReloc = ImgNtHeader.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC].VirtualAddress;

	RtlZeroMemory(&liOffset,sizeof(LARGE_INTEGER));
	for (i=0 ; i< ImgNtHeader.FileHeader.NumberOfSections ; i++)
	{
		liOffset.LowPart = pImgSectHeaders[i].PointerToRawData;
		(ULONG)pImgBufPoi = (ULONG)pStoreBuffer + pImgSectHeaders[i].VirtualAddress;
		ulReadLen = _min(pImgSectHeaders[i].SizeOfRawData,
						  pImgSectHeaders[i].Misc.VirtualSize);

		KdPrint(("DEBUG: READ SECTION \n  Name: %s\n  RawOffset: 0x%08x\n  RawSize: 0x%08x\n  Rva: 0x%08x\n  VSize: 0x%08x\n  WriteTo: 0x%08x \n ",
				pImgSectHeaders[i].Name,
				pImgSectHeaders[i].PointerToRawData,
				pImgSectHeaders[i].SizeOfRawData,
				pImgSectHeaders[i].VirtualAddress,
				pImgSectHeaders[i].Misc.VirtualSize,
				pImgBufPoi));
			/*
			 * a resent code section
			 **/
		if ((!(pImgSectHeaders[i].Characteristics & IMAGE_SCN_MEM_DISCARDABLE) &&
			(pImgSectHeaders[i].Characteristics & IMAGE_SCN_CNT_CODE)) ||
			/*
			 * a relocation section
			 **/
			pImgSectHeaders[i].VirtualAddress == ulRvaOfReloc)
		{
			st = ZwReadFile(hFile,
							0,
							NULL,
							NULL,
							&isb,
							pImgBufPoi,
							ulReadLen,
							&liOffset,
							NULL);
			if (!NT_SUCCESS(st))
			{
				KdPrint(("ERROR: Read this section failed [0x%08x] \n",st));
				goto __clear;
			}
			KdPrint(("DEBUG: Read this section success %x/%x \n ",isb.Information,ulReadLen));
		}
		else
		{
			//fill this section with 0xcc == int 3
			RtlFillMemory(pImgBufPoi,
						  pImgSectHeaders[i].Misc.VirtualSize,
						  0xcc);
			KdPrint(("DEBUG: A section that could be discardable or not including any code \n\n"));
		}
		
	}

	/*
	 *
	 **/

	RtlZeroMemory(&liOffset,sizeof(LARGE_INTEGER));
	
	st = ZwReadFile (hFile,
					0,
					NULL,
					NULL,
					&isb,
					pStoreBuffer,
					ImgNtHeader.OptionalHeader.SizeOfHeaders,
					&liOffset,
					NULL);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("ERROR: Cannot read HEADERS of image [0x%08x] \n",st));
		goto __clear;
	}

	KdPrint(("DEBUG: Read Headers %x/%x \n",isb.Information,ImgNtHeader.OptionalHeader.SizeOfHeaders));

	KdPrint(("DEBUG: Complete read file to memory \n"));

	*ppImageBase = pStoreBuffer;
	*pulImageSize = ulImageSize;

__clear:
	if (pImgSectHeaders)
	{
		ExFreePool (pImgSectHeaders);
	}
	if (hFile)
	{
		ZwClose (hFile);
		hFile = NULL;
	}
	return st;
}

NTSTATUS LoadKernel(
	PLOADED_KERNEL_INFO plki)
{
	NTSTATUS st;
	SYSTEM_MODULE_INFORMATION smi;

	PVOID pImageBase;
	ULONG ulImageSize;
	PSYSTEM_DESCRIPTOR_TABLE NewPsdt;

	char chSystemDir[256]={0};
	char chPath[256]="\\DosDevices\\";
	char* chTemp =NULL;

	KdPrint(("DEBUG: Calling  LoadKernel \n"));
	CHECK_IRQL

	/*
	 *verify params
	 **/
	if (plki == NULL)
	{
		return STATUS_UNSUCCESSFUL;
	}
	
	/*
	 * 1:try to get current info of current kernel
	 * */
	st = GetModuleInfo ( "ntkrnlpa.exe",&smi);

	if (!NT_SUCCESS(st))
	{
		st = GetModuleInfo ("ntoskrnl.exe",&smi);
		if (!NT_SUCCESS(st))
		{
			return st;
		}
	}
	/*
	 * 2:combine path with system root directory
	 **/


	st = GetSystemDir ( chSystemDir);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("get system directory failed \n"));
		return st;
	}
	chTemp = strstr( _strupr (smi.ImageName) , _strupr (&chSystemDir[2]));
	if (chTemp == NULL)
	{
		KdPrint(("invalid path ! \n"));
		return STATUS_UNSUCCESSFUL;
	}
	strcat(chSystemDir,(char*)((ULONG)chTemp + strlen (&chSystemDir[2])));
	strcat(chPath , chSystemDir);
	
	/*
	 * 3:map file
	 **/
	//st = MapFileToMem ("C:\\windows\\system32\\ntkrpamp.exe",&pImageBase,&ulImageSize);
	st = MapFileToMem ( chPath , &pImageBase , &ulImageSize);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("cannot map file to memory 0x%x \n",st));
		return st;
	}


	/*
	 * 5:fix info of relocation of new kernel with reference base equals to original kernel base
	 **/
	st = RelocModule (pImageBase , smi.Base);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("cannot relocate the new kernel \n"));
		return st;
	}

	/*
	 * 6: fix sdt of new kernel
	 **/
	st = FixKernelSDT (smi.Base,pImageBase,&NewPsdt);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("cannot fix the sdt of the new kernel \n"));
		return st;
	}

	/*
	 * remove header of PE
	 **/
	RemovePEHeader (pImageBase);

	/*
	 * 7: copy result to caller
	 **/
	plki->NewPsdt = (PVOID)NewPsdt;
	plki->NewKernelBase = pImageBase;
	plki->OriginalKernelBase = smi.Base;

	return STATUS_SUCCESS;
}

void UnloadKernel()
{

	if (pStoreBuffer)
	{
		ExFreePoolWithTag ( pStoreBuffer,'lnrK');
	}
}
