#include <ntifs.h>
#include <WINDEF.H>
#include <strsafe.h>


#include "CommonFunc.h"
#include "KrnlLdr.h"
#include "Verify.h"

#pragma warning(disable:4731)

#define VERIFY_HANDLE (HANDLE)0xAAAAAAAA

#define DEVICE_NAME_KERNEL L"\\Device\\damn"
#define DEVICE_NAME_WIN32 L"\\DosDevices\\damn"
#define DEVICE_NAME_USER L"\\\\.\\damn"

#define CTL_SET_SUPER_PARENT_PROC \
			CTL_CODE(FILE_DEVICE_UNKNOWN,0x999,METHOD_BUFFERED,FILE_ANY_ACCESS)

typedef
NTSTATUS
	(NTAPI* _Close)(
	IN HANDLE h
	);


/*
 * Global variables
 **/

#pragma pack(1)

BYTE  OriginalCode_KiFast[5];
BOOLEAN bHooked =FALSE;

#pragma pack()


_Close pNtClose;
ULONG* ulNewSSTAddr;
ULONG ulNumOfSSTEntry;
ULONG* ulOldSSTAddr;


PVOID HookAddrOfKiFastCallEntry;
PVOID JmpAddr;

PDEVICE_OBJECT pdo;
UNICODE_STRING usSymbolicName;

extern PSYSTEM_DESCRIPTOR_TABLE KeServiceDescriptorTable;

ULONG __stdcall VerifyCall(
	ULONG OriginalFuncAddr,
	ULONG* SSTTable,
	ULONG ulIndex)
{

	//KdPrint(("DEBUG --> Table[0x%08x] Index[0x%08x] \n",SSTTable,ulIndex));
	if (SSTTable == ulOldSSTAddr && ulIndex < ulNumOfSSTEntry)
	{
		if (VerifyCaller ((ULONG)PsGetCurrentProcessId ()) || VerifyCallIndex (ulIndex))
		{
			/*KdPrint(("DEBUG: Redirect[0x%04x] [o 0x%08x]->[n 0x%08x] \n ",ulIndex,SSTTable[ulIndex ],ulNewSSTAddr[ulIndex]));*/
			return ulNewSSTAddr[ulIndex];
		}
	}
	return OriginalFuncAddr;
}

_declspec(naked)  void RedirectCallEntry()
/*
 *Function:
 *	this function will be called in KiFastCallEntry , we will check the caller process 
 *	if the process is protected by us , we will change address of function which caller
 *	wanna call by fixing value of ebx , force it to point to our function in new SDT.
 *	cuz we wanna bypass all the hooks in original kernel
 **/
{
	_asm
	{
		mov edi,edi
		pushfd
		pushad


		push eax
		push edi
		push ebx
		call VerifyCall
		mov [esp+0x10],eax

		popad
		popfd

		sub esp,ecx
		shr ecx,2
		push [JmpAddr]
		ret
	}

}


void HookKiFastCallEntry(
	ULONG ulStartAddrOfSearch)
/*
 *Function:
 *	we will try to hook KiFastCallEntry by modifying 5 bytes in that function
 *	to another instruction which looks like CALL XXXX
 *	
 *Params:
 *	pStartAddrOfSearch:
 *		To search the address where we should hook , this argument specify the starting address
 *		
 *Note:
 *	the sign of instructions is
 *	sub esp,ecx
 *	shr ecx,2
 *	
 *	the eax point to INDEX
 *	the ebx point to ADDRESS OF FUNCTION
 **/
{
	KSPIN_LOCK lock;
	KIRQL irql;
	PMDL  pmdl;
	BOOLEAN bLocked  =FALSE;
	ULONG pTempAddr;
	BYTE  Code[5]={0xE9,0,0,0,0};

	KdPrint(("DEBUG: calling  HookKiFastCallEntry \n"));
	CHECK_IRQL

	for ( pTempAddr = (ULONG)ulStartAddrOfSearch ; pTempAddr > ulStartAddrOfSearch  - 0x100 ; pTempAddr--)
	{
		_try
		{
			/*
			*80542605 2be1            sub     esp,ecx
			*80542607 c1e902          shr     ecx,2
			**/
			if (*(PBYTE)(pTempAddr) == 0x02 &&
				*(PBYTE)(pTempAddr -1) == 0xE9 &&
				*(PBYTE)(pTempAddr -2) == 0xC1 &&
				*(PBYTE)(pTempAddr -3) == 0xE1 &&
				*(PBYTE)(pTempAddr -4) == 0x2B)
			{
				pTempAddr -=4;
				break;
			}
		}
		_except(EXCEPTION_EXECUTE_HANDLER)
		{
			continue;
		}
	}
	//fill code
	*(ULONG*)(Code +1) = (ULONG)RedirectCallEntry - pTempAddr -5;
	//store address
	HookAddrOfKiFastCallEntry = (PVOID)pTempAddr;
	//store jump address
	JmpAddr = (PVOID)((ULONG)HookAddrOfKiFastCallEntry + 5);

	KdPrint(("DEBUG: confirm the address of hooking : 0x%x JmpAddress: 0x%08x \n",HookAddrOfKiFastCallEntry,JmpAddr));


	/*
	 * test whether we should lock the pages
	 *
	 **/
	if (MmIsAddressValid ((PVOID)HookAddrOfKiFastCallEntry))
	{
		goto __nolock;
	}

	/*
	 * lock it
	 **/
	pmdl = IoAllocateMdl ((PVOID)HookAddrOfKiFastCallEntry,
							5,
							FALSE,
							FALSE,
							NULL);
	if (pmdl == NULL)
	{
		KdPrint(("ERROR: Cannot allocate a mdl for hook address of KiFastCallEntry \n"));
		return ;
	}

	_try
	{
		MmProbeAndLockPages (pmdl,KernelMode,IoReadAccess);
	}
	_except(EXCEPTION_EXECUTE_HANDLER)
	{
		KdPrint(("EXCEPTION: Cannot lock pages of hook address of KiFastCallEntry [0x%08x]\n",GetExceptionCode()));
		return ;
	}
	bLocked = TRUE;
	
	KdPrint(("DEBUG: Locked pages of hook adrdress of KiFastCallEntry \n"));

	/*
	 * if we do not need to lock the pages
	 **/
__nolock:	
	KeInitializeSpinLock (&lock );
	
	KeAcquireSpinLock(&lock,&irql);
	PageProtectOff ();

	RtlCopyMemory( OriginalCode_KiFast,
					HookAddrOfKiFastCallEntry,
					5);
	RtlCopyMemory( HookAddrOfKiFastCallEntry ,
					Code ,
					5);

	PageProtectOn ();
	KeReleaseSpinLock (&lock,irql);
	
	/*
	 * unlock it
	 **/
	if (bLocked)
	{
		MmUnlockPages (pmdl);
		IoFreeMdl (pmdl);
	}


	/*
	 *
	 **/
	KdPrint(("success hook KifastCallEntry \n"));
	bHooked = TRUE;

}


ULONG ReplaceSSTFunc(
	ULONG Table,
	ULONG Index,
	ULONG ReplaceFunc)
{
	KSPIN_LOCK lock;
	KIRQL irql;
	ULONG ulOrig;
	ULONG AddrToReplace = Table+Index*4;

	KeInitializeSpinLock (&lock);
	KeAcquireSpinLock(&lock,&irql);
	PageProtectOff ();

	ulOrig = InterlockedExchange((PLONG)AddrToReplace,(LONG)ReplaceFunc);

	PageProtectOn ();
	KeReleaseSpinLock (&lock,irql);

	return ulOrig;
}

NTSTATUS
__stdcall Fake_NtClose(
	IN HANDLE h)
{
	ULONG AddrToUsed;


	KdPrint(("DEBUG: Fake_NtClose-> Handle[0x%x] Mode[%s] \n",h,ExGetPreviousMode ()==UserMode? "UserMode":"KernelMode"));
	if (h == VERIFY_HANDLE && ExGetPreviousMode ()!= UserMode)
	{
		_asm
		{
			push eax
			mov  eax,[ebp+4]
			mov  AddrToUsed,eax
			pop  eax
		}
		return (NTSTATUS)AddrToUsed;
	}

	return pNtClose(h);
}

ULONG __stdcall GetHookStartAddress()
{
	ULONG ulIndex;
	ULONG AddrToUsed = 0;
	PVOID pZwClose = GetSystemRoutineAddress (L"ZwClose");

	if (pZwClose==NULL)
	{
		KdPrint(("DEBUG: Cannot get address of ZwClose \n"));
		goto __retn;
	}

	ulIndex = *(ULONG*)((PUCHAR)ZwClose + 1);

	_try
	{
		
		/*
		 * Hook NtClose
		 **/
		pNtClose = (_Close)ReplaceSSTFunc ((ULONG)(KeServiceDescriptorTable->ntoskrnl.ServiceTable),
											ulIndex,
											(ULONG)Fake_NtClose);

		KdPrint(("DEBUG: Success  hook  NtClose[Index:0x%x Address:0x%08x] \n",ulIndex,pNtClose));

		/*
		 *Generation
		 **/
		AddrToUsed = (ULONG)ZwClose (VERIFY_HANDLE);

		/*
		 * unhook it
		 **/
		ReplaceSSTFunc ((ULONG)(KeServiceDescriptorTable->ntoskrnl.ServiceTable),
						ulIndex,
						(ULONG)pNtClose);
		KdPrint(("DEBUG: Success unhook of NtClose \n"));

	}
	_except(EXCEPTION_EXECUTE_HANDLER)
	{
		KdPrint(("EXCEPTION: occur a exception while processing hook [0x%08x] \n",GetExceptionCode()));
	}

__retn:
	return AddrToUsed;
}


void UnhookAllHooks()
{
	KIRQL irql;
	KSPIN_LOCK lock;

	KeInitializeSpinLock (&lock);
	

	PageProtectOff ();

	if (bHooked)
	{
		KeAcquireSpinLock( &lock , &irql);

		RtlCopyMemory( HookAddrOfKiFastCallEntry , OriginalCode_KiFast ,5);

		KeReleaseSpinLock (&lock,irql);
	}
	PageProtectOn ();
	
}


void ProcessMonitor(
	IN HANDLE  ParentId,
	IN HANDLE  ProcessId,
	IN BOOLEAN  Create)
{

	KdPrint(("DEBUG: calling ProcessMonitor \n"));
	CHECK_IRQL
	/*
	 *ܱ̣ӽҲܵ or ɾ
	 **/
	if(!VerifyCaller ((ULONG)ParentId))
	{
		return;
	}

	if (Create)
	{
		KdPrint(("DEBUG : process[%d] add to protection list \n",ProcessId));
		AddProcVerify ((ULONG)ProcessId);
	}
	else
	{
		KdPrint(("DEBUG : process[%d] delete from protection list\n",ProcessId));
		DeleteProcVerify ((ULONG)ProcessId);
	}
	
}

NTSTATUS DispatchRoutine(
	PDEVICE_OBJECT pdo,
	PIRP Irp)
{
	PIO_STACK_LOCATION pisl;
	ULONG dwPid;

	pisl = IoGetCurrentIrpStackLocation (Irp);

	if (pisl->Parameters.DeviceIoControl.IoControlCode == CTL_SET_SUPER_PARENT_PROC &&
		Irp->AssociatedIrp.SystemBuffer!=NULL &&
		pisl->Parameters.DeviceIoControl.InputBufferLength == sizeof(DWORD))
	{
		dwPid = *(ULONG*)Irp->AssociatedIrp.SystemBuffer;
		AddProcVerify (dwPid);
	}

	Irp->IoStatus.Information = 0;
	Irp->IoStatus.Status = STATUS_SUCCESS;
	IoCompleteRequest(Irp,IO_NO_INCREMENT);
	return STATUS_SUCCESS;
}

void OnUnload(PDRIVER_OBJECT Driver)
{
	
	/*
	 *delete something
	 **/
	IoDeleteDevice (pdo);
	IoDeleteSymbolicLink (&usSymbolicName);
	/*
	 * Remove monitor
	 **/
	PsSetCreateProcessNotifyRoutine ((PCREATE_PROCESS_NOTIFY_ROUTINE)ProcessMonitor , TRUE);

	/*
	 * Unload all hooks
	 **/
	UnhookAllHooks();

	/*
	 * Uninitialize verify module
	 **/
	UninitVerify ();

	/*
	 * Unload new kernel
	 **/
	UnloadKernel ();

}

NTSTATUS DriverEntry(
	PDRIVER_OBJECT Driver,
	PUNICODE_STRING pusRegPath)
{
	BOOLEAN bLoadedKernel = FALSE;
	BOOLEAN bHooked = FALSE;
	BOOLEAN bInitverify = FALSE;
	BOOLEAN bSetmoniter = FALSE;
	BOOLEAN bCreatedDevice = FALSE;
	UNICODE_STRING usDeviceName;
	ULONG	i;
	LOADED_KERNEL_INFO lki;
	NTSTATUS st = STATUS_UNSUCCESSFUL;			
	ULONG ulStartOfKiFastCallEntry;

	Driver->DriverUnload = OnUnload ;
	/*
	 *
	 **/

	ulStartOfKiFastCallEntry = GetHookStartAddress ();
	if (!MmIsAddressValid ((PVOID)ulStartOfKiFastCallEntry))
	{
		KdPrint(("ERROR: Cannot get address of KiFastCallEntry \n"));
		goto __failed;
	}
	KdPrint(("DEBUG: Is 0x%08x in KiFastCallEntry \n",ulStartOfKiFastCallEntry));

	/*
	 *
	 **/
	st = LoadKernel (&lki);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("loaded kernel failed 0x%x \n",st));
		goto __failed;
	}
	bLoadedKernel = TRUE;

	/*
	 * calculate the new sst address
	 **/

	KdPrint(("New Kernel: 0x%x Original Kernel : 0x%X \n",lki.NewKernelBase,lki.OriginalKernelBase));

	ulNewSSTAddr = (ULONG*)((PSYSTEM_DESCRIPTOR_TABLE)lki.NewPsdt)->ntoskrnl.ServiceTable;
	ulOldSSTAddr = (ULONG*)(KeServiceDescriptorTable->ntoskrnl.ServiceTable);

	ulNumOfSSTEntry = ((PSYSTEM_DESCRIPTOR_TABLE)lki.NewPsdt)->ntoskrnl.ServiceLimit ;
	KdPrint(("NewSSTAddr: 0x%X  OldSSTAddr: 0x%08x \n",ulNewSSTAddr,ulOldSSTAddr));


	/*
	 * 
	 **/
	if (!InitVerify ())
	{
		KdPrint(("ERROR: Cannot initialize verify module \n"));
		goto __failed;
	}
	bInitverify = TRUE;
	/*
	 *  start hooking
	 **/

	/*ulStartOfKiFastCallEntry = 0x8054261c;*/
	HookKiFastCallEntry(ulStartOfKiFastCallEntry);
	bHooked = TRUE;

	/*
	 *
	 **/
	st = PsSetCreateProcessNotifyRoutine ((PCREATE_PROCESS_NOTIFY_ROUTINE)ProcessMonitor,
											FALSE);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("ERROR: Cannot set process monitor [0x%08x] \n",st));
		goto __failed;
	}
	bSetmoniter = TRUE;

	/*
	 *create device and symbolic
	 **/

	RtlInitUnicodeString (&usDeviceName,DEVICE_NAME_KERNEL);
	st = IoCreateDevice (Driver,
									0,
									&usDeviceName,
									FILE_DEVICE_UNKNOWN,
									0,
									FALSE,
									&pdo);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("ERROR: Cannot create device [%x]\n",st));
		goto __failed;
	}
	bCreatedDevice = TRUE;
	RtlInitUnicodeString (&usSymbolicName,DEVICE_NAME_WIN32);
	st = IoCreateSymbolicLink (&usSymbolicName,&usDeviceName);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("ERROR: Cannot create symbolic [%x]\n",st));
		goto __failed;
	}
	for (i=0;i<IRP_MJ_MAXIMUM_FUNCTION;i++)
	{
		Driver->MajorFunction[i] = DispatchRoutine;
	}
	pdo->Flags &= ~ DO_DEVICE_INITIALIZING;

	return STATUS_SUCCESS;

__failed:
	if (bCreatedDevice)
	{
		IoDeleteDevice (pdo);
		IoDeleteSymbolicLink (&usSymbolicName);
	}
	if (bSetmoniter)
	{
		PsSetCreateProcessNotifyRoutine ((PCREATE_PROCESS_NOTIFY_ROUTINE)ProcessMonitor,TRUE);
	}
	if (bHooked)
	{
		UnhookAllHooks ();
	}
	if (bInitverify)
	{
		UninitVerify ();
	}
	if (bLoadedKernel)
	{
		UnloadKernel ();
	}
	return STATUS_UNSUCCESSFUL;
}