#include <ntddk.h>
#include <WINDEF.H>
#include <strsafe.h>

#include "CommonFunc.h"

_QuerySystemInformation NtQuerySystemInforamtion;

extern PSYSTEM_DESCRIPTOR_TABLE KeServiceDescriptorTable;

NTSTATUS GetModuleInfo(
	char*	chModName,
	PSYSTEM_MODULE_INFORMATION	psmi)
/*
*Function:
*	try to get info of a module specified by chModName 
*	
*Params:
*	chModName:
*		name of module
*	psmi:
*		the buffer that receive info of module
*		
*Return Value:
*	status value
**/
{
	NTSTATUS					st;
	LOADED_MOD_INFO*			plmi;
	ULONG						ulInfoLen;
	ULONG						i;
	char*						s;
	ULONG						ulOffet;
	UNICODE_STRING				usFuncName;


	KdPrint(("DEBUG: calling GetModuleInfo \n"));
	CHECK_IRQL

	//verify params
	if (psmi == NULL || chModName==NULL)
	{
		return STATUS_UNSUCCESSFUL;
	}

	//try to get address of NtQuerySystemInformation
	if (NULL == NtQuerySystemInforamtion)
	{
		
		RtlInitUnicodeString ( &usFuncName, L"NtQuerySystemInformation");
		NtQuerySystemInforamtion = (_QuerySystemInformation)MmGetSystemRoutineAddress (&usFuncName);

		if (!NtQuerySystemInforamtion)
		{
			KdPrint(("cannot get NtQuerySystemInformation \n"));
			return STATUS_UNSUCCESSFUL;
		}
	}
	KdPrint(("NtQueryInfomation[%X] \n",NtQuerySystemInforamtion));

	st = NtQuerySystemInforamtion( SystemModuleInformation,
									NULL,
									0,
									&ulInfoLen);
	if (!ulInfoLen)
	{
		return STATUS_UNSUCCESSFUL;
	}

	plmi = (LOADED_MOD_INFO*)ExAllocatePool (NonPagedPool, ulInfoLen+sizeof(ULONG));
	
	if (plmi->pmi == NULL)
	{
		return STATUS_UNSUCCESSFUL;
	}

	st = NtQuerySystemInforamtion(SystemModuleInformation,
								   (PVOID)plmi,
								   ulInfoLen,
								   &ulInfoLen);
	if (!NT_SUCCESS(st))
	{
		KdPrint(("Query info of modules failed 0x%X \n",st));
		return st;
	}
	//find to module we want
	for (i=0 ; i< plmi->ulCount ; i++)
	{
		s= plmi->pmi[i].ImageName;
		ulOffet = plmi->pmi->ModuleNameOffset;
		if (strcmp (_strupr (&s[ulOffet]),_strupr (chModName))==0)
		{
			_try
			{
				RtlCopyMemory( psmi,&(plmi->pmi[i]),sizeof(SYSTEM_MODULE_INFORMATION));
			}
			_except(EXCEPTION_EXECUTE_HANDLER)
			{
				return GetExceptionCode();
			}
		}
		KdPrint(("Path: %s \n Base:0x%X \n Size:0x%X \n",plmi->pmi->ImageName,plmi->pmi->Base,plmi->pmi->Size));
		return STATUS_SUCCESS;
	}

	return STATUS_UNSUCCESSFUL;
}


PVOID GetSystemRoutineAddress(
	WCHAR* wchFuncName)
{
	UNICODE_STRING usFuncName;
	RtlInitUnicodeString (&usFuncName ,wchFuncName);

	return MmGetSystemRoutineAddress (&usFuncName);
}

PVOID GetSystemRoutineAddressFromSDT(
	ULONG ulIndex)
{
	return KeServiceDescriptorTable->ntoskrnl.ServiceTable[ulIndex];
}


void PageProtectOn()
{
	_asm
	{
		mov eax,cr0
		or  eax,0x10000
		mov cr0,eax
		sti
	}
}

void PageProtectOff ()
{
	_asm
	{
		cli
		mov eax,cr0
		and eax,not 0x10000
		mov cr0,eax
	}
}