/*++

Module Name:

	ListSSDT.h

Abstract:

	This module defines all structs and functions used by ListSSDT.c.

--*/

#ifndef _LIST_SSDT_H_
#define _LIST_SSDT_H_

#include <ntifs.h>


//
//	definitions
//


#define DBG_ERROR			0x00
#define DBG_INFORMATION		0x01

#ifndef DWORD
#define DWORD ULONG
#endif

#ifndef WORD
#define WORD USHORT
#endif

#define IMAGE_DIRECTORY_ENTRY_EXPORT	0
#define IMAGE_DIRECTORY_ENTRY_BASERELOC	5


//
// structs
//

typedef struct _SSDT_ENTRY
{
	PULONG SSDTBase;
	PUCHAR CounterTable;
	ULONG NumOfServ;
	PUCHAR ParamTableBase;
}SSDT_ENTRY,*PSSDT_ENTRY;


//
//	PE file struct
//

typedef struct _IMAGE_EXPORT_DIRECTORY{
	DWORD Characteristics;
	DWORD TimeDateStamp;
	WORD MajorVersion;
	WORD MinorVersion;
	DWORD Name;
	DWORD Base;
	DWORD NumberOfFunctions;
	DWORD NumberOfNames;
	DWORD AddressOfFunctions;
	DWORD AddressOfNames;
	DWORD AddressOfNameOrdinals;
}IMAGE_EXPORT_DIRECTORY,*PIMAGE_EXPORT_DIRECTORY;



typedef struct _SYSTEM_MODULE_INFORMATION_ENTRY {
    HANDLE Section;
    PVOID MappedBase;
    PVOID Base;
    ULONG Size;
    ULONG Flags;
    USHORT LoadOrderIndex;
    USHORT InitOrderIndex;
    USHORT LoadCount;
    USHORT PathLength;
    CHAR ImageName[256];
} SYSTEM_MODULE_INFORMATION_ENTRY, *PSYSTEM_MODULE_INFORMATION_ENTRY;


//
//	dll import function, but we must declare it by 
//	ourselves before use
//

NTSTATUS
ZwQuerySystemInformation(
	IN ULONG InformationClass,
	IN OUT PVOID Buffer,
	IN ULONG BufferSize,
	OUT PULONG ReturnValue);   

PVOID 
RtlImageDirectoryEntryToData(
	IN PVOID ImageBase, 
	IN BOOLEAN MappedAsImage, 
	IN USHORT DirectoryEntry, 
	OUT PULONG Size);


//
//	declare the functions
//	implement in ListSSDT.c
//

NTSTATUS 
GetNeedLength(
	OUT PULONG pNameLength,
	OUT PULONG pAddrLength);

NTSTATUS 
GetSSDTInfo(
	OUT PVOID pFuncName,
	OUT PVOID pFuncAddr,
	OUT PULONG pAddrOrig);

NTSTATUS
LoadFile(
	IN PWCH FilePath,
	OUT PVOID * FileBuffer);

NTSTATUS
GetFuncName(
	IN PVOID FileBuffer,
	OUT PCHAR FuncName);

NTSTATUS
GetFuncAddr(
	IN PVOID FileBuffer,
	OUT PULONG FuncAddr);

NTSTATUS
GetModuleByIndex(
	IN ULONG Index,
	OUT PCHAR ModuleName,
	OUT PULONG ModuleBase);

VOID
AnsiToUnicode(
	OUT PWCH Unicode,
	IN PCHAR Ansi);

ULONG
GetExportData(
	IN PVOID FileBase,
	IN PCHAR DataName);

LONG 
StringCompare(
	IN PCHAR Str1,
	IN PCHAR Str2);

ULONG
GetImageBase(
	IN Buffer);

ULONG
GetServiceTableAddress(
	IN PVOID Buffer,
	IN ULONG Offset);

#endif