/*++

Module Name:

	Entry.c

Abstract:

	A sample with ListSSDT.c .

--*/

#include "ListSSDT.h"



//
//	function declaration
//

DRIVER_UNLOAD UnloadMe;
DRIVER_INITIALIZE DriverEntry;

#ifdef ALLOC_PRAGMA

#pragma alloc_text(INIT, DriverEntry)
#pragma alloc_text(PAGE, UnloadMe)

#endif

NTSTATUS 
DriverEntry(
	IN PDRIVER_OBJECT DriverObject,
	IN PUNICODE_STRING RegistryPath)
/*++

Routine Description:

	Entry of driver.

Arguments:

	DriverObject - Pointer to driver object created by system.
	RegistryPath - Pointer to the Unicode name of the registry path
		for this driver.

Return Value:

	NT Status code

--*/
{
	NTSTATUS Status;
	ULONG NameLength;
	ULONG AddrLength;
	PVOID NameBuffer;
	PVOID AddrBuffer;
	PVOID AddrOrig;
	ULONG i;
	
	//
	//
	//Important Variables:
	//
	//	NameBuffer - Buffer to receive the function names of SSDT.
	//	AddrBuffer - Buffer to receive the current function address of SSDT.
	//	AddrOrig - Buffer to receive the original function address of SSDT.
	//
	//
	
	UNREFERENCED_PARAMETER( RegistryPath );

	//
	//	driver initialization
	//

	DriverObject->DriverUnload = UnloadMe;


	//
	//	get the size of all information.
	//

	Status = GetNeedLength( &NameLength, &AddrLength);

	if(!NT_SUCCESS(Status))
	{
		return Status;
	}

	//
	//	allocate memory
	//

	NameBuffer = ExAllocatePoolWithTag(NonPagedPool, NameLength, 'name');
	AddrBuffer = ExAllocatePoolWithTag(NonPagedPool, AddrLength, 'addr');
	AddrOrig = ExAllocatePoolWithTag(NonPagedPool, AddrLength, 'orig');

	if(NameBuffer == NULL)
	{
		return STATUS_UNSUCCESSFUL;
	}

	if(AddrBuffer == NULL)
	{
		ExFreePool(NameBuffer);
		return STATUS_UNSUCCESSFUL;
	}
	
	if(AddrOrig == NULL)
	{
		ExFreePool(NameBuffer);
		ExFreePool(AddrBuffer);
		return STATUS_UNSUCCESSFUL;
	}

	//
	//	get information
	//

	Status = GetSSDTInfo(NameBuffer, AddrBuffer, AddrOrig);


	//
	//	print result
	//

	if(NT_SUCCESS(Status))
	{
		for( i = 0; i < AddrLength/4; i++)
		{
			DbgPrint("%3d\t\t%s\t\t\t0x%08x\t0x%08x\n", 
					 i, 
					 (ULONG)NameBuffer + i * 0x32, 
					 *(PULONG)((ULONG)AddrOrig + i * 0x04),
					 *(PULONG)((ULONG)AddrBuffer + i * 0x04));
		}
	}


	//
	//	free memory
	//

	if(NameBuffer != NULL)
	{
		ExFreePool(NameBuffer);
		NameBuffer = NULL;
	}

	if(AddrBuffer != NULL)
	{
		ExFreePool(AddrBuffer);
		AddrBuffer = NULL;
	}
	if(AddrOrig != NULL)
	{
		ExFreePool(AddrOrig);
		AddrBuffer = NULL;
	}

	return Status;
}

VOID 
UnloadMe(
	IN PDRIVER_OBJECT DriverObject)
{
	UNREFERENCED_PARAMETER( DriverObject ); 

	//
	//	nothing to do
	//
}