#include "stdafx.h"
#include "MainUI.h"
#include "Command/MainWinCmd.h"
#include "CVCR3.h"
#include "Debug.h"

void DisplayFlush(RECT rc){
	EnterCriticalSection(&CVCR3.DisplayR3.cs); 

	InvalidateRect(CVCR3.DisplayR3.hWnd,&rc,FALSE);

	LeaveCriticalSection(&CVCR3.DisplayR3.cs); 
}

void CALLBACK TimerDisplayFlash(HWND,UINT,UINT,DWORD){
	EnterCriticalSection(&CVCR3.DisplayR3.cs); 
	CVCR3.DisplayR3.FlashRect.left = CVCR3.DisplayR3.VDisplayRect.left;
	CVCR3.DisplayR3.FlashRect.top = CVCR3.DisplayR3.VDisplayRect.top;
	CVCR3.DisplayR3.FlashRect.right = CVCR3.DisplayR3.VDisplayRect.right;
	CVCR3.DisplayR3.FlashRect.bottom = CVCR3.DisplayR3.VDisplayRect.bottom;

	//ǰģʽĬΪalphanumeric mode
	DrawWithANMode();

	LeaveCriticalSection(&CVCR3.DisplayR3.cs); 

	DisplayFlush(CVCR3.DisplayR3.VDisplayRect);
}

void DrawWithANMode(){
	HGDIOBJ hOldObj;
	HFONT hOldFont;
	int BoxWidth = CVCR3.DisplayR3.ANM.CharBoxWidth;
	int BoxHeight = CVCR3.DisplayR3.ANM.CharBoxHeight;
	int HCharCount = CVCR3.DisplayR3.DisplayHPixel/BoxWidth;
	int VCharCount = CVCR3.DisplayR3.DisplayVPixel/BoxHeight;
	int cv,ch;
	char CurChar;
	char CurAttr;
	WCHAR CurUChar;
	RECT CursorRect;
	int v;

	hOldObj = SelectObject(CVCR3.DisplayR3.hMemDC, CVCR3.DisplayR3.hMemBitmap);
	hOldFont = (HFONT)SelectObject(CVCR3.DisplayR3.hMemDC,CVCR3.DisplayR3.ANM.hFont);
	SetTextColor(CVCR3.DisplayR3.hMemDC,RGB(255,255,255));
	SetBkColor(CVCR3.DisplayR3.hMemDC,RGB(0,0,0));
	for(cv = 0;cv < VCharCount;cv++)
	{
		for(ch = 0;ch < HCharCount;ch++)
		{
			CurChar = *(CVCR3.DisplayR3.pVideoMem + cv * HCharCount * 2 + ch * 2);
			CurAttr = *(CVCR3.DisplayR3.pVideoMem + cv * HCharCount * 2 + ch * 2 + 1);
			CurUChar = (WCHAR)CurChar;
			//TRACE(L"%c\n",CurUChar);
			TextOut(CVCR3.DisplayR3.hMemDC,ch*BoxWidth,cv*BoxHeight,&CurUChar,1);
		}
	}

	//
	//ÿ2
	if(CVCR3.DisplayR3.ANM.DrawCount % (DISPLAY_FLASH_FREQ / 2) == 0){
		CursorRect.left = CVCR3.DisplayR3.ANM.CursorChar_X * CVCR3.DisplayR3.ANM.CharBoxWidth;
		CursorRect.top = CVCR3.DisplayR3.ANM.CursorChar_Y * CVCR3.DisplayR3.ANM.CharBoxWidth + 6;
		CursorRect.right = CursorRect.left +  CVCR3.DisplayR3.ANM.CharBoxWidth;
		CursorRect.bottom = CursorRect.top + 2;
		FillRect(CVCR3.DisplayR3.hMemDC,&CursorRect,CVCR3.DisplayR3.ANM.hBrushCursor);
	}
	CVCR3.DisplayR3.ANM.DrawCount++;

	SelectObject(CVCR3.DisplayR3.hMemDC,hOldFont);
	SelectObject(CVCR3.DisplayR3.hMemDC,hOldObj);
}

void CreateANMFont(){
  LOGFONT lf;

  lf.lfWidth = CVCR3.DisplayR3.ANM.CharWidth;
  lf.lfHeight = CVCR3.DisplayR3.ANM.CharHeight;
  lf.lfEscapement = 0;
  lf.lfOrientation = 0;
  lf.lfWeight = FW_MEDIUM;
  lf.lfItalic = FALSE;
  lf.lfUnderline=FALSE;
  lf.lfStrikeOut=FALSE;
  lf.lfCharSet=OEM_CHARSET;
  lf.lfOutPrecision=OUT_DEFAULT_PRECIS;
  lf.lfClipPrecision=CLIP_DEFAULT_PRECIS;
  lf.lfQuality=DEFAULT_QUALITY;
  lf.lfPitchAndFamily=FIXED_PITCH | FF_DONTCARE;
  wsprintf(lf.lfFaceName, L"Lucida Console");
  CVCR3.DisplayR3.ANM.hFont = CreateFontIndirect(&lf);		//DeleteAUMFontɾ
}

void DeleteANMFont(){
	DeleteObject(CVCR3.DisplayR3.ANM.hFont);
}

void MainWinOnPaint(){
	PAINTSTRUCT ps;
	HDC hdc;
	EnterCriticalSection(&CVCR3.DisplayR3.cs); 
	CVCR3.DisplayR3.IsDrawing = true;
	hdc = BeginPaint(CVCR3.DisplayR3.hWnd, &ps);
	// TODO: ڴͼ...
	SelectObject (CVCR3.DisplayR3.hMemDC, CVCR3.DisplayR3.hMemBitmap);
	BitBlt(
		hdc,
		CVCR3.DisplayR3.FlashRect.left,
		CVCR3.DisplayR3.FlashRect.top,
		CVCR3.DisplayR3.FlashRect.right - CVCR3.DisplayR3.FlashRect.left,
		CVCR3.DisplayR3.FlashRect.bottom - CVCR3.DisplayR3.FlashRect.top,
		CVCR3.DisplayR3.hMemDC,
		CVCR3.DisplayR3.FlashRect.left - CVCR3.DisplayR3.VDisplayRect.left,
		CVCR3.DisplayR3.FlashRect.top - CVCR3.DisplayR3.VDisplayRect.top,
		SRCCOPY
	);
	EndPaint(CVCR3.DisplayR3.hWnd, &ps);

	LeaveCriticalSection(&CVCR3.DisplayR3.cs); 
	//CriticalSection
	CVCR3.DisplayR3.IsDrawing = false;
}

void MainWinOnSize(LPARAM lParam){
	EnterCriticalSection(&CVCR3.DisplayR3.cs); 
	CVCR3.WinWidth = LOWORD(lParam);
	CVCR3.WinHeight = HIWORD(lParam);
	CVCR3.DisplayR3.VDisplayRect.left = (CVCR3.WinWidth-CVCR3.DisplayR3.DisplayWidth)/2;
	CVCR3.DisplayR3.VDisplayRect.top = (CVCR3.WinHeight-CVCR3.DisplayR3.DisplayHeight)/2;
	CVCR3.DisplayR3.VDisplayRect.right = CVCR3.DisplayR3.VDisplayRect.left + CVCR3.DisplayR3.DisplayWidth;
	CVCR3.DisplayR3.VDisplayRect.bottom = CVCR3.DisplayR3.VDisplayRect.top + CVCR3.DisplayR3.DisplayHeight;

	CVCR3.DisplayR3.FlashRect.left = CVCR3.DisplayR3.VDisplayRect.left;
	CVCR3.DisplayR3.FlashRect.top = CVCR3.DisplayR3.VDisplayRect.top;
	CVCR3.DisplayR3.FlashRect.right = CVCR3.DisplayR3.VDisplayRect.right;
	CVCR3.DisplayR3.FlashRect.bottom = CVCR3.DisplayR3.VDisplayRect.bottom;

	LeaveCriticalSection(&CVCR3.DisplayR3.cs); 
	DisplayFlush(CVCR3.DisplayR3.VDisplayRect);
}