#include "stdafx.h"
#include "MainUI.h"
#include "Command/MainKbCmd.h"
#include "dll/SoSmall.h"
#include "Debug.h"

#define		SCAN_CODE_LSHIFT	0x2A
#define		SCAN_CODE_RSHIFT	0x36
#define		SCAN_CODE_LCTRL		0x1D
#define		SCAN_CODE_RCTRL		0x1D
#define		SCAN_CODE_LALT		0x38
#define		SCAN_CODE_RALT		0x38

#define		MASK_CODE_LSHITF	0x01
#define		MASK_CODE_RSHITF	0x02
#define		MASK_CODE_LALT		0x04
#define		MASK_CODE_RALT		0x08
#define		MASK_CODE_LCTRL		0x10
#define		MASK_CODE_RCTRL		0x20
#define		MASK_CODE_NUMCLOCK	0x40

void MainKb_Init(tpCVCR3 pCVCR3){
	pCVCR3->KeyboardR3.StateMask = 0;
	pCVCR3->KeyboardR3.IfInShift = FALSE;
	pCVCR3->KeyboardR3.IfInCtrl = FALSE;
	pCVCR3->KeyboardR3.IfInAlt = FALSE;
}

void MainKb_OnKeyDown(
	HWND hWnd,
	WPARAM wParam,
	LPARAM lParam,
	tpCVCR3	pCVCR3,
	tpSubCVCR3 pSubCVCR3
	){
	int vk;				//Virtual Key
	int rc;				//Repeat Count
	int sc;				//Scan Scode
	int ef;				//extended-key flag
	int cc;				//context code
	int PreKeySFlag;	//previous key-state flag
	int TransSFlag;		//transition-state flag
	int ScanCode;

	tExtInt ExtInt;

	vk = wParam;
	rc = lParam & 0xFFFF;					// 015
	sc = (lParam >> 16) & 0xFF;				//1623
	ef = (lParam >> 24) & 0x01;				//24
	cc = (lParam >> 29) & 0x01;				//29
	PreKeySFlag = (lParam >> 30) & 0x01;	//30
	TransSFlag = (lParam >> 31) & 0x01;		//31

	TRACE(L"յ̰Ϣ:\n");
	TRACE(L"Virtual Key: %X\n",vk);
	TRACE(L"Repeat Count: %X\n",rc);
	TRACE(L"Scan Scode: %X\n",sc);
	TRACE(L"extended-key flag: %X\n",ef);
	TRACE(L"context code: %X\n",cc);
	TRACE(L"previous key-state flag: %X\n",PreKeySFlag);
	TRACE(L"transition-state flag: %X\n",TransSFlag);

	if(sc == SCAN_CODE_LSHIFT){
		if(pCVCR3->KeyboardR3.StateMask & MASK_CODE_LSHITF)
			return;
		pCVCR3->KeyboardR3.StateMask |= MASK_CODE_LSHITF;
	}
	else if(sc == SCAN_CODE_LCTRL){
		if(pCVCR3->KeyboardR3.StateMask & MASK_CODE_LCTRL)
			return;
		pCVCR3->KeyboardR3.StateMask |= MASK_CODE_LCTRL;
	}
	else if(sc == SCAN_CODE_LALT)
	{
		if(pCVCR3->KeyboardR3.StateMask & MASK_CODE_LALT)
			return;
		pCVCR3->KeyboardR3.StateMask |= MASK_CODE_LALT;
	}

	ExtInt.EInum = 0x09;
	ExtInt.Argu1 = sc;
	InsertTailExtIntR3(pSubCVCR3,&ExtInt);
}


void MainKb_OnKeyUp(
	HWND hWnd,
	WPARAM wParam,
	LPARAM lParam,
	tpCVCR3	pCVCR3,
	tpSubCVCR3 pSubCVCR3
	){
	int vk;				//Virtual Key
	int rc;				//Repeat Count
	int sc;				//Scan Scode
	int ef;				//extended-key flag
	int cc;				//context code
	int PreKeySFlag;	//previous key-state flag
	int TransSFlag;		//transition-state flag

	tExtInt ExtInt;

	vk = wParam;
	rc = lParam & 0xFFFF;					// 015
	sc = (lParam >> 16) & 0xFF;				//1623
	ef = (lParam >> 24) & 0x01;				//24
	cc = (lParam >> 29) & 0x01;				//29
	PreKeySFlag = (lParam >> 30) & 0x01;	//30
	TransSFlag = (lParam >> 31) & 0x01;		//31

	TRACE(L"յ̰Ϣ:\n");
	TRACE(L"Virtual Key: %X\n",vk);
	TRACE(L"Repeat Count: %X\n",rc);
	TRACE(L"Scan Scode: %X\n",sc);
	TRACE(L"extended-key flag: %X\n",ef);
	TRACE(L"context code: %X\n",cc);
	TRACE(L"previous key-state flag: %X\n",PreKeySFlag);
	TRACE(L"transition-state flag: %X\n",TransSFlag);

	if(sc == SCAN_CODE_LSHIFT){
		pCVCR3->KeyboardR3.StateMask &= ~MASK_CODE_LSHITF;
	}
	else if(sc == SCAN_CODE_LCTRL){
		pCVCR3->KeyboardR3.StateMask &= ~MASK_CODE_LCTRL;
	}
	else if(sc == SCAN_CODE_LALT)
	{
		pCVCR3->KeyboardR3.StateMask &= ~MASK_CODE_LALT;
	}
	ExtInt.EInum = 0x09;
	ExtInt.Argu1 = sc | 0x80;
	InsertTailExtIntR3(pSubCVCR3,&ExtInt);
}