// MainUI.cpp : Ӧóڵ㡣
//

#include "stdafx.h"
#include <process.h>
#include "MainUI.h"
#include "Debug.h"

#include "Command/MainWinCmd.h"
#include "Command/MenuDbgCmd.h"
#include "Command/MainKbCmd.h"

//
void InitMenu(HWND hWnd);

static bool StartVM(HWND hWnd);
static bool StopVM();

static void DisplayControlThread(void *);
static void TermDCThread();

#define MAX_LOADSTRING 100

// ȫֱ:
HINSTANCE hInst;								// ǰʵ
TCHAR szTitle[MAX_LOADSTRING];					// ı
TCHAR szWindowClass[MAX_LOADSTRING];			// 

tCVCR3 CVCR3;
tBI Bi;	//ʼϢ
tSubCVCR3 SubCVCR3;
bool IfStartVMSuccess = false;

// ˴ģаĺǰ:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

 	// TODO: ڴ˷ô롣
	MSG msg;
	HACCEL hAccelTable;

	// ʼȫַ
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_MAINUI, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// ִӦóʼ:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_MAINUI));

	// Ϣѭ:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}



//
//  : MyRegisterClass()
//
//  Ŀ: עᴰࡣ
//
//  ע:
//
//    ϣ
//    ˴ӵ Windows 95 еġRegisterClassEx
//    ֮ǰ Win32 ϵͳʱҪ˺÷ô˺ʮҪ
//    ӦóͿԻù
//    ʽȷġСͼꡣ
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MAINUI));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	//wcex.hbrBackground= (HBRUSH)(COLOR_WINDOW+1);
	wcex.hbrBackground  = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_MAINUI);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   : InitInstance(HINSTANCE, int)
//
//   Ŀ: ʵ
//
//   ע:
//
//        ڴ˺Уȫֱбʵ
//        ʾ򴰿ڡ
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // ʵ洢ȫֱ

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   //ʼ˵
   InitMenu(hWnd);

   IfStartVMSuccess = false;

   //ʼ
	if (!StartVM(hWnd))									// Initialize Our Newly Created GL Window
	{
		MessageBox(NULL,L"ʼʧܣ",L"ERROR",MB_OK|MB_ICONEXCLAMATION);
		if (!DestroyWindow(hWnd))					// Are We Able To Destroy The Window?
		{
			MessageBox(NULL,L"ڹرʧܣ",L"SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
			hWnd=NULL;										// Set hWnd To NULL
		}
		//עᣬرյഴĴںܵ
		if (!UnregisterClass(szWindowClass,hInstance))			// Are We Able To Unregister Class
		{
			MessageBox(NULL,L"ڹرʧܣ",L"SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
			hInstance=NULL;									// Set hInstance To NULL
		}
		return FALSE;								// Return FALSE
	}

	IfStartVMSuccess = true;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	return TRUE;
}

//˵ʼ
void InitMenu(HWND hWnd){
#ifndef SS_DEBUG
	HMENU hMenu = GetMenu(hWnd);
	EnableMenuItem(hMenu,MENU_DEBUG_RUN_1,MF_GRAYED);
	EnableMenuItem(hMenu,MENU_DEBUG_RUN_10,MF_GRAYED);
	EnableMenuItem(hMenu,MENU_DEBUG_RUN_100,MF_GRAYED);
	EnableMenuItem(hMenu,MENU_DEBUG_RUN_1000,MF_GRAYED);
	EnableMenuItem(hMenu,MENU_DEBUG_RUN_10000,MF_GRAYED);
	EnableMenuItem(hMenu,MENU_DEBUG_RUN_100000,MF_GRAYED);
#endif
}


//
//  : WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  Ŀ: ڵϢ
//
//  WM_COMMAND	- Ӧó˵
//  WM_PAINT	- 
//  WM_DESTROY	- ˳Ϣ
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	//############################# ̰ ################################
	case WM_KEYDOWN:
		MainKb_OnKeyDown(hWnd,wParam,lParam,&CVCR3,&SubCVCR3);
		break;
	//############################# ̰ͷ ############################
	case WM_KEYUP:
		MainKb_OnKeyUp(hWnd,wParam,lParam,&CVCR3,&SubCVCR3);
		break;
	//#############################  ################################
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// ˵ѡ:
		switch (wmId)
		{

		//˵ѡ
#ifdef SS_DEBUG
		case MENU_DEBUG_RUN_1:		//1ָ
			DebugRunWithCount(&SubCVCR3,1);
			break;
		case MENU_DEBUG_RUN_10:		//10ָ
			DebugRunWithCount(&SubCVCR3,10);
			break;
		case MENU_DEBUG_RUN_100:	//100ָ
			DebugRunWithCount(&SubCVCR3,100);
			break;
		case MENU_DEBUG_RUN_1000:	//1000ָ
			DebugRunWithCount(&SubCVCR3,1000);
			break;
		case MENU_DEBUG_RUN_10000:	//10000ָ
			DebugRunWithCount(&SubCVCR3,10000);
			break;
		case MENU_DEBUG_RUN_100000:	//100000ָ
			DebugRunWithCount(&SubCVCR3,100000);
			break;
#endif

		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		MainWinOnPaint();
		break;
	case WM_SIZE:
		MainWinOnSize(lParam);
		break;
	case WM_DESTROY:
		StopVM();
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// ڡϢ
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}


//ʼVM
static bool StartVM(HWND hWnd){
	EXERESULT rt = SS_ERROR;
	HDC hdc;
	HGDIOBJ hOldObj;
	RECT rc;

	TRACE(L"StartVM\n");

	//########################ʼCVCR3##########################
	GetWindowRect(CVCR3.DisplayR3.hWnd, &rc);
	CVCR3.WinWidth = rc.right - rc.left;
	CVCR3.WinHeight = rc.bottom - rc.top;
	
	//ǰĿ¼
	GetCurrentDirectory(FILE_MAX_PATH_LENGHT,CVCR3.CurrentDir);

	//---------------------ʾ----------------------
	CVCR3.DisplayR3.DisplayWidth = 640;
	CVCR3.DisplayR3.DisplayHeight = 200;
	CVCR3.DisplayR3.DisplayHPixel = 320;
	CVCR3.DisplayR3.DisplayVPixel = 200;
	CVCR3.DisplayR3.hWnd = hWnd;
	CVCR3.DisplayR3.IsDrawing = false;
	hdc = GetDC(hWnd);		//ڵǰͷ
	CVCR3.DisplayR3.hMemBitmap = CreateCompatibleBitmap(hdc,DISPLAY_LARGEST_H_PIXEL,DISPLAY_LARGEST_V_PIXEL);//StopVMͷ
	CVCR3.DisplayR3.hMemDC = CreateCompatibleDC(hdc);		//StopVMͷ
	ReleaseDC(hWnd,hdc);

	CVCR3.DisplayR3.ANM.CharBoxWidth = 8;
	CVCR3.DisplayR3.ANM.CharBoxHeight = 8;
	CVCR3.DisplayR3.ANM.CharWidth = 7;
	CVCR3.DisplayR3.ANM.CharHeight = 7;
	CVCR3.DisplayR3.ANM.CursorChar_X = 0;
	CVCR3.DisplayR3.ANM.CursorChar_Y = 0;
	CVCR3.DisplayR3.ANM.hBrushCursor = CreateSolidBrush(RGB(255,255,255));		//StopVMͷ
	CreateANMFont();	//StopVMͷ
	CVCR3.DisplayR3.ANM.DrawCount = 0;

	CVCR3.DisplayR3.VDisplayRect.left = (CVCR3.WinWidth-CVCR3.DisplayR3.DisplayWidth)/2;
	CVCR3.DisplayR3.VDisplayRect.top = (CVCR3.WinHeight-CVCR3.DisplayR3.DisplayHeight)/2;
	CVCR3.DisplayR3.VDisplayRect.right = CVCR3.DisplayR3.VDisplayRect.left + CVCR3.DisplayR3.DisplayWidth;
	CVCR3.DisplayR3.VDisplayRect.bottom = CVCR3.DisplayR3.VDisplayRect.top + CVCR3.DisplayR3.DisplayHeight;

	//ʾ߳سʼ
	CVCR3.DisplayR3.ehWC = CreateEvent(NULL,false,false,NULL);					//StopVMͷ
	CVCR3.DisplayR3.ehIsThreadCreated = CreateEvent(NULL,false,false,NULL);		//StopVMͷ
	CVCR3.DisplayR3.ehIsThreadClosed = CreateEvent(NULL,false,false,NULL);		//StopVMͷ
	CVCR3.DisplayR3.IsCThreadRun = true;
	InitializeCriticalSection(&CVCR3.DisplayR3.cs);								//StopVMͷ
	CVCR3.DisplayR3.hCThread =(HANDLE)_beginthread(DisplayControlThread,0,NULL);	//StopVMͷ
	//߳ȫ
	WaitForSingleObject(CVCR3.DisplayR3.ehIsThreadCreated,INFINITE);


	//-----------------------ж--------------------------
	CVCR3.Int.ehExterIntEvent = CreateEvent(NULL,false,false,NULL);		//StopVMͷ
	CVCR3.Int.EInumApicFetched = -1;	//EOI_NONE


	//-------------------------------------------------
	MainKb_Init(&CVCR3);

	//########################CVCR3 ʼ##########################



	//########################ʼSubCVCR3###########################
	SubCVCR3.DisplayR3.pehWC = &CVCR3.DisplayR3.ehWC;
	SubCVCR3.DisplayR3.pIsDrawing = &CVCR3.DisplayR3.IsDrawing;
	SubCVCR3.DisplayR3.pDisplayHPixel = &CVCR3.DisplayR3.DisplayHPixel;
	SubCVCR3.DisplayR3.pDisplayVPixel = &CVCR3.DisplayR3.DisplayVPixel;
	SubCVCR3.DisplayR3.ANM.pCursorChar_X = &CVCR3.DisplayR3.ANM.CursorChar_X;
	SubCVCR3.DisplayR3.ANM.pCursorChar_Y = &CVCR3.DisplayR3.ANM.CursorChar_Y;
	SubCVCR3.pCurrentDir = CVCR3.CurrentDir;
	//######################SubCVCR3 ʼ########################



	//SubCVCR3ʼںCVCR0SubCVCR3ں˵ĳʼϢ

	//VMR3Init...
	rt = VMR3Init(&Bi,&SubCVCR3);	//StopVMͷ
	if(rt != SS_SUCCESS){
		return FALSE;
	}

	//##################SubCVCR3صںϢֵCVCR3#############
	CVCR3.DisplayR3.pVideoMem = SubCVCR3.DisplayR3.pVideoMem;
	CVCR3.hMainDevice = SubCVCR3.hMainDevice;
	//##############################ֵ###########################

	//ˢĻ
	SetTimer(CVCR3.DisplayR3.hWnd,TIMER_DISPLAY_FLASH,1000/DISPLAY_FLASH_FREQ,TimerDisplayFlash);

	//VMR3Run...
	VMR3Run(&Bi);
	return true;
}

static bool StopVM(){
	EXERESULT rt = SS_ERROR;
	if(IfStartVMSuccess){
		rt = VMR3Release(&Bi);
	}
	TRACE(L"StopVM\n");
	if(rt != SS_SUCCESS)
		MessageBox(NULL,L"Դͷʧܣ",L"ERROR",MB_OK|MB_ICONEXCLAMATION);

	//ͷCVCR3Դ
	//ͷ
	TermDCThread();

	//Release Display
	CloseHandle(CVCR3.DisplayR3.ehWC);
	CloseHandle(CVCR3.DisplayR3.ehIsThreadCreated);
	CloseHandle(CVCR3.DisplayR3.ehIsThreadClosed);
	DeleteANMFont();
	DeleteObject(CVCR3.DisplayR3.ANM.hBrushCursor);

	DeleteCriticalSection(&CVCR3.DisplayR3.cs);

	DeleteDC(CVCR3.DisplayR3.hMemDC);
	DeleteObject(CVCR3.DisplayR3.hMemBitmap);

	//Release Int
	CloseHandle(CVCR3.Int.ehExterIntEvent);

	return true;
}
//ʾ߳
static void DisplayControlThread(void *){
	RECT rc;
	TRACE(L"-------ʾ̴߳ɹ-------\n");
	SetEvent(CVCR3.DisplayR3.ehIsThreadCreated);	//̴߳

	rc.left = 0;
	rc.right = 0;
	rc.top = 0;
	rc.bottom = 0;
	while(CVCR3.DisplayR3.IsCThreadRun){
		WaitForSingleObject(CVCR3.DisplayR3.ehWC,INFINITE);

		DisplayFlush(rc);
	}

	TRACE(L"DisplayControlThread ˳\n");
	SetEvent(CVCR3.DisplayR3.ehIsThreadClosed);	//̹߳ر
	_endthread();
}
static void TermDCThread(){
	CVCR3.DisplayR3.IsCThreadRun = false;
	SetEvent(CVCR3.DisplayR3.ehWC);

	//߳ȫر
	WaitForSingleObject(CVCR3.DisplayR3.ehIsThreadClosed,INFINITE);
}