#include "general.h"
#include "VMM/CVCR0.h"
#include "VMM/VMMR0.h"
#include "VMM/EMR0.h"
#include "Base/File.h"
#include "Function.h"
#include "ExtInt.h"
#include "VMM/IntList.h"

#ifndef __E
#	define __E(__a)	&(pThread->Events[__a])
#endif

#ifndef __S
#	define __S(__a)	&(pThread->SpinLocks[__a])
#endif

static void IMThread(PVOID pThreadAug);

typedef struct tThreadAug{
	tpCVC pCVC;
}tThreadAug, *tpThreadAug;

EXERESULT VMMR0Create(tpCVC pCVC){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("VMMR0Create\n"));

	pCVC->VMM.EM.CpuCount = pCVC->VM.Cpu.count;
	pCVC->VMM.EM.pCVC = pCVC;

	rt = EMR0Create(&pCVC->VMM.EM);				//VMMR0Releaseͷ
	if(rt != SS_SUCCESS)
	{
		return rt;
	}								//EM was created successfully !

	rt = VMMR0CreateIMThread(pCVC,&pCVC->VMM.IntManageThread);		//VMMR0Releaseͷ
	if(rt != SS_SUCCESS)
	{
		EMR0Release(&pCVC->VMM.EM);
		return rt;
	}								//IMThread was created successfully !

	return rt;
}

EXERESULT VMMR0Release(tpCVC pCVC){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("VMMR0Release\n"));
	rt = EMR0Release(&pCVC->VMM.EM);
	rt = GETFIRSTERROR(rt,VMMR0ReleaseIMThread(pCVC,&pCVC->VMM.IntManageThread));
	return rt;
}

EXERESULT VMMR0StartEmu(tpCVC pCVC){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("VMMR0StartEmu\n"));
	rt = EMR0Start(pCVC);
	return rt;
}

EXERESULT VMMR0CreateIMThread(tpCVC pCVC,tpThread pThread){
	EXERESULT rt = SS_SUCCESS;
	tThreadAug TAug;
	NTSTATUS status;
	KIRQL OldIrql;
	pThread->ThreadEntry = IMThread;
	TAug.pCVC = pCVC;

	KeInitializeSpinLock(&pCVC->VMM.IntListSpinLock);

	KeInitializeEvent(&pCVC->VMM.IntFetchEvent,SynchronizationEvent, FALSE);
	KeInitializeEvent(&pCVC->VMM.IntFinishEvent,SynchronizationEvent, FALSE);

	KeAcquireSpinLock(&pCVC->VMM.IntListSpinLock,&OldIrql);
	pCVC->VMM.IntListCount = 0;
	pCVC->VMM.IntListHead = 0;
	pCVC->VMM.IntListTail = 0;
	pCVC->VMM.IntFetchOpen = TRUE;
	KeReleaseSpinLock(&pCVC->VMM.IntListSpinLock,OldIrql);

	rt = ThrR0Create(pThread,&TAug);
	return rt;	
}

EXERESULT VMMR0ReleaseIMThread(tpCVC pCVC,tpThread pThread){
	EXERESULT rt = SS_SUCCESS;
	KIRQL OldIrql;

	//
	KeAcquireSpinLock(&((tpCVC)pCVC)->VMM.IntListSpinLock,&OldIrql);
	pCVC->VMM.IntFetchOpen = FALSE; 	//رжϻȡ
	pCVC->VMM.IntListCount = 0;			//ж
	pCVC->VMM.IntListHead  = 0;
	pCVC->VMM.IntListTail  = 0;
	KeReleaseSpinLock(&((tpCVC)pCVC)->VMM.IntListSpinLock,OldIrql);

	//
	pThread->ToBeTerminated = TRUE;	//߳ToBeTerminated־⸳ֵ
	//
	KeSetEvent(&pCVC->VMM.IntFetchEvent,IO_NO_INCREMENT,FALSE);
	KeSetEvent(&pCVC->VMM.IntFinishEvent,IO_NO_INCREMENT,FALSE);

	ThrR0Term(pThread);

	return rt;	
}

//IMThread
static void IMThread(PVOID pThreadAug){
	tpCVC pCVC;
	tpThread pThread;
	KIRQL OldIrql;
	int head;

	KdPrint(("-------жϿ̴߳ɹ-------\n"));
	pCVC = ((tpThreadAug)pThreadAug)->pCVC;
	pThread = &(pCVC->VMM.IntManageThread);

	//Callerͳɹ߳¼
	KeSetEvent(__E(THREAD_EVENTS_START_SUSS),IO_NO_INCREMENT,FALSE);

	pThread->ThrState = THREAD_IS_RUNNING;
	while(1){
		//ȴⲿж
		KeWaitForSingleObject(&pCVC->VMM.IntFetchEvent, Executive, KernelMode, FALSE, NULL);
		if(pThread->ToBeTerminated)
		{
			pThread->ThrState = THREAD_IS_TERMINATED_OUT;
			break;
		}
		while(1){
			if(pThread->ToBeTerminated)
			{
				pThread->ThrState = THREAD_IS_TERMINATED_OUT;
				break;
			}


			KeAcquireSpinLock(&pCVC->VMM.IntListSpinLock,&OldIrql);
			if(pCVC->VMM.IntListCount == 0){		//жΪ
				KeReleaseSpinLock(&pCVC->VMM.IntListSpinLock,OldIrql);
				break;
			}
			head = pCVC->VMM.IntListHead;
			pCVC->VMM.IntListHead = (head+1) % INT_LIST_MAX_LENGTH;
			((tpCVC)pCVC)->VMM.IntListCount--;
			KeReleaseSpinLock(&pCVC->VMM.IntListSpinLock,OldIrql);


			//жϵ
			//ǰ汾ֻһcpu...
			pCVC->VMM.EM.EInum[0] = pCVC->VMM.IntListEntry[head].IntEInum;

			//ȴж
			KeWaitForSingleObject(&pCVC->VMM.IntFinishEvent, Executive, KernelMode, FALSE, NULL);
		}
	}
	KeSetEvent(__E(THREAD_EVENTS_END_SUSS),IO_NO_INCREMENT,FALSE);
	if(!IS_TERMINATED_STATE(pThread->ThrState))			//δ֮ǰùս״̬
		pThread->ThrState = THREAD_IS_TERMINATED_IN_NORMAL;
	PsTerminateSystemThread(STATUS_SUCCESS);
}


//
EXERESULT VMMR0FetchExternInterrupt(__in PIRP Irp){
	EXERESULT rt = SS_SUCCESS;
	PIO_STACK_LOCATION pSL;
	int inBufLength;
	tpExtInt  pExtInt;
	tpCVC pCVC;
	PKEVENT rtEvent;

	pSL = IoGetCurrentIrpStackLocation(Irp);
	//inBufLength = pSL->Parameters.DeviceIoControl.InputBufferLength;
	pExtInt = (tpExtInt)(Irp->AssociatedIrp.SystemBuffer);

	pCVC = (tpCVC)(pSL->FileObject->FsContext);

	switch(pExtInt->EInum){
	case 0x09:
		pCVC->VM.Device.Chips.C8255.PA60 = (unsigned char)pExtInt->Argu1;
		break;
	}

	IntListAddTail(pCVC,pExtInt->EInum);
	return rt;
}

#ifdef SS_DEBUG



void VMMR0DbgNextCount(tpCVC pCVC,unsigned int count){
	//ʽ汾ʱĬϵ
	if(pCVC->VMM.EM.IsWaiting4DbgCmd[0] == TRUE)
	{
		KdPrint(("ִ%dָ\n",count));
		pCVC->VMM.EM.ic[0] += count;
		KeSetEvent(&pCVC->VMM.EM.ehGetOneDbgCmd[0],IO_NO_INCREMENT,FALSE);
	}
}




#endif