/*
	MM	Memory Manager
*/
#include "general.h"
#include "VMM/MDER0.h"
#include "VMM/CVCR0.h"
#include "VMM/MMR0.h"

EXERESULT MMR0Create(tpMem pMem){
	PHYSICAL_ADDRESS Zero;
	PHYSICAL_ADDRESS HighAddr;
	EXERESULT rt = SS_SUCCESS;
	PMDL pMdl;
	Zero.QuadPart = 0;
	HighAddr.QuadPart = pMem->HostHighestPhysicalMemory;	//HostHighestPhysicalMemoryCVCR0Initֵ

	KdPrint(("MMR0Create\n"));
	//IoAllocateMdl(֮ҪMmProbeAndLockPages MmAllocatePagesForMdlExѾ
	//ȱ㣺 62MB for 32 bit & 31MB for 64-bit pc for a PAGE_SIZE=4K
	pMem->pGuestPhyMem = NULL;
	pMdl = pMem->pMdl = MmAllocatePagesForMdlEx(Zero, HighAddr, Zero,pMem->size,0,0);
	if(pMdl){
		if(MmGetMdlByteCount(pMdl) >= pMem->size){	/* ܴ */
			//ӳ䵽ڴ
			pMem->pGuestPhyMem = MmMapLockedPagesSpecifyCache(pMdl, KernelMode, MmCached, NULL,FALSE , NormalPagePriority);
			if(!(pMem->pGuestPhyMem))	//ӳʧܣ
			{
				rt = SS_INSUFFICIENT_RESOURCES;
				MmFreePagesFromMdl(pMdl);
				ExFreePool(pMdl);
				pMem->pMdl = NULL;
			}
			else
			{
				KdPrint(("ڴӳ䵽飬ڴ׵ַΪ %p\n",pMem->pGuestPhyMem));
				memset(pMem->pGuestPhyMem,0,pMem->size);
				rt = SS_SUCCESS;
			}
		}
		else{
			MmFreePagesFromMdl(pMdl);
            ExFreePool(pMdl);
			pMem->pMdl = NULL;
			rt = SS_INSUFFICIENT_RESOURCES;
		}
	}
	else{
		rt = SS_INSUFFICIENT_RESOURCES;
	}
	return rt;
}

EXERESULT MMR0Release(tpMem pMem){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("MMR0Release\n"));
	if(pMem->pGuestPhyMem!=NULL)
	{
		MmUnmapLockedPages(pMem->pGuestPhyMem,pMem->pMdl);
		pMem->pGuestPhyMem = NULL;
	}
	if(pMem->pMdl){
		MmFreePagesFromMdl(pMem->pMdl);
        ExFreePool(pMem->pMdl);
		pMem->pMdl = NULL;
	}
	return rt;
}