#include "general.h"
#include "VMM/IntList.h"
#include "VMM/CVCR0.h"

void IntListAddTail(PVOID pCVC,int EInum){
	KIRQL OldIrql;
	tpCVC p = (tpCVC)pCVC;

	//ǰռʱ
	KeAcquireSpinLock(&p->VMM.IntListSpinLock,&OldIrql);
	if((p->VMM.IntFetchOpen == FALSE)	//رջж
		||
		(p->VMM.IntListCount >= INT_LIST_MAX_LENGTH))		//ж
	{
		//ǰж
		KeReleaseSpinLock(&p->VMM.IntListSpinLock,OldIrql);
		return;
	}
	p->VMM.IntListEntry[p->VMM.IntListTail].IntEInum = EInum;
	p->VMM.IntListTail = (p->VMM.IntListTail+1) % INT_LIST_MAX_LENGTH;
	p->VMM.IntListCount++;
	KeReleaseSpinLock(&p->VMM.IntListSpinLock,OldIrql);

	KeSetEvent(&p->VMM.IntFetchEvent,IO_NO_INCREMENT,FALSE);
}


//˺ֻҪеǰжϣ²ܵ
void IntListAddTailFast(PVOID pCVC,int EInum){
	//ֱ0cpuеǰж
	((tpCVC)pCVC)->VMM.EM.EInum[0] = EInum;
}