#include "general.h"
#include "VMM/Emulator/_Flags.h"
//***************************
//ע⣺ļеһִοBochs	By Cyz
//***************************
//Intel Manual Volume.	page.407

const bool parity_lookup[256] = {
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1
};

bool FlagsGetOFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags){
	bool OF_rt;
	unsigned char op1_b7,op2_b7,res_b7;
	unsigned short op1_b15,op2_b15,res_b15;
	unsigned int op1_b31,op2_b31,res_b31;
	//ѾùOFλ
	if((pFlagsAbout->HasGetted>>FLAG_OFFSET_OF) & 0x01)
		return ((*pEFlags)>>E_OF) & 0x01;

	switch(pFlagsAbout->CurFlagOpCodeName){
	case FLAG_CN_ADD8:
	case FLAG_CN_ADC8:
	case FLAG_CN_XADD8:
		op1_b7 = pFlagsAbout->op1.u8 & 0x80;
		op2_b7 = pFlagsAbout->op2.u8 & 0x80;
		res_b7 = pFlagsAbout->res.u8 & 0x80;
		OF_rt =  (op1_b7 == op2_b7) && (res_b7 ^ op2_b7);
		break;
	case FLAG_CN_ADD16:
	case FLAG_CN_ADC16:
	case FLAG_CN_XADD16:
		op1_b15 = pFlagsAbout->op1.u16 & 0x8000;
		op2_b15 = pFlagsAbout->op2.u16 & 0x8000;
		res_b15 = pFlagsAbout->res.u16 & 0x8000;
		OF_rt =  (op1_b15 == op2_b15) && (res_b15 ^ op2_b15);
		break;
	case FLAG_CN_ADD32:
	case FLAG_CN_ADC32:
	case FLAG_CN_XADD32:
		op1_b31 = pFlagsAbout->op1.u32 & 0x80000000;
		op2_b31 = pFlagsAbout->op2.u32 & 0x80000000;
		res_b31 = pFlagsAbout->res.u32 & 0x80000000;
		OF_rt =  (op1_b31 == op2_b31) && (res_b31 ^ op2_b31);
		break;
	case FLAG_CN_SUB8:
	case FLAG_CN_SBB8:
	case FLAG_CN_CMP8:
	case FLAG_CN_CMPS8:
	case FLAG_CN_SCAS8:
		op1_b7 = pFlagsAbout->op1.u8 & 0x80;
		op2_b7 = pFlagsAbout->op2.u8 & 0x80;
		res_b7 = pFlagsAbout->res.u8 & 0x80;
		OF_rt =  (op1_b7 ^ op2_b7) && (op1_b7 ^ res_b7);
		break;
	case FLAG_CN_SUB16:
	case FLAG_CN_SBB16:
	case FLAG_CN_CMP16:
	case FLAG_CN_CMPS16:
	case FLAG_CN_SCAS16:
		op1_b15 = pFlagsAbout->op1.u16 & 0x8000;
		op2_b15 = pFlagsAbout->op1.u16 & 0x8000;
		res_b15 = pFlagsAbout->res.u16 & 0x8000;
		OF_rt =  (op1_b15 ^ op2_b15) && (op1_b15 ^ res_b15);
		break;
	case FLAG_CN_SUB32:
	case FLAG_CN_SBB32:
	case FLAG_CN_CMP32:
	case FLAG_CN_CMPS32:
	case FLAG_CN_SCAS32:
		op1_b31 = pFlagsAbout->op1.u32 & 0x80000000;
		op2_b31 = pFlagsAbout->op2.u32 & 0x80000000;
		res_b31 = pFlagsAbout->res.u32 & 0x80000000;
		OF_rt =  (op1_b31 ^ op2_b31) && (op1_b31 ^ res_b31);
		break;
	case FLAG_CN_NEG8:
		OF_rt = (pFlagsAbout->op1.u8 == 0x80);
		break;
	case FLAG_CN_NEG16:
		OF_rt = (pFlagsAbout->op1.u16 == 0x8000);
		break;
	case FLAG_CN_NEG32:
		OF_rt = (pFlagsAbout->op1.u32 == 0x80000000);
		break;
	case FLAG_CN_OR8:
	case FLAG_CN_OR16:
	case FLAG_CN_OR32:
	case FLAG_CN_AND8:
	case FLAG_CN_AND16:
	case FLAG_CN_AND32:
	case FLAG_CN_TEST8:
	case FLAG_CN_TEST16:
	case FLAG_CN_TEST32:
	case FLAG_CN_XOR8:
	case FLAG_CN_XOR16:
	case FLAG_CN_XOR32:
		OF_rt = 0;
		break;
	case FLAG_CN_SHR8:
		if (pFlagsAbout->op2.u8 == 1)
			OF_rt = (pFlagsAbout->op1.u8 >= 0x80);
		else
			OF_rt = ((*pEFlags) >> E_OF) & 0x01;
		break;
	case FLAG_CN_SHR16:
		if (pFlagsAbout->op2.u16 == 1)
			OF_rt = (pFlagsAbout->op1.u16 >= 0x8000);
		else
			OF_rt = ((*pEFlags) >> E_OF) & 0x01;
		break;
	case FLAG_CN_SHR32:
		if (pFlagsAbout->op2.u32 == 1)
			OF_rt = (pFlagsAbout->op1.u32 >= 0x80000000);
		else
			OF_rt = ((*pEFlags) >> E_OF) & 0x01;
		break;
	case FLAG_CN_SHL8:
		if (pFlagsAbout->op2.u8 == 1)
			OF_rt = ((pFlagsAbout->op1.u8 ^ pFlagsAbout->res.u8) & 0x80) > 0;
		else
			OF_rt = ((*pEFlags) >> E_OF) & 0x01;
		break;
	case FLAG_CN_SHL16:
		if (pFlagsAbout->op2.u16 == 1)
			OF_rt = ((pFlagsAbout->op1.u16 ^ pFlagsAbout->res.u16) & 0x8000) > 0;
		else
			OF_rt = ((*pEFlags) >> E_OF) & 0x01;
		break;
	case FLAG_CN_SHL32:
		if (pFlagsAbout->op2.u32 == 1)
			OF_rt = ((pFlagsAbout->op1.u32 ^ pFlagsAbout->res.u32) & 0x80000000) > 0;
		else
			OF_rt = ((*pEFlags) >> E_OF) & 0x01;
		break;
	default:
		OF_rt = 0;
		KdPrint(("FlagsGetOFByFlagAb г˲ʶ\n"));
	}
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_OF);
	*pEFlags &= E_OF_C;
	*pEFlags |= OF_rt<<E_OF;
	return OF_rt;
}

bool FlagsGetSFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags){
	bool SF_rt;
	//ѾùSFλ
	if((pFlagsAbout->HasGetted>>FLAG_OFFSET_SF) & 0x01)
		return ((*pEFlags)>>E_SF) & 0x01;

	switch(pFlagsAbout->CurFlagOpCodeName){
	case FLAG_CN_ADD8:
	case FLAG_CN_ADC8:
	case FLAG_CN_SUB8:
	case FLAG_CN_SBB8:
	case FLAG_CN_CMP8:
	case FLAG_CN_NEG8:
	case FLAG_CN_XADD8:
	case FLAG_CN_OR8:
	case FLAG_CN_AND8:
	case FLAG_CN_TEST8:
	case FLAG_CN_XOR8:
	case FLAG_CN_CMPS8:
	case FLAG_CN_SCAS8:
	case FLAG_CN_SHR8:
	case FLAG_CN_SHL8:
		SF_rt = (pFlagsAbout->res.u8 >= 0x80);
		break;
	case FLAG_CN_ADD16:
	case FLAG_CN_ADC16:
	case FLAG_CN_SUB16:
	case FLAG_CN_SBB16:
	case FLAG_CN_CMP16:
	case FLAG_CN_NEG16:
	case FLAG_CN_XADD16:
	case FLAG_CN_OR16:
	case FLAG_CN_AND16:
	case FLAG_CN_TEST16:
	case FLAG_CN_XOR16:
	case FLAG_CN_CMPS16:
	case FLAG_CN_SCAS16:
	case FLAG_CN_SHR16:
	case FLAG_CN_SHL16:
		SF_rt = (pFlagsAbout->res.u16 >= 0x8000);
		break;
	case FLAG_CN_ADD32:
	case FLAG_CN_ADC32:
	case FLAG_CN_SUB32:
	case FLAG_CN_SBB32:
	case FLAG_CN_CMP32:
	case FLAG_CN_NEG32:
	case FLAG_CN_XADD32:
	case FLAG_CN_OR32:
	case FLAG_CN_AND32:
	case FLAG_CN_TEST32:
	case FLAG_CN_XOR32:
	case FLAG_CN_CMPS32:
	case FLAG_CN_SCAS32:
	case FLAG_CN_SHR32:
	case FLAG_CN_SHL32:
		SF_rt = (pFlagsAbout->res.u32 >= 0x80000000);
		break;
	default:
		SF_rt = 0;
		KdPrint(("FlagsGetSFByFlagAb г˲ʶ\n"));
	}
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_SF);
	*pEFlags &= E_SF_C;
	*pEFlags |= SF_rt<<E_SF;
	return SF_rt;
}

bool FlagsGetZFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags){
	bool ZF_rt;
	//ѾùZFλ
	if((pFlagsAbout->HasGetted>>FLAG_OFFSET_ZF) & 0x01)
		return ((*pEFlags)>>E_ZF) & 0x01;

	switch(pFlagsAbout->CurFlagOpCodeName){
	case FLAG_CN_ADD8:
	case FLAG_CN_ADC8:
	case FLAG_CN_SUB8:
	case FLAG_CN_SBB8:
	case FLAG_CN_CMP8:
	case FLAG_CN_NEG8:
	case FLAG_CN_XADD8:
	case FLAG_CN_OR8:
	case FLAG_CN_AND8:
	case FLAG_CN_TEST8:
	case FLAG_CN_XOR8:
	case FLAG_CN_CMPS8:
	case FLAG_CN_SCAS8:
	case FLAG_CN_SHR8:
	case FLAG_CN_SHL8:
		ZF_rt = (pFlagsAbout->res.u8 == 0);
		break;
	case FLAG_CN_ADD16:
	case FLAG_CN_ADC16:
	case FLAG_CN_SUB16:
	case FLAG_CN_SBB16:
	case FLAG_CN_CMP16:
	case FLAG_CN_NEG16:
	case FLAG_CN_XADD16:
	case FLAG_CN_OR16:
	case FLAG_CN_AND16:
	case FLAG_CN_TEST16:
	case FLAG_CN_XOR16:
	case FLAG_CN_CMPS16:
	case FLAG_CN_SCAS16:
	case FLAG_CN_SHR16:
	case FLAG_CN_SHL16:
		ZF_rt = (pFlagsAbout->res.u16 == 0);
		break;
	case FLAG_CN_ADD32:
	case FLAG_CN_ADC32:
	case FLAG_CN_SUB32:
	case FLAG_CN_SBB32:
	case FLAG_CN_CMP32:
	case FLAG_CN_NEG32:
	case FLAG_CN_XADD32:
	case FLAG_CN_OR32:
	case FLAG_CN_AND32:
	case FLAG_CN_TEST32:
	case FLAG_CN_XOR32:
	case FLAG_CN_CMPS32:
	case FLAG_CN_SCAS32:
	case FLAG_CN_SHR32:
	case FLAG_CN_SHL32:
		ZF_rt = (pFlagsAbout->res.u32 == 0);
		break;
	default:
		ZF_rt = 0;
		KdPrint(("FlagsGetZFByFlagAb г˲ʶ\n"));
	}
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_ZF);
	*pEFlags &= E_ZF_C;
	*pEFlags |= ZF_rt<<E_ZF;
	return ZF_rt;
}

bool FlagsGetAFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags){
	unsigned short AF_rt;
	//ѾùAFλ
	if((pFlagsAbout->HasGetted>>FLAG_OFFSET_AF) & 0x01)
		return ((*pEFlags)>>E_AF) & 0x01;

	switch(pFlagsAbout->CurFlagOpCodeName){
	case FLAG_CN_ADD8:
	case FLAG_CN_ADC8:
	case FLAG_CN_SUB8:
	case FLAG_CN_SBB8:
	case FLAG_CN_CMP8:
	case FLAG_CN_XADD8:
	case FLAG_CN_CMPS8:
	case FLAG_CN_SCAS8:
		AF_rt = (((pFlagsAbout->op1.u8 ^ pFlagsAbout->op2.u8) ^ pFlagsAbout->res.u8) & 0x10);
		break;
	case FLAG_CN_ADD16:
	case FLAG_CN_ADC16:
	case FLAG_CN_SUB16:
	case FLAG_CN_SBB16:
	case FLAG_CN_CMP16:
	case FLAG_CN_XADD16:
	case FLAG_CN_CMPS16:
	case FLAG_CN_SCAS16:
		AF_rt = (((pFlagsAbout->op1.u16 ^ pFlagsAbout->op2.u16) ^ pFlagsAbout->res.u16) & 0x10);
		break;
	case FLAG_CN_ADD32:
	case FLAG_CN_ADC32:
	case FLAG_CN_SUB32:
	case FLAG_CN_SBB32:
	case FLAG_CN_CMP32:
	case FLAG_CN_XADD32:
	case FLAG_CN_CMPS32:
	case FLAG_CN_SCAS32:
		AF_rt = (((pFlagsAbout->op1.u32 ^ pFlagsAbout->op2.u32) ^ pFlagsAbout->res.u32) & 0x10);
		break;
	case FLAG_CN_NEG8:
		AF_rt = (pFlagsAbout->op1.u8 & 0x0f) > 0;
		break;
	case FLAG_CN_NEG16:
		AF_rt = (pFlagsAbout->op1.u16 & 0x0f) > 0;
		break;
	case FLAG_CN_NEG32:
		AF_rt = (pFlagsAbout->op1.u32 & 0x0f) > 0;
		break;
	case FLAG_CN_OR8:
	case FLAG_CN_OR16:
	case FLAG_CN_OR32:
	case FLAG_CN_AND8:
	case FLAG_CN_AND16:
	case FLAG_CN_AND32:
	case FLAG_CN_TEST8:
	case FLAG_CN_TEST16:
	case FLAG_CN_TEST32:
	case FLAG_CN_XOR8:
	case FLAG_CN_XOR16:
	case FLAG_CN_XOR32:
	case FLAG_CN_SHR8:
	case FLAG_CN_SHR16:
	case FLAG_CN_SHR32:
	case FLAG_CN_SHL8:
	case FLAG_CN_SHL16:
	case FLAG_CN_SHL32:
		AF_rt = 0;		//δ
		break;
	default:
		AF_rt = 0;
		KdPrint(("FlagsGetAFByFlagAb г˲ʶ\n"));
	}
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_AF);
	*pEFlags &= E_AF_C;
	*pEFlags |= (!!AF_rt)<<E_AF;
	return (!!AF_rt);
}

bool FlagsGetPFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags){
	bool PF_rt;
	//ѾùPFλ
	if((pFlagsAbout->HasGetted>>FLAG_OFFSET_PF) & 0x01)
		return ((*pEFlags)>>E_PF) & 0x01;

	switch(pFlagsAbout->CurFlagOpCodeName){
	case FLAG_CN_ADD8:
	case FLAG_CN_ADC8:
	case FLAG_CN_SUB8:
	case FLAG_CN_SBB8:
	case FLAG_CN_CMP8:
	case FLAG_CN_NEG8:
	case FLAG_CN_XADD8:
	case FLAG_CN_OR8:
	case FLAG_CN_AND8:
	case FLAG_CN_TEST8:
	case FLAG_CN_XOR8:
	case FLAG_CN_CMPS8:
	case FLAG_CN_SCAS8:
	case FLAG_CN_SHR8:
	case FLAG_CN_SHL8:
		PF_rt = parity_lookup[pFlagsAbout->res.u8];
		break;
	case FLAG_CN_ADD16:
	case FLAG_CN_ADC16:
	case FLAG_CN_SUB16:
	case FLAG_CN_SBB16:
	case FLAG_CN_CMP16:
	case FLAG_CN_NEG16:
	case FLAG_CN_XADD16:
	case FLAG_CN_OR16:
	case FLAG_CN_AND16:
	case FLAG_CN_TEST16:
	case FLAG_CN_XOR16:
	case FLAG_CN_CMPS16:
	case FLAG_CN_SCAS16:
	case FLAG_CN_SHR16:
	case FLAG_CN_SHL16:
		PF_rt = parity_lookup[(unsigned char) pFlagsAbout->res.u16];
		break;
	case FLAG_CN_ADD32:
	case FLAG_CN_ADC32:
	case FLAG_CN_SUB32:
	case FLAG_CN_SBB32:
	case FLAG_CN_CMP32:
	case FLAG_CN_NEG32:
	case FLAG_CN_XADD32:
	case FLAG_CN_OR32:
	case FLAG_CN_AND32:
	case FLAG_CN_TEST32:
	case FLAG_CN_XOR32:
	case FLAG_CN_CMPS32:
	case FLAG_CN_SCAS32:
	case FLAG_CN_SHR32:
	case FLAG_CN_SHL32:
		PF_rt = parity_lookup[(unsigned char) pFlagsAbout->res.u32];
		break;
	default:
		PF_rt = 0;
		KdPrint(("FlagsGetPFByFlagAb г˲ʶ\n"));
	}
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_PF);
	*pEFlags &= E_PF_C;
	*pEFlags |= PF_rt<<E_PF;
	return PF_rt;
}

bool FlagsGetCFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags){
	bool CF_rt;
	//ѾùCFλ
	if((pFlagsAbout->HasGetted>>FLAG_OFFSET_CF) & 0x01)
		return ((*pEFlags)>>E_CF) & 0x01;

	switch(pFlagsAbout->CurFlagOpCodeName){
	case FLAG_CN_ADD8:
	case FLAG_CN_XADD8:
		CF_rt = pFlagsAbout->res.u8 < pFlagsAbout->op1.u8;
		break;
	case FLAG_CN_ADD16:
	case FLAG_CN_XADD16:
		CF_rt = pFlagsAbout->res.u16 < pFlagsAbout->op1.u16;
		break;
	case FLAG_CN_ADD32:
	case FLAG_CN_XADD32:
		CF_rt = pFlagsAbout->res.u32 < pFlagsAbout->op1.u32;
		break;
	case FLAG_CN_ADC8:
		CF_rt = (pFlagsAbout->res.u8 < pFlagsAbout->op1.u8) || (pFlagsAbout->PreCF && (pFlagsAbout->res.u8 == pFlagsAbout->op1.u8));
		break;
	case FLAG_CN_ADC16:
		CF_rt = (pFlagsAbout->res.u16 < pFlagsAbout->op1.u16) || (pFlagsAbout->PreCF && (pFlagsAbout->res.u16 == pFlagsAbout->op1.u16));
		break;
	case FLAG_CN_ADC32:
		CF_rt = (pFlagsAbout->res.u32 < pFlagsAbout->op1.u32) || (pFlagsAbout->PreCF && (pFlagsAbout->res.u32 == pFlagsAbout->op1.u32));
		break;
	case FLAG_CN_SUB8:
    case FLAG_CN_CMP8:
    case FLAG_CN_CMPS8:
    case FLAG_CN_SCAS8:
		CF_rt = pFlagsAbout->op1.u8 < pFlagsAbout->op2.u8;
		break;
	case FLAG_CN_SUB16:
    case FLAG_CN_CMP16:
    case FLAG_CN_CMPS16:
    case FLAG_CN_SCAS16:
		CF_rt = pFlagsAbout->op1.u16 < pFlagsAbout->op2.u16;
		break;
	case FLAG_CN_SUB32:
    case FLAG_CN_CMP32:
    case FLAG_CN_CMPS32:
    case FLAG_CN_SCAS32:
		CF_rt = pFlagsAbout->op1.u32 < pFlagsAbout->op2.u32;
		break;
	case FLAG_CN_SBB8:
		CF_rt = (pFlagsAbout->op1.u8 < pFlagsAbout->res.u8) || ((pFlagsAbout->op2.u8 == 0xFF) && pFlagsAbout->PreCF);
		break;
	case FLAG_CN_SBB16:
		CF_rt = (pFlagsAbout->op1.u16 < pFlagsAbout->res.u16) || ((pFlagsAbout->op2.u16 == 0xFFFF) && pFlagsAbout->PreCF);
		break;
	case FLAG_CN_SBB32:
		CF_rt = (pFlagsAbout->op1.u32 < pFlagsAbout->res.u32) || ((pFlagsAbout->op2.u32 == 0xFFFFFFFF) && pFlagsAbout->PreCF);
		break;
	case FLAG_CN_NEG8:
		CF_rt = pFlagsAbout->op1.u8 != 0;
		break;
	case FLAG_CN_NEG16:
		CF_rt = pFlagsAbout->op1.u16 != 0;
		break;
	case FLAG_CN_NEG32:
		CF_rt = pFlagsAbout->op1.u32 != 0;
		break;
	case FLAG_CN_OR8:
	case FLAG_CN_OR16:
	case FLAG_CN_OR32:
	case FLAG_CN_AND8:
	case FLAG_CN_AND16:
	case FLAG_CN_AND32:
	case FLAG_CN_TEST8:
	case FLAG_CN_TEST16:
	case FLAG_CN_TEST32:
	case FLAG_CN_XOR8:
	case FLAG_CN_XOR16:
	case FLAG_CN_XOR32:
		CF_rt = 0;
		break;
	case FLAG_CN_SHR8:
		CF_rt = (pFlagsAbout->op1.u8 >> (pFlagsAbout->op2.u8-1)) & 0x01;
		break;
	case FLAG_CN_SHR16:
		CF_rt = (pFlagsAbout->op1.u16 >> (pFlagsAbout->op2.u16-1)) & 0x01;
		break;
	case FLAG_CN_SHR32:
		CF_rt = (pFlagsAbout->op1.u32 >> (pFlagsAbout->op2.u32-1)) & 0x01;
		break;
	case FLAG_CN_SHL8:
		if(pFlagsAbout->op2.u8 <= 8)
		{
			CF_rt = (pFlagsAbout->op1.u8 >> (8 - pFlagsAbout->op2.u8)) & 0x01;
		}
		else
		{
			CF_rt = 0;
		}
		break;
	case FLAG_CN_SHL16:
		if(pFlagsAbout->op2.u16 <= 16)
		{
			CF_rt = (pFlagsAbout->op1.u16 >> (16 - pFlagsAbout->op2.u16)) & 0x01;
		}
		else
		{
			CF_rt = 0;
		}
		break;
	case FLAG_CN_SHL32:
		CF_rt = (pFlagsAbout->op1.u32 >> (32 - pFlagsAbout->op2.u32)) & 0x01;
		break;
	default:
		CF_rt = 0;
		KdPrint(("FlagsGetCFByFlagAb г˲ʶ\n"));
	}
	pFlagsAbout->HasGetted |= (0x01<<FLAG_OFFSET_CF);
	*pEFlags &= E_CF_C;
	*pEFlags |= CF_rt<<E_CF;
	return CF_rt;
}

void FlagsGetAllByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags){
	if(pFlagsAbout->HasGetted = 63)		//63 == 111111B
		return;
	FlagsGetOFByFlagAb(pFlagsAbout,pEFlags);
	FlagsGetSFByFlagAb(pFlagsAbout,pEFlags);
	FlagsGetZFByFlagAb(pFlagsAbout,pEFlags);
	FlagsGetAFByFlagAb(pFlagsAbout,pEFlags);
	FlagsGetPFByFlagAb(pFlagsAbout,pEFlags);
	FlagsGetCFByFlagAb(pFlagsAbout,pEFlags);
}