#include "general.h"
#include "VMM/Emulator/SubTableUses.h"
#include "VMM/Emulator/A2ZH/_Define.h"
#include "VMM/Emulator/EmuData.h"

void d_1_16_16_SubTable_0F(tpEmulator pEm){
	unsigned char rr;
	rr = *(pEm->pCIS+1);
	pEm->Instr.ExecuteFun = InstrSubTable_OF[rr].ExecuteFun_1_16_16;	//Ӧӱӱдֵٱı
	pEm->Instr.pi = &InstrSubTable_OF[rr];
	InstrSubTable_OF[rr].DeCompile_1_16_16(pEm);
}

void d_1_16_16_SubTable_80(tpEmulator pEm){		//r/m8, imm8
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.u8 = *(unsigned char *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len++;
	//InstrSubTable_80[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲,ͬҲ
	pEm->Instr.ExecuteFun = InstrSubTable_80[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_80[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_81(tpEmulator pEm){		//r/m16,imm16
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.u16 = *(unsigned short *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len += 2;
	//InstrSubTable_81[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲,ͬҲ
	pEm->Instr.ExecuteFun = InstrSubTable_81[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_81[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

//82ӱ80ӱͬ
void d_1_16_16_SubTable_82(tpEmulator pEm){		//r/m8, imm8
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.u8 = *(unsigned char *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len++;
	//InstrSubTable_80[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲,ͬҲ
	pEm->Instr.ExecuteFun = InstrSubTable_80[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_80[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_83(tpEmulator pEm){		//r/m16, imm8		imm8Ϊз
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.s8 = *(signed char *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len++;
	//InstrSubTable_83[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲,ͬҲ
	pEm->Instr.ExecuteFun = InstrSubTable_83[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_83[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_C0(tpEmulator pEm){		//rm8, imm8
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.u8 = *(unsigned char *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len++;
	//InstrSubTable_C0[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲,ͬҲ
	pEm->Instr.ExecuteFun = InstrSubTable_C0[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_C0[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_C1(tpEmulator pEm){
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.u8 = *(unsigned char *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len++;
	//InstrSubTable_C1[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲,ͬҲ
	pEm->Instr.ExecuteFun = InstrSubTable_C1[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_C1[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_D0(tpEmulator pEm){		//r/m8, 1
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m
	//InstrSubTable_D0[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲,ͬҲ
	pEm->Instr.ExecuteFun = InstrSubTable_D0[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_D0[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_D1(tpEmulator pEm){		//r/m16,1
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m
	//InstrSubTable_D1[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲,ͬҲ
	pEm->Instr.ExecuteFun = InstrSubTable_D1[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_D1[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_D2(tpEmulator pEm){		//r/m8, CL
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m
	//InstrSubTable_D2[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲
	pEm->Instr.ExecuteFun = InstrSubTable_D2[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_D2[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_D3(tpEmulator pEm){		//r/m16, CL
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m
	//InstrSubTable_D3[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲
	pEm->Instr.ExecuteFun = InstrSubTable_D3[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_D3[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_D8(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTable_D8δģ\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_D9(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTable_D9δģ\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_DA(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTable_DAδģ\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_DB(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTable_DBδģ\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_DC(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTable_DCδģ\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_DD(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTable_DDδģ\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_DE(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTable_DEδģ\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_DF(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTable_DFδģ\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_F6(tpEmulator pEm){		//r/m8  	/0 test   r/m8, imm8
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m
	InstrSubTable_F6[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲
	pEm->Instr.ExecuteFun = InstrSubTable_F6[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_F6[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_F7(tpEmulator pEm){		//TEST	/0 r/m16,imm16		r/m16
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m
	InstrSubTable_F7[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲
	pEm->Instr.ExecuteFun = InstrSubTable_F7[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_F7[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_FE(tpEmulator pEm){
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m
	//InstrSubTable_FE[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲
	pEm->Instr.ExecuteFun = InstrSubTable_FE[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_FE[rr];
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void d_1_16_16_SubTable_FF(tpEmulator pEm){		//r/m16 or m16:16
	//***ӱcall jumpתָpEm->pCIS DeCompileм
	unsigned char rr;
	pEm->Instr.len = 1;
	pEm->pCIS++;
	
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*(pEm->pCIS)>>3)&7;
	rr = pEm->Instr.r;
	PreFatchRM_1_16(pEm);		//r/m
	InstrSubTable_FF[rr].DeCompile_1_16_16(pEm);	//еÿԱӦָֻһ˲
	pEm->Instr.ExecuteFun = InstrSubTable_FF[rr].ExecuteFun_1_16_16;
	pEm->Instr.pi = &InstrSubTable_FF[rr];
}

//ӱ0Fӱ
void d_1_16_16_SubTable_0F_00(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTable_0F_00δģ\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_0F_01(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTableδģ_0F_01\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_0F_18(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTableδģ_0F_18\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_0F_71(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTableδģ_0F_71\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_0F_72(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTableδģ_0F_72\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_0F_73(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTableδģ_0F_73\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_0F_AE(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTableδģ_0F_AE\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_0F_BA(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTableδģ_0F_BA\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}

void d_1_16_16_SubTable_0F_CF(tpEmulator pEm){
	KdPrint(("d_1_16_16_SubTableδģ_0F_CF\n"));
#ifdef SS_DEBUG
	pEm->pCVC->VMM.EM.bc = TRUE;
#endif
}