#include "general.h"
#include "VMM/Emulator/RunIns.h"
#include "VMM/Emulator/EmuData.h"
#include "VMM/Emulator/A2ZH/_Define.h"
#include "VMM/Emulator/A2ZH/J__.h"

//'''''''''''''RunIns in Protected mode'''''''''''''
//---16 bit oprand and 16 bit address---
bool RunIns_0(PVOID pEmulator){
	KdPrint(("RunIns_0δģ\n"));
	return TRUE;
}

//'''''''''''''RunIns in Real-address mode'''''''''''''
//---16 bit oprand and 16 bit address---
bool RunIns_1(PVOID pEmulator){
	tpEmulator pEmu;
	unsigned char prefix;
	unsigned short * pCX;
	bool ZFlag;
	pEmu = (tpEmulator)(pEmulator);
	prefix = pEmu->Instr.prefix_g1;
	if(prefix == 0){
		pEmu->Instr.ExecuteFun(pEmu);
	}
	else{
		//δģʱreturn FALSE;
		switch(prefix){

		case PREFIX_G1_F2:	//REPNE/REPNZ
			if(((pIais)pEmu->Instr.pi)->Attr == IA_REPZ)	//CX != 0  ZF = 0
			{
				pCX = &(pEmu->pReg->_CX);
				ZFlag = FALSE;	//һִ
				while(*pCX && (!ZFlag)){
					pEmu->Instr.ExecuteFun(pEmu);
					ZFlag = FlagsGetZFByFlagAb(&pEmu->FlagsAbout,&(pEmu->pReg->_EFLAGS));
					(*pCX)--;
				}
			}
			else if(((pIais)pEmu->Instr.pi)->Attr == IA_REP){		//CX != 0
				pCX = &(pEmu->pReg->_CX);
				while(*pCX){
					pEmu->Instr.ExecuteFun(pEmu);
					(*pCX)--;
				}
			}
			break;
		case PREFIX_G1_F3:	//REP
			if(((pIais)pEmu->Instr.pi)->Attr == IA_REP)	//CX != 0
			{
				pCX = &(pEmu->pReg->_CX);
				while(*pCX){
					pEmu->Instr.ExecuteFun(pEmu);
					(*pCX)--;
				}
			}
			else if(((pIais)pEmu->Instr.pi)->Attr == IA_REPZ)	//CX != 0  ZF != 0
			{
				pCX = &(pEmu->pReg->_CX);
				ZFlag = TRUE;	//һִ
				while(*pCX && ZFlag){
					pEmu->Instr.ExecuteFun(pEmu);
					ZFlag = FlagsGetZFByFlagAb(&pEmu->FlagsAbout,&(pEmu->pReg->_EFLAGS));
					(*pCX)--;
				}
			}
			break;
		case PREFIX_G1_F0:	//LOCK
			KdPrint(("ERROR: δģǰ׺ %X",prefix));
			break;
		default:
			return FALSE;
		}
	}
	MoveEipToNextContInstr_1_16(pEmu);
	return TRUE;
}

