#include "general.h"
#include "VMM/Emulator/MemAccess.h"
#include "VMM/Emulator/ExcepOrInterr.h"

//###############  MemWrite  #################
//------------------Write directly--------------------
//MemAccess.h ʵ

//-----------Write with segment and offset----------
void MemWrite_0_8(tpEmulator pEm , int SegmentType , unsigned int offset ,unsigned char value){
	KdPrint(("MemWrite_0_8δģ\n"));
}

void MemWrite_1_8(tpEmulator pEm , int SegmentType , unsigned short offset ,unsigned char value){
	//ʵַģʽ£ûл(Base  limitlimit ĬΪ0xFFFF)
	WritePhyMemDirectly_8(pEm,pEm->ModrmA.sreg_16[SegmentType]->h.Base+offset,value);
}

void MemWrite_0_16(tpEmulator pEm , int SegmentType , unsigned int offset ,unsigned short value){
	KdPrint(("MemWrite_0_16δģ\n"));
}

void MemWrite_1_16(tpEmulator pEm , int SegmentType , unsigned short offset ,unsigned short value){
	//ʵַģʽ£ûл(Base  limitlimit ĬΪ0xFFFF)
#ifdef SS_RUN_STRICT
	if(offset == 0xFFFF)	//ܿҳ
	{
		if(SegmentType == SS_SEGMENT_SS)
			Exception_1(FALSE,EOI_SS,0);
		else
			Exception_1(FALSE,EOI_GP,0);
	}
#endif
	WritePhyMemDirectly_16(pEm,pEm->ModrmA.sreg_16[SegmentType]->h.Base+offset,value);
}

void MemWrite_0_32(tpEmulator pEm , int SegmentType , unsigned int offset ,unsigned int value){
	KdPrint(("MemWrite_0_32δģ\n"));
}

void MemWrite_1_32(tpEmulator pEm , int SegmentType , unsigned short offset ,unsigned int value){
	//ʵַģʽ£ûл(Base  limitlimit ĬΪ0xFFFF)
#ifdef SS_RUN_STRICT
	if(offset >= 0xFFFD)		//ܿҳ
	{
		if(SegmentType == SS_SEGMENT_SS)
			Exception_1(FALSE,EOI_SS,0);
		else
			Exception_1(FALSE,EOI_GP,0);
	}
#endif
	WritePhyMemDirectly_32(pEm,pEm->ModrmA.sreg_16[SegmentType]->h.Base+offset,value);
}


//###############  MemRead  #################

//------------------Read directly--------------------
//MemAccess.h ʵ

//-----------Read with segment and offset----------

unsigned char MemRead_0_8(tpEmulator pEm , int SegmentType , unsigned int offset){
	KdPrint(("MemRead_0_8δģ\n"));
	return 0;
}

unsigned char MemRead_1_8(tpEmulator pEm , int SegmentType , unsigned short offset){
	return ReadPhyMemDirectly_8(pEm,pEm->ModrmA.sreg_16[SegmentType]->h.Base+offset);
}

unsigned short MemRead_0_16(tpEmulator pEm , int SegmentType , unsigned int offset){
	KdPrint(("MemRead_0_16δģ\n"));
	return 0;
}

unsigned short MemRead_1_16(tpEmulator pEm , int SegmentType , unsigned short offset){
	//ʵַģʽ£ûл(Base  limitlimit ĬΪ0xFFFF)
#ifdef SS_RUN_STRICT
	if(offset == 0xFFFF)
	{
		Exception_1(FALSE,EOI_GP,0);
	}
#endif
	return ReadPhyMemDirectly_16(pEm,pEm->ModrmA.sreg_16[SegmentType]->h.Base+offset);
}

unsigned int MemRead_0_32(tpEmulator pEm , int SegmentType , unsigned int offset){
	KdPrint(("MemRead_0_32δģ\n"));
	return 0;
}

unsigned int MemRead_1_32(tpEmulator pEm , int SegmentType , unsigned short offset){
	//ʵַģʽ£ûл(Base  limitlimit ĬΪ0xFFFF)
#ifdef SS_RUN_STRICT
	if(offset >= 0xFFFD)		//ܿҳ
	{
		Exception_1(FALSE,EOI_GP,0);
	}
#endif
	return ReadPhyMemDirectly_32(pEm,pEm->ModrmA.sreg_16[SegmentType]->h.Base+offset);
}