#include "general.h"
#include "VMM/Emulator/GetIns.h"
#include "VMM/Emulator/Emulator.h"
#include "VMM/Emulator/EmuData.h"
#include "VMM/Emulator/CodeName.h"


//''''''''''''GetIns_0 in Protected mode''''''''''''''
//---16 bit oprand and 16 bit address---
bool GetIns_0_16_16(PVOID pEmulator){
	KdPrint(("GetIns_0_16_16 δģ\n"));
	return TRUE;
}

//---32 bit oprand and 16 bit address---
bool GetIns_0_32_16(PVOID pEmulator){
	KdPrint(("GetIns_0_32_16 δģ\n"));
	return TRUE;
}

//---16 bit oprand and 32 bit address---
bool GetIns_0_16_32(PVOID pEmulator){
	KdPrint(("GetIns_0_16_32 δģ\n"));
	return TRUE;
}

//---32 bit oprand and 32 bit address---
bool GetIns_0_32_32(PVOID pEmulator){
	KdPrint(("GetIns_0_32_32 δģ\n"));
	return TRUE;
}


//'''''''''''GetIns_1 in Real-address mode'''''''''''''
//---16 bit oprand and 16 bit address---
bool GetIns_1_16_16(PVOID pEmulator){
	tpEmulator pEmu;
	pEmu = (tpEmulator)(pEmulator);

	//>>
	if(InstrAbout[*(pEmu->pCIS)].Instruction==NULL)
	{
		KdPrint(("ָδģ\n"));
		return FALSE;
	}
	//<<
	pEmu->Instr.pi = &InstrAbout[*(pEmu->pCIS)];
	InstrAbout[*(pEmu->pCIS)].DeCompile_1_16_16(pEmu);

	return TRUE;
}

//---32 bit oprand and 16 bit address---
bool GetIns_1_32_16(PVOID pEmulator){
	tpEmulator pEmu;
	pEmu = (tpEmulator)(pEmulator);

	//>>
	if(InstrAbout[*(pEmu->pCIS)].Instruction==NULL)
	{
		KdPrint(("ָδģ\n"));
		return FALSE;
	}
	//<<
	pEmu->Instr.pi = &InstrAbout[*(pEmu->pCIS)];
	InstrAbout[*(pEmu->pCIS)].DeCompile_1_32_16(pEmu);
	return TRUE;
}

//---16 bit oprand and 32 bit address---
bool GetIns_1_16_32(PVOID pEmulator){
	KdPrint(("GetIns_1_16_32 δģ\n"));
	return TRUE;
}

//---32 bit oprand and 32 bit address---
bool GetIns_1_32_32(PVOID pEmulator){
	KdPrint(("GetIns_1_32_32 δģ\n"));
	return TRUE;
}
