#include "general.h"
#include "VMM/Emulator/ExcepOrInterr.h"
#include "Function.h"
#include "VMM/Emulator/EmuData.h"
#include "VMM/Emulator/A2ZH/_Define.h"

void InvalidOpcode_0(tpEmulator pEm){
	KdPrint(("ָЧ!!!\n"));
	Exception_0(pEm,EOI_UD,0);
}

void InvalidOpcode_1(tpEmulator pEm){
	KdPrint(("ָЧ!!!\n"));
	Exception_1(pEm,EOI_UD,0);
}

void Fatal_Err_0(tpEmulator pEm,char * reason){
	KdPrint(("һĴ,ԭΪ%s\n",reason));
	Exception_0(pEm,EOI_DF,0);
}

void Fatal_Err_1(tpEmulator pEm,char * reason){
	KdPrint(("һĴ,ԭΪ%s\n",reason));
	Exception_1(pEm,EOI_DF,0);
}

void LessFatal_Err_0(tpEmulator pEm,char * reason){
}
void LessFatal_Err_1(tpEmulator pEm,char * reason){
}


void Exception_0(tpEmulator pEm,unsigned vector,unsigned short ErrCode){
	bool HasErrCode = FALSE;
	switch(vector){
	case 0:
		break;
	case 1:
		break;
	case 2:
		break;
	case 3:
		break;
	case 4:
		break;
	case 5:
		break;
	case 6:
		break;
	case 7:
		break;
	case 8:
		HasErrCode = TRUE;
		break;
	case 9:
		break;
	case 10:
		HasErrCode = TRUE;
		break;
	case 11:
		HasErrCode = TRUE;
		break;
	case 12:
		HasErrCode = TRUE;
		break;
	case 13:
		HasErrCode = TRUE;
		break;
	case 14:
		HasErrCode = TRUE;
		break;
	case 15:
		break;
	case 16:
		break;
	case 17:
		HasErrCode = TRUE;
		break;
	case 18:
		break;
	case 19:
		break;
	default:
		KdPrint(("쳣(exception code)\n"));
		return;
		break;
	}
	ExcepOrInterr_0(pEm,FALSE,vector,HasErrCode,ErrCode);
}
void ExcepOrInterr_0(tpEmulator pEm,bool IsInterr, unsigned vector,bool HasErrCode,unsigned short ErrCode){
}

void Exception_1(tpEmulator pEm,unsigned vector,unsigned short ErrCode){
	switch(vector){
	case 0:
		break;
	case 1:
		break;
	case 2:
		break;
	case 3:
		break;
	case 4:
		break;
	case 5:
		break;
	case 6:
		break;
	case 7:
		break;
	case 8:
		break;
	case 9://Reserved
		KdPrint(("ʵַģʽ£쳣9\n"));
		return;
		break;
	case 10://Reserved
		KdPrint(("ʵַģʽ£쳣10\n"));
		return;
		break;
	case 11://Reserved
		KdPrint(("ʵַģʽ£쳣11\n"));
		return;
		break;
	case 12:
		break;
	case 13:
		break;
	case 14://Reserved
		KdPrint(("ʵַģʽ£쳣14\n"));
		return;
		break;
	case 15://Reserved
		KdPrint(("ʵַģʽ£쳣15\n"));
		return;
		break;
	case 16:
		break;
	case 17://Reserved
		KdPrint(("ʵַģʽ£쳣17\n"));
		return;
		break;
	case 18:
		break;
	default:
		KdPrint(("쳣(exception code)\n"));
		return;
		break;
	}
	ExcepOrInterr_1(pEm,FALSE,vector,FALSE,0);
}
void ExcepOrInterr_1(tpEmulator pEm,bool IsInterr, unsigned vector,bool HasErrCode,unsigned short ErrCode){
	//Intel IA-32	A-M.pdf		page.573 & page574
	unsigned int * pEFlags;
	if((vector*4+3) > pEm->pReg->IDTR.Limit)
	{
		Exception_1(pEm,EOI_GP,0);
	}
	pEFlags = &pEm->pReg->_EFLAGS;

	FlagsGetAllByFlagAb(&(pEm->FlagsAbout),pEFlags);
	Push2Stack_1_16(pEm,*(unsigned short *)pEFlags);

	FlagsClearIF(pEFlags);
	FlagsClearTF(pEFlags);
	FlagsClearAC(pEFlags);

	Push2Stack_1_16(pEm,pEm->pReg->xCS.v);

	Push2Stack_1_16(pEm,pEm->pReg->_IP);

	pEm->pReg->_IP = ReadPhyMemDirectly_16(pEm,pEm->pReg->IDTR.Base+4*vector);
	pEm->pReg->xCS.v = ReadPhyMemDirectly_16(pEm,pEm->pReg->IDTR.Base+4*vector+2);
	pEm->pReg->xCS.h.Base = pEm->pReg->xCS.v * 16;

	pEm->pCIS = (unsigned char *)(pEm->pGPM + pEm->pReg->xCS.h.Base + pEm->pReg->_IP);
}