#include "general.h"
#include "VMM/Emulator/Emulator.h"
#include "VMM/Emulator/EmuData.h"
#include "VMM/Emulator/RunIns.h"
#include "VMM/Emulator/GetIns.h"
#include "VMM/Emulator/CodeName.h"
#include "Function.h"

EXERESULT EmulatorCreate(tpEmulator * ppEmulator){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("EmulatorCreate\n"));
	*ppEmulator = (tpEmulator)ExAllocatePoolWithTag(NonPagedPool,sizeof(tEmulator),SS_HOST_USED_POOL);	//EmulatorReleaseͷ
	if(*ppEmulator == NULL)
		rt = SS_ALLOC_MEM_ERR;
	return rt;
}

EXERESULT EmulatorInit(tpEmulator pEmulator,tpCVC pCVC , int ThreadID){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("EmulatorInit\n"));
	pEmulator->pCVC = pCVC;
	pEmulator->CpuID = ThreadID;
	pEmulator->pReg = &(pCVC->VM.Cpu.pReg[ThreadID]);
	pEmulator->pGPM = (char *)(pCVC->VM.Mem.pGuestPhyMem);
	pEmulator->pCIS = (unsigned char *)pCVC->VM.Mem.pGuestPhyMem+pEmulator->pReg->xCS.h.Base+pEmulator->pReg->_IP;
	pEmulator->CpuMode = REAL_ADDRESS_MODE;
	pEmulator->SD_FLAG_DB = FALSE;

	pEmulator->Instr.ExecuteFun = NULL;
	pEmulator->Instr.len = 0;
	pEmulator->Instr.mod = 0;
	pEmulator->Instr.r = 0;
	pEmulator->Instr.rm = 0;
	pEmulator->Instr.argu1.s32 = 0;
	pEmulator->Instr.argu2.s32 = 0;
	pEmulator->Instr.argu3.s16 = 0;

	pEmulator->FlagsAbout.CurFlagOpCodeName = FLAG_CN_UNDEFINE;
	pEmulator->FlagsAbout.HasGetted = 0x00;
	pEmulator->FlagsAbout.op1.u32 = 0x00;
	pEmulator->FlagsAbout.op2.u32 = 0x00;
	pEmulator->FlagsAbout.res.u32 = 0x00;
	pEmulator->FlagsAbout.PreCF = 0;

	EmulatorInitModRMTable(pEmulator);
	EmulatorInitGlobalFunPoint();
	EmulatorInitGlobalSubTable();

	pEmulator->CurGetIns = GetIns[REAL_ADDRESS_MODE][OPRAND16][ADDRESS16];		// REAL_ADDRESS_MODE==1
	pEmulator->CurRunIns = RunIns[REAL_ADDRESS_MODE];		// REAL_ADDRESS_MODE==1

	return rt;
}

EXERESULT EmulatorRelease(tpEmulator pEmulator){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("EmulatorRelease\n"));
	if(pEmulator != NULL)
	{
		ExFreePool(pEmulator);
	}
	return rt;
}

EXERESULT EmulateOneInstr(tpEmulator pEm){
	EXERESULT rt = SS_SUCCESS;
	bool rtbool = TRUE;
	int Prefix_G1 = 0;
	int Prefix_len = 0;
	bool FirstPrefix = TRUE;
	int OprandSize;
	int AddressSize;
	int CpuMode;
	bool (* PreGetIns)(PVOID pEmulator);
	unsigned char curcis;
	//ȡָ
	PreGetIns = pEm->CurGetIns;
	pEm->Instr.sreg = SS_SEGMENT_UNDEFINED;
	while(1){
		curcis = *(pEm->pCIS);
		if(InstrAbout[curcis].CodeName == SS_CN_PREFIX)
		{
			//һЩǰ׺йصıӳٵ˴ֵ
			if(FirstPrefix){
				if(pEm->SD_FLAG_DB){	//ĬΪ32λ32λַģʽ
					OprandSize = OPRAND32;
					AddressSize = ADDRESS32;
				}
				else{					//ĬΪ16λ16λַģʽ
					OprandSize = OPRAND16;
					AddressSize = ADDRESS16;
				}
				if(pEm->CpuMode == REAL_ADDRESS_MODE)
					CpuMode = REAL_ADDRESS_MODE;
				else
					CpuMode = PROTECTED_MODE;
				FirstPrefix = FALSE;
			}
			switch(curcis){
			case 0x66:	//Operand-size override
				if(pEm->SD_FLAG_DB){	//ĬΪ32λ
					OprandSize = OPRAND16;
					pEm->CurGetIns = GetIns[CpuMode][OprandSize][AddressSize];
				}
				else{					//ĬΪ16λ
					OprandSize = OPRAND32;
					pEm->CurGetIns = GetIns[CpuMode][OprandSize][AddressSize];
				}
				break;
			case 0x67:	//Address-size override
				if(pEm->SD_FLAG_DB){		//ĬΪ32λַģʽ
					AddressSize = ADDRESS32;
					pEm->CurGetIns = GetIns[CpuMode][OprandSize][AddressSize];
				}
				else{						//ĬΪ16λַģʽ
					AddressSize = ADDRESS32;
					pEm->CurGetIns = GetIns[CpuMode][OprandSize][AddressSize];
				}
				break;
			case 0xF2:	//REPNE/REPNZ
				Prefix_G1 = PREFIX_G1_F2;
				break;
			case 0xF3:	//REP	REPE/REPZ
				Prefix_G1 = PREFIX_G1_F3;
				break;
			case 0x2E:	//CS
				pEm->Instr.sreg = SS_SEGMENT_CS;
				break;
			case 0x26:	//ES
				pEm->Instr.sreg = SS_SEGMENT_ES;
				break;
			case 0x36:	//SS
				pEm->Instr.sreg = SS_SEGMENT_SS;
				break;
			case 0x3E:	//DS
				pEm->Instr.sreg = SS_SEGMENT_DS;
				break;
			case 0x64:	//FS
				pEm->Instr.sreg = SS_SEGMENT_FS;
				break;
			case 0x65:	//GS
				pEm->Instr.sreg = SS_SEGMENT_GS;
				break;
			case 0xF0:	//LOCK
				Prefix_G1 = PREFIX_G1_F0;
				break;
			default:
				return SS_CUR_INSTR_UN_EMULATED_ERR;
			}
			pEm->pCIS++;
			Prefix_len++;
		}
		else
			break;
	}
	rtbool = pEm->CurGetIns(pEm);
	pEm->Instr.len += Prefix_len;
	pEm->CurGetIns = PreGetIns;
	pEm->Instr.prefix_g1 = Prefix_G1;
	if(rtbool){
		//ԺǷqemuķ? wow
		//CurTranlateIns(pEmulator);
		//
		rtbool = pEm->CurRunIns(pEm);
		if(!rtbool)
			rt = SS_CUR_INSTR_UN_EMULATED_ERR;
	}
	else{
		rt = SS_CUR_INSTR_UN_EMULATED_ERR;
	}
	return rt;
}

EXERESULT EmulateABlockOfInstr(tpEmulator pEmulator){
	EXERESULT rt = SS_SUCCESS;
	return rt;
}
EXERESULT EmulatorInitModRMTable(tpEmulator pEmulator){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("EmulatorInitModRMTable\n"));

	//r_8[8]
	pEmulator->ModrmA.r_8[0] = &(pEmulator->pReg->_AL);
	pEmulator->ModrmA.r_8[1] = &(pEmulator->pReg->_CL);
	pEmulator->ModrmA.r_8[2] = &(pEmulator->pReg->_DL);
	pEmulator->ModrmA.r_8[3] = &(pEmulator->pReg->_BL);
	pEmulator->ModrmA.r_8[4] = &(pEmulator->pReg->_AH);
	pEmulator->ModrmA.r_8[5] = &(pEmulator->pReg->_CH);
	pEmulator->ModrmA.r_8[6] = &(pEmulator->pReg->_DH);
	pEmulator->ModrmA.r_8[7] = &(pEmulator->pReg->_BH);
	//r_16[8]
	pEmulator->ModrmA.r_16[0] = &(pEmulator->pReg->_AX);
	pEmulator->ModrmA.r_16[1] = &(pEmulator->pReg->_CX);
	pEmulator->ModrmA.r_16[2] = &(pEmulator->pReg->_DX);
	pEmulator->ModrmA.r_16[3] = &(pEmulator->pReg->_BX);
	pEmulator->ModrmA.r_16[4] = &(pEmulator->pReg->_SP);
	pEmulator->ModrmA.r_16[5] = &(pEmulator->pReg->_BP);
	pEmulator->ModrmA.r_16[6] = &(pEmulator->pReg->_SI);
	pEmulator->ModrmA.r_16[7] = &(pEmulator->pReg->_DI);
	//r_32[8]
	pEmulator->ModrmA.r_32[0] = &(pEmulator->pReg->_EAX);
	pEmulator->ModrmA.r_32[1] = &(pEmulator->pReg->_ECX);
	pEmulator->ModrmA.r_32[2] = &(pEmulator->pReg->_EDX);
	pEmulator->ModrmA.r_32[3] = &(pEmulator->pReg->_EBX);
	pEmulator->ModrmA.r_32[4] = &(pEmulator->pReg->_ESP);
	pEmulator->ModrmA.r_32[5] = &(pEmulator->pReg->_EBP);
	pEmulator->ModrmA.r_32[6] = &(pEmulator->pReg->_ESI);
	pEmulator->ModrmA.r_32[7] = &(pEmulator->pReg->_EDI);
	//rm_mod0_16[8][2]
	pEmulator->ModrmA.rm_mod0_16[0][0] = &(pEmulator->pReg->_BX); pEmulator->ModrmA.rm_mod0_16[0][1] = &(pEmulator->pReg->_SI);
	pEmulator->ModrmA.rm_mod0_16[1][0] = &(pEmulator->pReg->_BX); pEmulator->ModrmA.rm_mod0_16[1][1] = &(pEmulator->pReg->_DI);
	pEmulator->ModrmA.rm_mod0_16[2][0] = &(pEmulator->pReg->_BP); pEmulator->ModrmA.rm_mod0_16[2][1] = &(pEmulator->pReg->_SI);
	pEmulator->ModrmA.rm_mod0_16[3][0] = &(pEmulator->pReg->_BP); pEmulator->ModrmA.rm_mod0_16[3][1] = &(pEmulator->pReg->_DI);
	pEmulator->ModrmA.rm_mod0_16[4][0] = &(pEmulator->pReg->_SI); pEmulator->ModrmA.rm_mod0_16[4][1] = &(_Zero._Zero16);
	pEmulator->ModrmA.rm_mod0_16[5][0] = &(pEmulator->pReg->_DI); pEmulator->ModrmA.rm_mod0_16[5][1] = &(_Zero._Zero16);
	pEmulator->ModrmA.rm_mod0_16[6][0] = &(_Zero._Zero16);		  pEmulator->ModrmA.rm_mod0_16[6][1] = &(_Zero._Zero16);
	pEmulator->ModrmA.rm_mod0_16[7][0] = &(pEmulator->pReg->_BX); pEmulator->ModrmA.rm_mod0_16[7][1] = &(_Zero._Zero16);
	//rm_mod1o2_16[8][2]
	pEmulator->ModrmA.rm_mod1o2_16[0][0] = &(pEmulator->pReg->_BX); pEmulator->ModrmA.rm_mod1o2_16[0][1] = &(pEmulator->pReg->_SI);
	pEmulator->ModrmA.rm_mod1o2_16[1][0] = &(pEmulator->pReg->_BX); pEmulator->ModrmA.rm_mod1o2_16[1][1] = &(pEmulator->pReg->_DI);
	pEmulator->ModrmA.rm_mod1o2_16[2][0] = &(pEmulator->pReg->_BP); pEmulator->ModrmA.rm_mod1o2_16[2][1] = &(pEmulator->pReg->_SI);
	pEmulator->ModrmA.rm_mod1o2_16[3][0] = &(pEmulator->pReg->_BP); pEmulator->ModrmA.rm_mod1o2_16[3][1] = &(pEmulator->pReg->_DI);
	pEmulator->ModrmA.rm_mod1o2_16[4][0] = &(pEmulator->pReg->_SI); pEmulator->ModrmA.rm_mod1o2_16[4][1] = &(_Zero._Zero16);
	pEmulator->ModrmA.rm_mod1o2_16[5][0] = &(pEmulator->pReg->_DI); pEmulator->ModrmA.rm_mod1o2_16[5][1] = &(_Zero._Zero16);
	pEmulator->ModrmA.rm_mod1o2_16[6][0] = &(pEmulator->pReg->_BP); pEmulator->ModrmA.rm_mod1o2_16[6][1] = &(_Zero._Zero16);
	pEmulator->ModrmA.rm_mod1o2_16[7][0] = &(pEmulator->pReg->_BX); pEmulator->ModrmA.rm_mod1o2_16[7][1] = &(_Zero._Zero16);
	//rm_mod3_8[8]
	pEmulator->ModrmA.rm_mod3_8[0] = &(pEmulator->pReg->_AL);
	pEmulator->ModrmA.rm_mod3_8[1] = &(pEmulator->pReg->_CL);
	pEmulator->ModrmA.rm_mod3_8[2] = &(pEmulator->pReg->_DL);
	pEmulator->ModrmA.rm_mod3_8[3] = &(pEmulator->pReg->_BL);
	pEmulator->ModrmA.rm_mod3_8[4] = &(pEmulator->pReg->_AH);
	pEmulator->ModrmA.rm_mod3_8[5] = &(pEmulator->pReg->_CH);
	pEmulator->ModrmA.rm_mod3_8[6] = &(pEmulator->pReg->_DH);
	pEmulator->ModrmA.rm_mod3_8[7] = &(pEmulator->pReg->_BH);
	//rm_mod3_16[8]
	pEmulator->ModrmA.rm_mod3_16[0] = &(pEmulator->pReg->_AX);
	pEmulator->ModrmA.rm_mod3_16[1] = &(pEmulator->pReg->_CX);
	pEmulator->ModrmA.rm_mod3_16[2] = &(pEmulator->pReg->_DX);
	pEmulator->ModrmA.rm_mod3_16[3] = &(pEmulator->pReg->_BX);
	pEmulator->ModrmA.rm_mod3_16[4] = &(pEmulator->pReg->_SP);
	pEmulator->ModrmA.rm_mod3_16[5] = &(pEmulator->pReg->_BP);
	pEmulator->ModrmA.rm_mod3_16[6] = &(pEmulator->pReg->_SI);
	pEmulator->ModrmA.rm_mod3_16[7] = &(pEmulator->pReg->_DI);
	//rm_mod3_32[8]
	pEmulator->ModrmA.rm_mod3_32[0] = &(pEmulator->pReg->_EAX);
	pEmulator->ModrmA.rm_mod3_32[1] = &(pEmulator->pReg->_ECX);
	pEmulator->ModrmA.rm_mod3_32[2] = &(pEmulator->pReg->_EDX);
	pEmulator->ModrmA.rm_mod3_32[3] = &(pEmulator->pReg->_EBX);
	pEmulator->ModrmA.rm_mod3_32[4] = &(pEmulator->pReg->_ESP);
	pEmulator->ModrmA.rm_mod3_32[5] = &(pEmulator->pReg->_EBP);
	pEmulator->ModrmA.rm_mod3_32[6] = &(pEmulator->pReg->_ESI);
	pEmulator->ModrmA.rm_mod3_32[7] = &(pEmulator->pReg->_EDI);

	//sreg_16
	pEmulator->ModrmA.sreg_16[SS_SEGMENT_ES] = &(pEmulator->pReg->xES);
	pEmulator->ModrmA.sreg_16[SS_SEGMENT_CS] = &(pEmulator->pReg->xCS);
	pEmulator->ModrmA.sreg_16[SS_SEGMENT_SS] = &(pEmulator->pReg->xSS);
	pEmulator->ModrmA.sreg_16[SS_SEGMENT_DS] = &(pEmulator->pReg->xDS);
	pEmulator->ModrmA.sreg_16[SS_SEGMENT_FS] = &(pEmulator->pReg->xFS);
	pEmulator->ModrmA.sreg_16[SS_SEGMENT_GS] = &(pEmulator->pReg->xGS);
	return rt;
}
EXERESULT EmulatorInitGlobalFunPoint(){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("EmulatorInitGlobalFunPoint\n"));
	GetIns[0][0][0] = GetIns_0_16_16;
	GetIns[0][1][0] = GetIns_0_32_16;
	GetIns[1][0][0] = GetIns_1_16_16;
	GetIns[1][1][0] = GetIns_1_32_16;

	GetIns[0][0][1] = GetIns_0_16_32;
	GetIns[0][1][1] = GetIns_0_32_32;
	GetIns[1][0][1] = GetIns_1_16_32;
	GetIns[1][1][1] = GetIns_1_32_32;

	RunIns[0] = RunIns_0;
	RunIns[1] = RunIns_1;
	return rt;
}

EXERESULT EmulatorInitGlobalSubTable(){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("EmulatorInitGlobalSubTable\n"));
	return rt;
}