#include "general.h"
#include "VMM/Emulator/A2ZH/_Define.h"
#include "VMM/Emulator/A2ZH/X__.h"
#include "VMM/Emulator/A2ZH/_FatchRM.h"

//##############################################  XOR  ##################################################
//XOR AL, imm8		34		eg. xor al,0x80
void d_1_16_16_XOR_AL_imm8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_XOR_AL_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	res_u8 = op1_u8 ^ op2_u8;
	pEm->pReg->_AL = res_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_XOR8,0);
}

//XOR AX, imm16		35		eg. xor ax,0xaaaa
void d_1_16_16_XOR_AX_imm16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short*)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_XOR_AX_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = pEm->Instr.argu1.u16;
	res_u16 = op1_u16 ^ op2_u16;
	pEm->pReg->_AX = res_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_XOR16,0);
}

//XOR r8, r/m8		32		xor al,al
void d_1_16_16_XOR_r8_rm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_XOR_r8_rm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_r_value_8(pEm);
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	res_u8 = op1_u8 ^ op2_u8;
	SetModrm_r_value_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_XOR8,0);
}
//XOR r16, r/m16	0x33
void d_1_16_16_XOR_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_XOR_r16_rm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_r_value_16(pEm);
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	res_u16 = op1_u16 ^ op2_u16;
	SetModrm_r_value_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_XOR16,0);
}

//XOR r/m8, r8		30		eg. xor ah,ah
void d_1_16_16_XOR_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_XOR_rm8_r8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = GetModrm_r_value_8(pEm);
	res_u8 = op1_u8 ^ op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_XOR8,0);
}
//XOR r/m16, r16	31		xor ax,ax
void d_1_16_16_XOR_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_XOR_rm16_r16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = GetModrm_r_value_16(pEm);
	res_u16 = op1_u16 ^ op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_XOR16,0);
}

//XOR r/m8, imm8	/6		80
void d_1_16_16_XOR_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_XOR_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = pEm->Instr.argu2.u8;
	res_u8 = op1_u8 ^ op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_XOR8,0);
}

//XOR r/m16, imm8	/6		83
void d_1_16_16_XOR_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_XOR_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.s8;		//չ
	res_u16 = op1_u16 ^ op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_XOR16,0);
}

//XOR r/m16,imm16		/6		81
void d_1_16_16_XOR_rm16_imm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_XOR_rm16_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.u16;
	res_u16 = op1_u16 ^ op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_XOR16,0);
}
//##############################################  XCHG  ##################################################
//XCHG r16, AX		90 91 92 93 94 95 96 97
void d_1_16_16_XCHG_r16_AX(tpEmulator pEm){		//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.r = *pEm->pCIS-0x90;
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_XCHG_r16_AX(tpEmulator pEm){
	unsigned short temp;
	temp = GetModrm_r_value_16(pEm);
	SetModrm_r_value_16(pEm,pEm->pReg->_AX);
	pEm->pReg->_AX = temp;
}

//XCHG r16, r/m16		87		xchg cx,dx
void d_1_16_16_XCHG_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_XCHG_r16_rm16(tpEmulator pEm){
	unsigned short temp;
	FatchRM_1_16(pEm);
	temp = GetModrm_r_value_16(pEm);
	SetModrm_r_value_16(pEm,GetModrm_rm_value_1_16(pEm));
	SetModrm_rm_value_1_16(pEm,temp);
}

//XCHG r/m8, r8		86
void d_1_16_16_XCHG_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_XCHG_rm8_r8(tpEmulator pEm){
	unsigned char temp;
	FatchRM_1_16(pEm);
	temp = GetModrm_rm_value_1_8(pEm);
	SetModrm_rm_value_1_8(pEm,GetModrm_r_value_8(pEm));
	SetModrm_r_value_8(pEm,temp);
}

//##############################################  XLAT  ##################################################
//XLATB		D7
void d_1_16_16_XLATB(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_XLATB(tpEmulator pEm){
	pEm->pReg->_AL = MemRead_1_8(pEm,pEm->Instr.sreg,pEm->pReg->_BX+pEm->pReg->_AL);
}