#include "general.h"
#include "VMM/Emulator/A2ZH/T__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//##############################################  TEST  ##################################################
//TEST r/m8, imm8	/0	F6		eg. test byte [0x10],0x1
void d_1_16_16_TEST_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽݷ
	//ӱ亯Ѿõargu1
	pEm->Instr.argu2.u8 = *(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len++;
}

void e_1_16_16_TEST_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = pEm->Instr.argu2.u8;
	res_u8 = op1_u8 & op2_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_TEST8,0);
}

//TEST r/m16,imm16	F7
void d_1_16_16_TEST_rm16_imm16(tpEmulator pEm){
	//Ӧӱ亯ѽݷ
	//ӱ亯Ѿõargu1
	pEm->Instr.argu2.u16 = *(unsigned short *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len += 2;
}

void e_1_16_16_TEST_rm16_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.u16;
	res_u16 = op1_u16 & op2_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_TEST16,0);
}

//TEST r/m8, r8		84		eg. test al,al
void d_1_16_16_TEST_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_TEST_rm8_r8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = GetModrm_r_value_8(pEm);
	res_u8 = op1_u8 & op2_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_TEST8,0);
}

//TEST r/m16, r16		85		eg. test ax,ax
void d_1_16_16_TEST_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_TEST_rm16_r16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = GetModrm_r_value_16(pEm);
	res_u16 = op1_u16 & op2_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_TEST16,0);
}

//TEST AL, imm8		A8		eg. test al,0xf
void d_1_16_16_TEST_AL_imm8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_TEST_AL_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	res_u8 = op1_u8 & op2_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_TEST8,0);
}

//TEST AX, imm16	A9
void d_1_16_16_TEST_AX_imm16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_TEST_AX_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = pEm->Instr.argu1.u16;
	res_u16 = op1_u16 & op2_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_TEST16,0);
}