#include "general.h"
#include "VMM/Emulator/A2ZH/S__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//##############################################  STOSx  ##################################################
//STOSB
void d_1_16_16_STOSB(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}
void e_1_16_16_STOSB(tpEmulator pEm){
	MemWrite_1_8(pEm,SS_SEGMENT_ES,pEm->pReg->_DI,pEm->pReg->_AL);
	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_DI -= 1;
	}
	else //DF == 0
	{
		pEm->pReg->_DI += 1;
	}
}
//STOSW		AB
void d_1_16_16_STOSW(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_STOSW(tpEmulator pEm){
	MemWrite_1_16(pEm,SS_SEGMENT_ES,pEm->pReg->_DI,pEm->pReg->_AX);
	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_DI -= 2;
	}
	else //DF == 0
	{
		pEm->pReg->_DI += 2;
	}
}

//##############################################  SUB  ##################################################
//SUB AL, imm8		2C
void d_1_16_16_SUB_AL_imm8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_SUB_AL_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	res_u8 = op1_u8-op2_u8;
	pEm->pReg->_AL = res_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_SUB8,0);
}

//SUB AX, imm16		2D		eg. sub ax,0x8002
void d_1_16_16_SUB_AX_imm16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short*)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_SUB_AX_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = pEm->Instr.argu1.u16;
	res_u16 = op1_u16-op2_u16;
	pEm->pReg->_AX = res_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SUB16,0);
}

//SUB r8, r/m8		2A
void d_1_16_16_SUB_r8_rm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_SUB_r8_rm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_r_value_8(pEm);
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	res_u8 = op1_u8-op2_u8;
	SetModrm_r_value_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_SUB8,0);
}

//SUB r16, r/m16	2B		eg. sub dx,[bp+0x6]
void d_1_16_16_SUB_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_SUB_r16_rm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_r_value_16(pEm);
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	res_u16 = op1_u16-op2_u16;
	SetModrm_r_value_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SUB16,0);
}

//SUB r/m8, r8		28
void d_1_16_16_SUB_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_SUB_rm8_r8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = GetModrm_r_value_8(pEm);
	res_u8 = op1_u8-op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_SUB8,0);
}

//SUB r/m16, r16	29
void d_1_16_16_SUB_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_SUB_rm16_r16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = GetModrm_r_value_16(pEm);
	res_u16 = op1_u16-op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SUB16,0);
}

//SUB r/m8, imm8	/5		80
void d_1_16_16_SUB_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SUB_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = pEm->Instr.argu2.u8;	//չ
	res_u8 = op1_u8-op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_SUB8,0);
}

//SUB r/m16,imm16		/5		81
void d_1_16_16_SUB_rm16_imm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SUB_rm16_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.u16;	//չ
	res_u16 = op1_u16-op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SUB16,0);
}

//SUB r/m16, imm8	/5		83
void d_1_16_16_SUB_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SUB_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = (unsigned short)pEm->Instr.argu2.s8;	//չ
	res_u16 = op1_u16-op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SUB16,0);
}

//##############################################  SBB  ##################################################
//SBB r8, r/m8		1A		eg. SBB AL,AL
void d_1_16_16_SBB_r8_rm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_SBB_r8_rm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_r_value_8(pEm);
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u8 = op1_u8-op2_u8-PreCF;
	SetModrm_r_value_8(pEm,res_u8);
	Delay_Get_Flag_With_PreCF_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_SBB8,0,PreCF);
}

//SBB r16, r/m16	1B
void d_1_16_16_SBB_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_SBB_r16_rm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_r_value_16(pEm);
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16-op2_u16-PreCF;
	SetModrm_r_value_16(pEm,res_u16);
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SBB16,0,PreCF);
}

//SBB r/m8, r8		18
void d_1_16_16_SBB_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_SBB_rm8_r8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = GetModrm_r_value_8(pEm);
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u8 = op1_u8-op2_u8-PreCF;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_With_PreCF_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_SBB8,0,PreCF);
}

//SBB r/m16, r16	19
void d_1_16_16_SBB_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_SBB_rm16_r16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = GetModrm_r_value_16(pEm);
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16-op2_u16-PreCF;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SBB16,0,PreCF);
}

//SBB r/m8, imm8		/3		80
void d_1_16_16_SBB_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SBB_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = (unsigned short)(pEm->Instr.argu2.u8);	//չ
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u8 = op1_u8-op2_u8-PreCF;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_With_PreCF_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_SBB8,0,PreCF);
}

//SBB r/m16, imm8		/3		83
void d_1_16_16_SBB_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SBB_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = (unsigned short)(pEm->Instr.argu2.s8);	//չ
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16-op2_u16-PreCF;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SBB16,0,PreCF);
}

//SBB r/m16,imm16		/3		81
void d_1_16_16_SBB_rm16_imm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SBB_rm16_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.u16;
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16-op2_u16-PreCF;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SBB16,0,PreCF);
}

//SBB AL, imm8		1C
void d_1_16_16_SBB_AL_imm8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_SBB_AL_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	unsigned char PreCF;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u8 = op1_u8-op2_u8-PreCF;
	pEm->pReg->_AL = res_u8;
	Delay_Get_Flag_With_PreCF_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_SBB8,0,PreCF);
}

//SBB AX, imm16		1D
void d_1_16_16_SBB_AX_imm16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short*)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_SBB_AX_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = pEm->Instr.argu1.u16;
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16-op2_u16-PreCF;
	pEm->pReg->_AX = res_u16;
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SBB16,0,PreCF);
}

//##############################################  SHL  ##################################################
//SHL r/m8, 1	/4		D0		eg. shl ah,1
void d_1_16_16_SHL_rm8_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHL_rm8_1(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	count = 1;
	res_u8 = (op1_u8 << count);
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,count,res_u8,FLAG_CN_SHL8,0);
}

//SHL r/m16,1	/4		D1		eg. shl ax,1
void d_1_16_16_SHL_rm16_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHL_rm16_1(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	count = 1;
	res_u16 = (op1_u16 << count);
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,count,res_u16,FLAG_CN_SHL16,0);
}

//SHL r/m8, CL	/4	D2		eg. shl al,cl
void d_1_16_16_SHL_rm8_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}
void e_1_16_16_SHL_rm8_CL(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;

	count = pEm->pReg->_CL;
	count &= 0x1F;

	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 << count);
#if CPU_TYPE == 0	//8086/8088 λʱmod 32
		if(pEm->pReg->_CL > 0x1F)
			res_u8 = 0;
#endif
		SetModrm_rm_value_1_8(pEm,res_u8);
		Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,count,res_u8,FLAG_CN_SHL8,0);
	}
}

//SHL r/m8, imm8	/4 /6		C0
void d_1_16_16_SHL_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHL_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;

	count = pEm->Instr.argu2.u8;
	count &= 0x1F;

	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 << count);
#if CPU_TYPE == 0	//8086/8088 λʱmod 32
		if(pEm->pReg->_CL > 0x1F)
			res_u8 = 0;
#endif
		SetModrm_rm_value_1_8(pEm,res_u8);
		Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,count,res_u8,FLAG_CN_SHL8,0);
	}
}

//SHL r/m16, CL		/4		D3		eg. shl ax,cl
void d_1_16_16_SHL_rm16_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHL_rm16_CL(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;

	count = pEm->pReg->_CL;
	count &= 0x1F;

	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		res_u16 = (op1_u16 << count);
#if CPU_TYPE == 0	//8086/8088 λʱmod 32
		if(pEm->pReg->_CL > 0x1F)
			res_u16 = 0;
#endif
		SetModrm_rm_value_1_16(pEm,res_u16);
		Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,count,res_u16,FLAG_CN_SHL16,0);
	}
}

//SHL r/m16, imm8	/4	/6		C1
void d_1_16_16_SHL_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHL_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;

	count = pEm->Instr.argu2.u8;
	count &= 0x1F;

	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		res_u16 = (op1_u16 << count);
#if CPU_TYPE == 0	//8086/8088 λʱmod 32
		if(pEm->pReg->_CL > 0x1F)
			res_u16 = 0;
#endif
		SetModrm_rm_value_1_16(pEm,res_u16);
		Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,count,res_u16,FLAG_CN_SHL16,0);
	}
}

//##############################################  SHR  ##################################################
//SHR r/m8, CL		/5		D2
void d_1_16_16_SHR_rm8_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHR_rm8_CL(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;

	count = pEm->pReg->_CL;
	count &= 0x1F;

	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 >> count);
#if CPU_TYPE == 0	//8086/8088 λʱmod 32
		if(pEm->pReg->_CL > 0x1F)
			res_u8 = 0;
#endif
		SetModrm_rm_value_1_8(pEm,res_u8);
		Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,count,res_u8,FLAG_CN_SHR8,0);
	}
}

//SHR r/m8, imm8	/5		C0
void d_1_16_16_SHR_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHR_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	count = pEm->Instr.argu2.u8;
	count &= 0x1F;
	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 >> count);
#if CPU_TYPE == 0	//8086/8088 λʱmod 32
		if(pEm->pReg->_CL > 0x1F)
			res_u8 = 0;
#endif
		SetModrm_rm_value_1_8(pEm,res_u8);
		Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,count,res_u8,FLAG_CN_SHR8,0);
	}
}

//SHR r/m16, CL		/5		D3		eg. shr ax,cl
void d_1_16_16_SHR_rm16_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHR_rm16_CL(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;

	count = pEm->pReg->_CL;
	count &= 0x1F;

	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);

		res_u16 = (op1_u16 >> count);
#if CPU_TYPE == 0	//8086/8088 λʱmod 32
		if(pEm->pReg->_CL > 0x1F)
			res_u16 = 0;
#endif
		SetModrm_rm_value_1_16(pEm,res_u16);
		Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,count,res_u16,FLAG_CN_SHR16,0);
	}
}

//SHR r/m16, imm8	/5		C1
void d_1_16_16_SHR_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHR_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;

	count = pEm->Instr.argu2.u8;
	count &= 0x1F;

	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);

		res_u16 = (op1_u16 >> count);
#if CPU_TYPE == 0	//8086/8088 λʱmod 32
		if(pEm->pReg->_CL > 0x1F)
			res_u16 = 0;
#endif
		SetModrm_rm_value_1_16(pEm,res_u16);
		Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,count,res_u16,FLAG_CN_SHR16,0);
	}
}

//SHR r/m8,1	/5		D0
void d_1_16_16_SHR_rm8_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHR_rm8_1(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	count = 1;
	res_u8 = (op1_u8 >> count);
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,count,res_u8,FLAG_CN_SHR8,0);
}

//SHR r/m16, 1	/5	D1		eg. shr ax,1
void d_1_16_16_SHR_rm16_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SHR_rm16_1(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	count = 1;
	res_u16 = (op1_u16 >> count);
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,count,res_u16,FLAG_CN_SHR16,0);
}

//##############################################  SAR  ##################################################
//SAR r/m8, 1	/7		D0
void d_1_16_16_SAR_rm8_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SAR_rm8_1(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	count = 1;
	if(op1_u8 & 0x80){
		res_u8 = (op1_u8 >> count) | (0xFF << (8 - count));
	}
	else{
		res_u8 = (op1_u8 >> count);
	}
	SetModrm_rm_value_1_8(pEm,res_u8);
	
	//޸ı־
	FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,op1_u8 &0x01);
	FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u8 == 0x00);
	FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u8 >> 0x07);
	FlagsSet_OF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
	FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u8);
}

//SAR r/m16,1		/7		D1
void d_1_16_16_SAR_rm16_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SAR_rm16_1(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	count = 1;
	if(op1_u16 & 0x8000){
		res_u16 = (op1_u16 >> count) | (0xFFFF << (16 - count));
	}
	else{
		res_u16 = (op1_u16 >> count);
	}

	SetModrm_rm_value_1_16(pEm,res_u16);
	
	//޸ı־
	FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,op1_u16 & 0x01);
	FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u16 == 0x00);
	FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u16 >> 15);
	FlagsSet_OF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
	FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(unsigned char)res_u16);
}

//SAR r/m8, imm8	/7		C0
void d_1_16_16_SAR_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SAR_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	count = pEm->Instr.argu2.u8 & 0x1F;
	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		if(count < 8){
			if(op1_u8 & 0x80){
				res_u8 = (op1_u8 >> count) | (0xFF << (8 - count));
			}
			else{
				res_u8 = (op1_u8 >> count);
			}
		}
		else{
			if(op1_u8 & 0x80){
				res_u8 = 0xFF;
			}
			else{
				res_u8 = 0x00;
			}
		}

		SetModrm_rm_value_1_8(pEm,res_u8);

		//޸ı־
		if(count < 8){
			FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(op1_u8 >> (count - 1)) & 0x01);
		}
		else{
			if(op1_u8 & 0x80){
				FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
			}
			else{
				FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
			}
		}
		FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u8 == 0x00);
		FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u8 >> 7);
		if(count == 1)
			FlagsSet_OF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
		FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(unsigned char)res_u8);
	}
}

//SAR r/m8, CL		/7		D2
void d_1_16_16_SAR_rm8_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SAR_rm8_CL(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	count = pEm->pReg->_CL & 0x1F;
	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		if(count < 8){
			if(op1_u8 & 0x80){
				res_u8 = (op1_u8 >> count) | (0xFF << (8 - count));
			}
			else{
				res_u8 = (op1_u8 >> count);
			}
		}
		else{
			if(op1_u8 & 0x80){
				res_u8 = 0xFF;
			}
			else{
				res_u8 = 0x00;
			}
		}

		SetModrm_rm_value_1_8(pEm,res_u8);

		//޸ı־
		if(count < 8){
			FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(op1_u8 >> (count - 1)) & 0x01);
		}
		else{
			if(op1_u8 & 0x80){
				FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
			}
			else{
				FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
			}
		}
		FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u8 == 0x00);
		FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u8 >> 7);
		if(count == 1)
			FlagsSet_OF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
		FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(unsigned char)res_u8);
	}
}

//SAR r/m16, CL		/7		D3
void d_1_16_16_SAR_rm16_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SAR_rm16_CL(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	count = pEm->pReg->_CL & 0x1F;
	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		if(count < 16){
			if(op1_u16 & 0x8000){
				res_u16 = (op1_u16 >> count) | (0xFFFF << (16 - count));
			}
			else{
				res_u16 = (op1_u16 >> count);
			}
		}
		else{
			if(op1_u16 & 0x8000){
				res_u16 = 0xFFFF;
			}
			else{
				res_u16 = 0x0;
			}
		}

		SetModrm_rm_value_1_16(pEm,res_u16);

		//޸ı־
		if(count < 16){
			FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(op1_u16 >> (count - 1)) & 0x01);
		}
		else{
			if(op1_u16 & 0x8000){
				FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
			}
			else{
				FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
			}
		}
		FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u16 == 0x00);
		FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u16 >> 15);
		if(count == 1)
			FlagsSet_OF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
		FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(unsigned char)res_u16);
	}
}

//SAR r/m16, imm8	/7		C1
void d_1_16_16_SAR_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_SAR_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	count = pEm->Instr.argu2.u8 & 0x1F;
	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		if(count < 16){
			if(op1_u16 & 0x8000){
				res_u16 = (op1_u16 >> count) | (0xFFFF << (16 - count));
			}
			else{
				res_u16 = (op1_u16 >> count);
			}
		}
		else{
			if(op1_u16 & 0x8000){
				res_u16 = 0xFFFF;
			}
			else{
				res_u16 = 0x0;
			}
		}

		SetModrm_rm_value_1_16(pEm,res_u16);

		//޸ı־
		if(count < 16){
			FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(op1_u16 >> (count - 1)) & 0x01);
		}
		else{
			if(op1_u16 & 0x8000){
				FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
			}
			else{
				FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
			}
		}
		FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u16 == 0x00);
		FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,res_u16 >> 15);
		if(count == 1)
			FlagsSet_OF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
		FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(unsigned char)res_u16);
	}
}

//##############################################  SCASB  ##################################################
//SCASB		AE
void d_1_16_16_SCASB(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_SCASB(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = MemRead_1_8(pEm,SS_SEGMENT_ES,pEm->pReg->_DI);
	res_u8 = op1_u8-op2_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_SCAS8,0);
	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_DI --;
	}
	else //DF == 0
	{
		pEm->pReg->_DI ++;
	}
}

//SCASW		AF
void d_1_16_16_SCASW(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_SCASW(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = MemRead_1_16(pEm,SS_SEGMENT_ES,pEm->pReg->_DI);
	res_u16 = op1_u16-op2_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_SCAS16,0);
	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_DI -= 2;
	}
	else //DF == 0
	{
		pEm->pReg->_DI += 2;
	}
}
//##############################################  STC  ##################################################
//STC		F9
void d_1_16_16_STC(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_STC(tpEmulator pEm){
	FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
}

//##############################################  STI  ##################################################
//STI	FB
void d_1_16_16_STI(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_STI(tpEmulator pEm){
	FlagsSet_IF(&pEm->pReg->_EFLAGS);
}

//##############################################  STI  ##################################################
//STD	FD
void d_1_16_16_STD(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_STD(tpEmulator pEm){
	FlagsSet_DF(&pEm->pReg->_EFLAGS);
}

//##############################################  STI  ##################################################
//SAHF		9E
void d_1_16_16_SAHF(tpEmulator pEm){//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_SAHF(tpEmulator pEm){
	unsigned char ah;
	ah = pEm->pReg->_AH;
	FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,G8BIT_7(ah));
	FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,G8BIT_6(ah));
	FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,G8BIT_4(ah));
	FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,G8BIT_2(ah));
	FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,G8BIT_0(ah));
}

//##############################################  SALC  ##################################################
//SALC		D6
void d_1_16_16_SALC(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_SALC(tpEmulator pEm){
	if(FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS))){
		pEm->pReg->_AL = 0xFF;
	}
	else{
		pEm->pReg->_AL = 0x00;
	}
}