#include "general.h"
#include "VMM/Emulator/A2ZH/R__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//##############################################  ROR  ##################################################

//ROR r/m8, 1	/1		D0
void d_1_16_16_ROR_rm8_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROR_rm8_1(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op2_u8 = 1;
	if(op2_u8){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 >> op2_u8) | (op1_u8 << (8-op2_u8));
		SetModrm_rm_value_1_8(pEm,res_u8);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u8 >> 7);
		if(op2_u8 == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u8 ^ res_u8) & 0x80) > 0));
	}
}

//ROR r/m16, 1		/1		D1
void d_1_16_16_ROR_rm16_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROR_rm16_1(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	op2_u16 = 1;
	if(op2_u16){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		res_u16 = (op1_u16 >> op2_u16) | (op1_u16 << (16-op2_u16));
		SetModrm_rm_value_1_16(pEm,res_u16);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u16 >> 15);
		if(op2_u16 == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u16 ^ res_u16) & 0x8000) > 0));
	}
}

//ROR r/m8, imm8	/1		C0		eg. ror ah,0x2
void d_1_16_16_ROR_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}
void e_1_16_16_ROR_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op2_u8 = pEm->Instr.argu2.u8 & 0x07;
	if(op2_u8){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 >> op2_u8) | (op1_u8 << (8-op2_u8));
		SetModrm_rm_value_1_8(pEm,res_u8);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u8 >> 7);
		if(op2_u8 == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u8 ^ res_u8) & 0x80) > 0));
	}
}

//ROR r/m8, CL		/1		D2		eg. ror al,cl
void d_1_16_16_ROR_rm8_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROR_rm8_CL(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	count = pEm->pReg->_CL & 0x07;
	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 >> count) | (op1_u8 << (8-count));
		SetModrm_rm_value_1_8(pEm,res_u8);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u8 >> 7);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u8 ^ res_u8) & 0x80) > 0));
	}
}

//ROR r/m16, CL		/1		D3
void d_1_16_16_ROR_rm16_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROR_rm16_CL(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	count = pEm->pReg->_CL & 0x0F;
	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		res_u16 = (op1_u16 >> count) | (op1_u16 << (16-count));
		SetModrm_rm_value_1_16(pEm,res_u16);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u16 >> 15);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u16 ^ res_u16) & 0x8000) > 0));
	}
}

//ROR r/m16, imm8	/1		C1
void d_1_16_16_ROR_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROR_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	count = pEm->Instr.argu2.u8 & 0x0F;
	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		res_u16 = (op1_u16 >> count) | (op1_u16 << (16-count));
		SetModrm_rm_value_1_16(pEm,res_u16);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u16 >> 15);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u16 ^ res_u16) & 0x8000) > 0));
	}
}
//##############################################  ROL  ##################################################

//ROL r/m16, CL		/0		D3		eg. rol ax,cl
void d_1_16_16_ROL_rm16_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROL_rm16_CL(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	count = pEm->pReg->_CL & 0x0F;
	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		res_u16 = (op1_u16 << count) | (op1_u16 >> (16-count));
		SetModrm_rm_value_1_16(pEm,res_u16);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u16 & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u16 ^ res_u16) & 0x8000) > 0));
	}
}

//ROL r/m16, imm8	/0		C1
void d_1_16_16_ROL_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROL_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	count = pEm->Instr.argu2.u8 & 0x0F;
	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		res_u16 = (op1_u16 << count) | (op1_u16 >> (16 - count));
		SetModrm_rm_value_1_16(pEm,res_u16);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u16 & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u16 ^ res_u16) & 0x8000) > 0));
	}
}

//ROL r/m8, imm8	/0		C0
void d_1_16_16_ROL_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROL_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	count = pEm->Instr.argu2.u8;
	count &= 0x07;
	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 << count) | (op1_u8 >> (8-count));
		SetModrm_rm_value_1_8(pEm,res_u8);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u8 & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u8 ^ res_u8) & 0x80) > 0));
	}
}

//ROL r/m8, 1		0		D0
void d_1_16_16_ROL_rm8_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROL_rm8_1(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	count = 1;
	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 << count) | (op1_u8 >> (8-count));
		SetModrm_rm_value_1_8(pEm,res_u8);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u8 & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u8 ^ res_u8) & 0x80) > 0));
	}
}

//ROL r/m16, 1		/0		D1
void d_1_16_16_ROL_rm16_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROL_rm16_1(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	count = 1;
	if(count){
		FatchRM_1_16(pEm);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		res_u16 = (op1_u16 << count) | (op1_u16 >> (16-count));
		SetModrm_rm_value_1_16(pEm,res_u16);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u16 & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u16 ^ res_u16) & 0x8000) > 0));
	}
}

//ROL r/m8, CL		/0		D2
void d_1_16_16_ROL_rm8_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ROL_rm8_CL(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	count = pEm->pReg->_CL;
	count &= 0x07;
	if(count){
		FatchRM_1_16(pEm);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 << count) | (op1_u8 >> (8-count));
		SetModrm_rm_value_1_8(pEm,res_u8);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),res_u8 & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(((op1_u8 ^ res_u8) & 0x80) > 0));
	}
}

//##############################################  RCL  ##################################################
//RCL r/m16, 1		/2		D1
void d_1_16_16_RCL_rm16_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCL_rm16_1(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	bool b_cf;

	count = 1;
	FatchRM_1_16(pEm);
	b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	res_u16 = (op1_u16 << 1) | b_cf;

	SetModrm_rm_value_1_16(pEm,res_u16);

	FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u16 >> (16 - count)) & 0x01);
	FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u16 ^ res_u16) & 0x8000) > 0);
}

//RCL r/m16, imm8	/2		C1
void d_1_16_16_RCL_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCL_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	bool b_cf;

	count = pEm->Instr.argu2.u8;
	count &= 0x1F;
	count %= 17;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		if(count == 1){
			res_u16 = (op1_u16 << 1) | b_cf;
		}
		else if(count == 16){
			res_u16 = (b_cf << 15) | (op1_u16 >> 1);
		}
		else{
			res_u16 = (op1_u16 << count) | (b_cf << (count - 1)) | (op1_u16 >> (17 - count));
		}

		SetModrm_rm_value_1_16(pEm,res_u16);

		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u16 >> (16 - count)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u16 ^ res_u16) & 0x8000) > 0);
	}
}

//RCL r/m16, CL		/2		D3
void d_1_16_16_RCL_rm16_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCL_rm16_CL(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	bool b_cf;

	count = pEm->pReg->_CL;
	count &= 0x1F;
	count %= 17;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u16 = GetModrm_rm_value_1_16(pEm);
		if(count == 1){
			res_u16 = (op1_u16 << 1) | b_cf;
		}
		else if(count == 16){
			res_u16 = (b_cf << 15) | (op1_u16 >> 1);
		}
		else{
			res_u16 = (op1_u16 << count) | (b_cf << (count - 1)) | (op1_u16 >> (17 - count));
		}

		SetModrm_rm_value_1_16(pEm,res_u16);

		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u16 >> (16 - count)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u16 ^ res_u16) & 0x8000) > 0);
	}
}

//RCL r/m8, imm8	/2		C0
void d_1_16_16_RCL_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCL_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	bool b_cf;

	count = pEm->Instr.argu2.u8;
	count = (count & 0x1F) % 9;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 << count) | (b_cf << (count - 1)) | (op1_u8 >> (9 - count));

		SetModrm_rm_value_1_8(pEm,res_u8);

		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u8 >> (8 - count)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u8 ^ res_u8) & 0x80) > 0);
	}
}

//RCL r/m8, CL		/2		D2
void d_1_16_16_RCL_rm8_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCL_rm8_CL(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	bool b_cf;

	count = pEm->pReg->_CL;
	count = (count & 0x1F) % 9;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 << count) | (b_cf << (count - 1)) | (op1_u8 >> (9 - count));

		SetModrm_rm_value_1_8(pEm,res_u8);

		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u8 >> (8 - count)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u8 ^ res_u8) & 0x80) > 0);
	}
}

//RCL r/m8, 1		/2		D0
void d_1_16_16_RCL_rm8_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCL_rm8_1(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	bool b_cf;

	count = 1;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 << count) | (b_cf << (count - 1)) | (op1_u8 >> (9 - count));

		SetModrm_rm_value_1_8(pEm,res_u8);

		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u8 >> (8 - count)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u8 ^ res_u8) & 0x80) > 0);
	}
}

//##############################################  RCR  ##################################################
//RCR r/m16, 1		/3		D1
void d_1_16_16_RCR_rm16_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCR_rm16_1(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	bool b_cf;

	FatchRM_1_16(pEm);
	b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	count = 1;
	res_u16 = (op1_u16 >> count) | (b_cf << (16 - count)) | (op1_u16 << (17 - count));
	SetModrm_rm_value_1_16(pEm,res_u16);
	FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u16 >> (count - 1)) & 0x01);
	FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u16 ^ res_u16) & 0x8000) > 0);
}

//RCR r/m16, imm8	/3		C1
void d_1_16_16_RCR_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCR_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	bool b_cf;

	count = pEm->Instr.argu2.u8;
	count = (count & 0x1F) % 17;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u16 = GetModrm_rm_value_1_16(pEm);

		res_u16 = (op1_u16 >> count) | (b_cf << (16 - count)) | (op1_u16 << (17 - count));

		SetModrm_rm_value_1_16(pEm,res_u16);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u16 >> (count - 1)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u16 ^ res_u16) & 0x8000) > 0);
	}
}

//RCR r/m16, CL		/3		D3
void d_1_16_16_RCR_rm16_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCR_rm16_CL(tpEmulator pEm){
	unsigned short op1_u16,count,res_u16;
	bool b_cf;

	count = pEm->pReg->_CL;
	count = (count & 0x1F) % 17;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u16 = GetModrm_rm_value_1_16(pEm);

		res_u16 = (op1_u16 >> count) | (b_cf << (16 - count)) | (op1_u16 << (17 - count));

		SetModrm_rm_value_1_16(pEm,res_u16);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u16 >> (count - 1)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u16 ^ res_u16) & 0x8000) > 0);
	}
}

//RCR r/m8, imm8	/3		C0
void d_1_16_16_RCR_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCR_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	bool b_cf;

	count = pEm->Instr.argu2.u8;
	count = (count & 0x1F) % 9;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 >> count) | (b_cf << (8 - count)) | (op1_u8 << (9 - count));
		SetModrm_rm_value_1_8(pEm,res_u8);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u8 >> (count - 1)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u8 ^ res_u8) & 0x80) > 0);
	}
}

//RCR r/m8, CL		/3		D2
void d_1_16_16_RCR_rm8_CL(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCR_rm8_CL(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	bool b_cf;

	count = pEm->pReg->_CL;
	count = (count & 0x1F) % 9;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 >> count) | (b_cf << (8 - count)) | (op1_u8 << (9 - count));
		SetModrm_rm_value_1_8(pEm,res_u8);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u8 >> (count - 1)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u8 ^ res_u8) & 0x80) > 0);
	}
}

//RCR r/m8, 1		/3		D0
void d_1_16_16_RCR_rm8_1(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_RCR_rm8_1(tpEmulator pEm){
	unsigned char op1_u8,count,res_u8;
	bool b_cf;

	count = 1;

	if(count){
		FatchRM_1_16(pEm);
		b_cf = FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		op1_u8 = GetModrm_rm_value_1_8(pEm);
		res_u8 = (op1_u8 >> count) | (b_cf << (8 - count)) | (op1_u8 << (9 - count));
		SetModrm_rm_value_1_8(pEm,res_u8);
		FlagsSet_CF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),(op1_u8 >> (count - 1)) & 0x01);
		if(count == 1)
			FlagsSet_OF(&(pEm->pReg->_EFLAGS),&(pEm->FlagsAbout),((op1_u8 ^ res_u8) & 0x80) > 0);
	}
}

//##############################################  RET  ##################################################	
//RET	C3
void d_1_16_16_RET(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 0;		//תתЧ
	//pEm->pCIS			ʱȷ
}

void e_1_16_16_RET(tpEmulator pEm){
	unsigned short target_ip;
	target_ip = PopFromStack_1_16(pEm);
	pEm->pReg->_IP = target_ip;
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+target_ip;
}

//RET		CB
void d_1_16_16_RETF(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 0;		//תתЧ
	//pEm->pCIS			ʱȷ
}

void e_1_16_16_RETF(tpEmulator pEm){
	unsigned short target_ip,target_cs;
	target_ip = PopFromStack_1_16(pEm);
	target_cs = PopFromStack_1_16(pEm);
	pEm->pReg->_IP = target_ip;
	pEm->pReg->xCS.v = target_cs;
	pEm->pReg->xCS.h.Base = target_cs * 16;
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+target_ip;
}


//RET imm16		CA
void d_1_16_16_RETF_imm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 0;		//תתЧ
}

void e_1_16_16_RETF_imm16(tpEmulator pEm){
	unsigned short target_ip,target_cs;
	target_ip = PopFromStack_1_16(pEm);
	target_cs = PopFromStack_1_16(pEm);
	pEm->pReg->_SP += pEm->Instr.argu1.u16;
	pEm->pReg->_IP = target_ip;
	pEm->pReg->xCS.v = target_cs;
	pEm->pReg->xCS.h.Base = target_cs * 16;
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+target_ip;
}

//RET imm16		C2
void d_1_16_16_RET_imm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 0;		//תתЧ
}

void e_1_16_16_RET_imm16(tpEmulator pEm){
	pEm->pReg->_IP = PopFromStack_1_16(pEm);
	pEm->pReg->_SP += pEm->Instr.argu1.u16;
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
}