#include "general.h"
#include "VMM/Emulator/A2ZH/O__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//##############################################  or  ##################################################
//OR AL, imm8		0C		or al,0x30
void d_1_16_16_OR_AL_imm8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_OR_AL_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	res_u8 = op1_u8 | op2_u8;
	pEm->pReg->_AL = res_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_OR8,0);
}

//OR AX, imm16		0D
void d_1_16_16_OR_AX_imm16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_OR_AX_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = pEm->Instr.argu1.u16;
	res_u16 = op1_u16 | op2_u16;
	pEm->pReg->_AX = res_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_OR16,0);
}

//OR r8, r/m8		0A
void d_1_16_16_OR_r8_rm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_OR_r8_rm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_r_value_8(pEm);
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	res_u8 = op1_u8 | op2_u8;
	SetModrm_r_value_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_OR8,0);
}

//OR r16, r/m16		0B
void d_1_16_16_OR_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_OR_r16_rm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_r_value_16(pEm);
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	res_u16 = op1_u16 | op2_u16;
	SetModrm_r_value_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_OR16,0);
}

//OR r/m8, r8		08		eg. or [0x11],al
void d_1_16_16_OR_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_OR_rm8_r8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = GetModrm_r_value_8(pEm);
	res_u8 = op1_u8 | op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_OR8,0);
}

//OR r/m16, r16		09
void d_1_16_16_OR_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_OR_rm16_r16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = GetModrm_r_value_16(pEm);
	res_u16 = op1_u16 | op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_OR16,0);
}

//OR r/m8, imm8		/1		80		eg. or byte [0x3e],0x80
void d_1_16_16_OR_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_OR_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = pEm->Instr.argu2.u8;
	res_u8 = op1_u8 | op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_OR8,0);
}

//OR r/m16, imm8	/1		83
void d_1_16_16_OR_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_OR_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.s8;
	res_u16 = op1_u16 | op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_OR16,0);
}

//OR r/m16, imm16	/1		81
void d_1_16_16_OR_rm16_imm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_OR_rm16_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.u16;
	res_u16 = op1_u16 | op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_OR16,0);
}

//##############################################  OUT  ##################################################
//OUT imm8, AL		E6		eg. out 0xd,al
void d_1_16_16_OUT_imm8_AL(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(unsigned char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}
void e_1_16_16_OUT_imm8_AL(tpEmulator pEm){
	unsigned char port_id;
	unsigned char handler_id;
	port_id = pEm->Instr.argu1.u8;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];
	pEm->pCVC->VM.Device.IO_Handler[handler_id].write(pEm->pCVC,port_id,pEm->pReg->_AL,1);
}

//OUT imm8, AX		E7
void d_1_16_16_OUT_imm8_AX(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(unsigned char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_OUT_imm8_AX(tpEmulator pEm){
	unsigned char port_id;
	unsigned char handler_id;
	port_id = pEm->Instr.argu1.u8;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];
	pEm->pCVC->VM.Device.IO_Handler[handler_id].write(pEm->pCVC,port_id,pEm->pReg->_AX,2);
}

//OUT DX, AL	EE		eg. out dx,al
void d_1_16_16_OUT_DX_AL(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS += 1;
}
void e_1_16_16_OUT_DX_AL(tpEmulator pEm){
	unsigned short port_id;
	unsigned char handler_id;
	port_id = pEm->pReg->_DX;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];
	pEm->pCVC->VM.Device.IO_Handler[handler_id].write(pEm->pCVC,port_id,pEm->pReg->_AL,1);
}

//OUT DX, AX	EF
void d_1_16_16_OUT_DX_AX(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS += 1;
}

void e_1_16_16_OUT_DX_AX(tpEmulator pEm){
	unsigned short port_id;
	unsigned char handler_id;
	port_id = pEm->pReg->_DX;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];
	pEm->pCVC->VM.Device.IO_Handler[handler_id].write(pEm->pCVC,port_id,pEm->pReg->_AX,2);
}

//##############################################  out  ##################################################
//OUTSB		6E
void d_1_16_16_OUTSB(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;

	//The DS segment may be overridden with a segment override prefix.
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_OUTSB(tpEmulator pEm){
	unsigned short port_id;
	unsigned char handler_id;
	port_id = pEm->pReg->_DX;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];

	pEm->pCVC->VM.Device.IO_Handler[handler_id].write(
		pEm->pCVC,
		port_id,
		MemRead_1_8(pEm,pEm->Instr.sreg,pEm->pReg->_SI),
		1);

	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_SI--;
	}
	else{	//DF == 0
		pEm->pReg->_SI++;
	}
}

//OUTSW		6F
void d_1_16_16_OUTSW(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;

	//The DS segment may be overridden with a segment override prefix.
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_OUTSW(tpEmulator pEm){
	unsigned short port_id;
	unsigned char handler_id;
	port_id = pEm->pReg->_DX;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];

	pEm->pCVC->VM.Device.IO_Handler[handler_id].write(
		pEm->pCVC,
		port_id,
		MemRead_1_16(pEm,pEm->Instr.sreg,pEm->pReg->_SI),
		2);

	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_SI -= 2;
	}
	else{	//DF == 0
		pEm->pReg->_SI += 2;
	}
}