#include "general.h"
#include "VMM/Emulator/A2ZH/N__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//############################################## NOP  ##################################################
//NOP	90
void d_1_16_16_NOP(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_NOP(tpEmulator pEm){
	//պ
}

//##############################################  NOT  ##################################################
//NOT r/m8		/2		F6		eg. not al
void d_1_16_16_NOT_rm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_NOT_rm8(tpEmulator pEm){
	FatchRM_1_16(pEm);
	SetModrm_rm_value_1_8(pEm,~GetModrm_rm_value_1_8(pEm));
	//NOT Ӱ־λ
}

//NOT r/m16		/2		F7		eg. not ax
void d_1_16_16_NOT_rm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_NOT_rm16(tpEmulator pEm){
	FatchRM_1_16(pEm);
	SetModrm_rm_value_1_16(pEm,~GetModrm_rm_value_1_16(pEm));
	//NOT Ӱ־λ
}

//##############################################  NEG  ##################################################
//NEG r/m8		/3		F6
void d_1_16_16_NEG_rm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_NEG_rm8(tpEmulator pEm){
	unsigned char op1_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	res_u8 = 0 - op1_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,0,res_u8,FLAG_CN_NEG8,0);
}

//NEG r/m16		/3		F7
void d_1_16_16_NEG_rm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_NEG_rm16(tpEmulator pEm){
	unsigned short op1_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	res_u16 = 0 - op1_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,0,res_u16,FLAG_CN_NEG16,0);
}