#include "general.h"
#include "VMM/Emulator/A2ZH/M__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//##############################################  MOV  ##################################################

//MOV Sreg,r/m16	8E			eg.	mov ss,cx
void d_1_16_16_MOV_Sreg_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_MOV_Sreg_rm16(tpEmulator pEm){

#ifdef SS_RUN_STRICT
	//ܲCSָ
	if(pEm->Instr.r == SS_SEGMENT_CS){
		InvalidOpcode_1(pEm);
	}
#endif
	FatchRM_1_16(pEm);
	SetModrm_sreg_value_16(pEm,GetModrm_rm_value_1_16(pEm));
}

//MOV r/m16,Sreg		8C		eg. mov ax,ss
void d_1_16_16_MOV_rm16_Sreg(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_MOV_rm16_Sreg(tpEmulator pEm){
	FatchRM_1_16(pEm);
	SetModrm_rm_value_1_16(pEm,GetModrm_sreg_value_16(pEm));
}
//MOV r8, imm8		B0 B1 B2 B3 B4 B5 B6 B7				eg.	mov cl,0xb
void d_1_16_16_MOV_r8_imm8(tpEmulator pEm){	//B0+ rb   len:2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.r = *pEm->pCIS-0xB0;
	pEm->Instr.argu1.u8 = *(unsigned char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}
void e_1_16_16_MOV_r8_imm8(tpEmulator pEm){
	SetModrm_r_value_8(pEm,pEm->Instr.argu1.u8);
}

//MOV r16, imm16	B8 B9 BA BB BC BD BE BF				eg.	mov sp,0x7bfc
void d_1_16_16_MOV_r16_imm16(tpEmulator pEm){	//B8 + rw  len:3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.r = *pEm->pCIS-0xB8;
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_MOV_r16_imm16(tpEmulator pEm){
	SetModrm_r_value_16(pEm,pEm->Instr.argu1.u16);
}
//MOV r/m8, imm8	C6
void d_1_16_16_MOV_rm8_imm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	//pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.u8 = *(unsigned char *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len++;	//1 Byte imm
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_MOV_rm8_imm8(tpEmulator pEm){
	FatchRM_1_16(pEm);
	SetModrm_rm_value_1_8(pEm,pEm->Instr.argu2.u8);
}

//MOV r/m16, imm16		/0		C7		eg. mov word [0x40e],0x9fc0
void d_1_16_16_MOV_rm16_imm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	//pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.u16 = *(unsigned short *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len += 2;	//2 Byte imm
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_MOV_rm16_imm16(tpEmulator pEm){
	FatchRM_1_16(pEm);
	SetModrm_rm_value_1_16(pEm,pEm->Instr.argu2.u16);
}

//MOV r/m8,r8		88		eg. mov bl,al
void d_1_16_16_MOV_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_MOV_rm8_r8(tpEmulator pEm){
	FatchRM_1_16(pEm);
	SetModrm_rm_value_1_8(pEm,GetModrm_r_value_8(pEm));
}
//MOV r/m16,r16		89		eg.	mov [bp+0x0],di
void d_1_16_16_MOV_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_MOV_rm16_r16(tpEmulator pEm){
	FatchRM_1_16(pEm);
	SetModrm_rm_value_1_16(pEm,GetModrm_r_value_16(pEm));
}

//MOV r8,r/m8		8A		eg. mov al,[bp+0x10]
void d_1_16_16_MOV_r8_rm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_MOV_r8_rm8(tpEmulator pEm){
	FatchRM_1_16(pEm);
	SetModrm_r_value_8(pEm,GetModrm_rm_value_1_8(pEm));
}

//MOV r16,r/m16		8B		eg. mov si,[bp+0x11]
void d_1_16_16_MOV_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_MOV_r16_rm16(tpEmulator pEm){
	FatchRM_1_16(pEm);
	SetModrm_r_value_16(pEm,GetModrm_rm_value_1_16(pEm));
}

//MOV moffs8,AL		A2		eg. mov [0x526],al
void d_1_16_16_MOV_moffs8_AL(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_MOV_moffs8_AL(tpEmulator pEm){
	MemWrite_1_8(pEm,pEm->Instr.sreg,pEm->Instr.argu1.u16,pEm->pReg->_AL);
}

//MOV moffs16,AX		A3		eg. mov [0x5c],ax
void d_1_16_16_MOV_moffs16_AX(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_MOV_moffs16_AX(tpEmulator pEm){
	MemWrite_1_16(pEm,pEm->Instr.sreg,pEm->Instr.argu1.u16,pEm->pReg->_AX);
}

//MOV AL,moffs8		A0		eg. mov al,[0x10]
void d_1_16_16_MOV_AL_moffs8(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}
void e_1_16_16_MOV_AL_moffs8(tpEmulator pEm){
	pEm->pReg->_AL = MemRead_1_8(pEm,pEm->Instr.sreg,pEm->Instr.argu1.u16);
}

//MOV AX,moffs16	A1	eg. mov ax,[0x60]
void d_1_16_16_MOV_AX_moffs16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_MOV_AX_moffs16(tpEmulator pEm){
	pEm->pReg->_AX = MemRead_1_16(pEm,pEm->Instr.sreg,pEm->Instr.argu1.u16);
}

//##############################################  MOVS  ##################################################
//MOVSB	A4
void d_1_16_16_MOVSB(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
	pEm->Instr.len = 1;
	pEm->pCIS++;
}
void e_1_16_16_MOVSB(tpEmulator pEm){
	unsigned short si,di;
	si = pEm->pReg->_SI;
	di = pEm->pReg->_DI;
	MemWrite_1_8(pEm,SS_SEGMENT_ES,di,MemRead_1_8(pEm,pEm->Instr.sreg,si));	//DS:(E)SI to ES:(E)DI.
	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		si--;
		di--;
	}
	else{	//DF == 0
		si++;
		di++;
	}
	pEm->pReg->_SI = si;
	pEm->pReg->_DI = di;
}

//MOVS m16, m16		A5
void d_1_16_16_MOVS_m16_m16(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_MOVS_m16_m16(tpEmulator pEm){
	unsigned short si,di;
	si = pEm->pReg->_SI;
	di = pEm->pReg->_DI;
	MemWrite_1_16(pEm,SS_SEGMENT_ES,di,MemRead_1_16(pEm,pEm->Instr.sreg,si));	//DS:(E)SI to ES:(E)DI.
	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		si -= 2;
		di -= 2;
	}
	else{	//DF == 0
		si += 2;
		di += 2;
	}
	pEm->pReg->_SI = si;
	pEm->pReg->_DI = di;
}
//##############################################  MUL  ##################################################
//MUL r/m8	/4	F6		eg. mul byte [0x4a]
void d_1_16_16_MUL_rm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}
void e_1_16_16_MUL_rm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8;
	unsigned short res_u16;
	bool flag;
	FatchRM_1_16(pEm);
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	res_u16 = op1_u8 * op2_u8;
	pEm->pReg->_AX = res_u16;
	flag = ((res_u16 & 0xFF00) != 0);
	FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,flag,flag);
}

//MUL r/m16		/4	F7		eg. mul word [bp+0x16]
void d_1_16_16_MUL_rm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_MUL_rm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16;
	unsigned int res_u32;
	bool flag;
	FatchRM_1_16(pEm);
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	res_u32 = ((unsigned int)op1_u16) * ((unsigned int)op2_u16);
	pEm->pReg->_AX = (unsigned short)res_u32;			//Ͱ벿
	pEm->pReg->_DX = *((unsigned short *)(&res_u32)+1);	//߰벿
	flag = (pEm->pReg->_DX != 0);
	FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,flag,flag);
}