#include "general.h"
#include "VMM/Emulator/A2ZH/L__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//##############################################  LDS  ##################################################
//LDS	LDS r16,m16:16		C5		eg.  lds si,[bp+0x0]
void d_1_16_16_LDS_r16_m1616(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_LDS_r16_m1616(tpEmulator pEm){
	if(pEm->Instr.mod == 3)
		InvalidOpcode_1(pEm);
	FatchRM_1_16(pEm);
	SetModrm_r_value_16(pEm,MemRead_1_16(pEm , pEm->Instr.sreg , pEm->Instr._Rmv.u16));
	pEm->ModrmA.sreg_16[SS_SEGMENT_DS]->v = MemRead_1_16(pEm , pEm->Instr.sreg , pEm->Instr._Rmv.u16+2);
	pEm->ModrmA.sreg_16[SS_SEGMENT_DS]->h.Base = pEm->ModrmA.sreg_16[SS_SEGMENT_DS]->v * 16;
}

//##############################################  LES  ##################################################
//LES r16,m16:16	C4
void d_1_16_16_LES_r16_m1616(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_LES_r16_m1616(tpEmulator pEm){
	if(pEm->Instr.mod == 3)
		InvalidOpcode_1(pEm);
	FatchRM_1_16(pEm);
	SetModrm_r_value_16(pEm,MemRead_1_16(pEm , pEm->Instr.sreg , pEm->Instr._Rmv.u16));
	pEm->ModrmA.sreg_16[SS_SEGMENT_ES]->v = MemRead_1_16(pEm , pEm->Instr.sreg , pEm->Instr._Rmv.u16+2);
	pEm->ModrmA.sreg_16[SS_SEGMENT_ES]->h.Base = pEm->ModrmA.sreg_16[SS_SEGMENT_ES]->v * 16;
}
//##############################################  LEA  ##################################################
//LEA r16,m		8D		eg. lea bx,[bp+0x6]
void d_1_16_16_LEA_r16_m(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_LEA_r16_m(tpEmulator pEm){
	if(pEm->Instr.mod == 3)
	{
		InvalidOpcode_1(pEm);
		return;
	}
	FatchRM_1_16(pEm);
	SetModrm_r_value_16(pEm,pEm->Instr._Rmv.u16);
}

//##############################################  LOOP  ##################################################
//LOOP rel8		E2		eg. loop 0xfff8
void d_1_16_16_LOOP_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_LOOP_rel8(tpEmulator pEm){
	unsigned short count;
	count = pEm->pReg->_CX;
	count--;
	pEm->pReg->_CX = count;
	if(count != 0){		//jump short if count  0.
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  LOOPNE  ##################################################
//LOOPNE rel8		E0
void d_1_16_16_LOOPNE_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_LOOPNE_rel8(tpEmulator pEm){
	unsigned short count;
	count = pEm->pReg->_CX;
	count--;
	pEm->pReg->_CX = count;
	if(count != 0 && (FlagsGetZFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS) == FALSE)){	//jump short if count  0 and ZF = 0.
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  LOOPE  ##################################################
//LOOPE rel8		E1
void d_1_16_16_LOOPE_rel8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_LOOPE_rel8(tpEmulator pEm){
	unsigned short count;
	count = pEm->pReg->_CX;
	count--;
	pEm->pReg->_CX = count;
	if(count != 0 && (FlagsGetZFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS) == TRUE)){	//jump short if count  0 and ZF = 1.
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  LODSx  ##################################################
//LODSB		AC
void d_1_16_16_LODSB(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_LODSB(tpEmulator pEm){
	pEm->pReg->_AL = MemRead_1_8(pEm,pEm->Instr.sreg,pEm->pReg->_SI);
	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_SI--;
	}
	else{	//DF == 0
		pEm->pReg->_SI++;
	}
}

//LODSW		AD
void d_1_16_16_LODSW(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_LODSW(tpEmulator pEm){
	pEm->pReg->_AX = MemRead_1_16(pEm,pEm->Instr.sreg,pEm->pReg->_SI);
	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_SI -= 2;
	}
	else{	//DF == 0
		pEm->pReg->_SI += 2;
	}
}

//##############################################  LAHF  ##################################################
//LAHF		9F
void d_1_16_16_LAHF(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_LAHF(tpEmulator pEm){
	FlagsGetAllByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
	pEm->pReg->_AH = pEm->pReg->_EFLAGS;
	pEm->pReg->_AH = (pEm->pReg->_AH & 0xD7) | 0x02;
}