#include "general.h"
#include "VMM/Emulator/A2ZH/_Define.h"
#include "VMM/Emulator/A2ZH/J__.h"

//##############################################  JMP  ##################################################
//JMP rel8		EB cb
void d_1_16_16_JMP_rel8(tpEmulator pEm){	//len:2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JMP_rel8(tpEmulator pEm){
	pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8 + pEm->Instr.len;
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
	pEm->Instr.len = 0;	//תתЧ
}

//JMP rel16		E9		eg. jmp word 0xff46
void d_1_16_16_JMP_rel16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s16 = *(signed short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	//pEm->pCIS = pEm->pCIS + pEm->Instr.argu1.s16+3;	pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JMP_rel16(tpEmulator pEm){
	pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s16 + pEm->Instr.len;
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
	pEm->Instr.len = 0;	//תתЧ
}

//JMP ptr16:16	EA		eg. jmp word 0xf000:0xe05b
void d_1_16_16_JMP_ptr16_16(tpEmulator pEm){	//len: 5
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.argu2.u16 = *(unsigned short *)(pEm->pCIS+3);
}
void e_1_16_16_JMP_ptr16_16(tpEmulator pEm){
	pEm->pReg->xCS.v = pEm->Instr.argu2.u16;
	pEm->pReg->xCS.h.Base = pEm->pReg->xCS.v * 0x10;
	pEm->pReg->_IP = pEm->Instr.argu1.u16;
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
	pEm->Instr.len = 0;
}

//JMP r/m16		/4		FF		eg. jmp word near [bx-0xfbb]
void d_1_16_16_JMP_rm16(tpEmulator pEm){	//Jump near, absolute indirect
	//Ӧӱ亯ѽݷ
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}
void e_1_16_16_JMP_rm16(tpEmulator pEm){
	FatchRM_1_16(pEm);
	pEm->pReg->_IP = GetModrm_rm_value_1_16(pEm);
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
	pEm->Instr.len = 0;	//תתЧ
}

//JMP m16:16	/5		FF
void d_1_16_16_JMP_m16_16(tpEmulator pEm){
	//Ӧӱ亯ѽݷ
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_JMP_m16_16(tpEmulator pEm){
	unsigned short _Rmv;
	FatchRM_1_16(pEm);

	if(pEm->Instr.mod == 3)
	{
		InvalidOpcode_1(pEm);
		return;
	}

	//rmλʾƫƵַ
	_Rmv = pEm->Instr._Rmv.u16;

	pEm->pReg->_IP = MemRead_1_16(pEm,pEm->Instr.sreg,_Rmv);
	pEm->pReg->xCS.v = MemRead_1_16(pEm,pEm->Instr.sreg,_Rmv+2);
	pEm->pReg->xCS.h.Base = pEm->pReg->xCS.v * 16;

	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
	pEm->Instr.len = 0;	//תתЧ
}

//##############################################  JZ  ##################################################
//JZ rel8		74		eg. jz 0x37
void d_1_16_16_JZ_rel8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JZ_rel8(tpEmulator pEm){
	if(FlagsGetZFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == TRUE)	//Jump short if zero (ZF=1).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//JZ rel16		0F 84		eg. jz word 0x19b
void d_1_16_16_JZ_rel16(tpEmulator pEm){	//len: 4
	//LinkExeӱн
	pEm->Instr.len = 4;
	pEm->Instr.argu1.s16 = *(signed short*)(pEm->pCIS+2);
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JZ_rel16(tpEmulator pEm){
	if(FlagsGetZFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == TRUE)	//Jump near if 0 (ZF=1).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s16+4;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 4;
	}
}
//##############################################  JNZ  ##################################################
//JNZ rel16		0F 85	eg. 0F856FFE
void d_1_16_16_JNZ_rel16(tpEmulator pEm){	//len: 4
	//LinkExeӱн
	pEm->Instr.len = 4;
	pEm->Instr.argu1.s16 = *(signed short*)(pEm->pCIS+2);
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JNZ_rel16(tpEmulator pEm){
	if(FlagsGetZFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == FALSE)	//Jump near if not zero (ZF=0).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s16+4;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 4;
	}
}

//JNZ rel8		75			eg. jnz 0x34
void d_1_16_16_JNZ_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JNZ_rel8(tpEmulator pEm){
	if(FlagsGetZFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == FALSE)	//Jump short if not zero (ZF=0).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}
//##############################################  JNL  ##################################################
//JNL rel8		7d
void d_1_16_16_JNL_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JNL_rel8(tpEmulator pEm){
	if(FlagsGetSFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == 
		FlagsGetOFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS))
		)	//Jump short if not less (SF=OF).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JC  ##################################################
//JC rel8		72
void d_1_16_16_JC_rel8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JC_rel8(tpEmulator pEm){
	if(FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == TRUE)	//Jump short if carry (CF=1).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JA  ##################################################
//JA rel8		77
void d_1_16_16_JA_rel8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JA_rel8(tpEmulator pEm){
	if((FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == FALSE)
			&&
		(FlagsGetZFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == FALSE)
		)	//Jump short if above (CF=0 and ZF=0).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JO  ##################################################
//JO rel8		70
void d_1_16_16_JO_rel8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}
void e_1_16_16_JO_rel8(tpEmulator pEm){
	if(FlagsGetOFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == TRUE)	//Jump short if overflow(OF=1).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JS  ##################################################
//JS rel8		78
void d_1_16_16_JS_rel8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}
void e_1_16_16_JS_rel8(tpEmulator pEm){
	if(FlagsGetSFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == TRUE)	//Jump short if sign (SF=1).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JPO  ##################################################
//JPO rel8		7B
void d_1_16_16_JPO_rel8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JPO_rel8(tpEmulator pEm){
	if(FlagsGetPFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == FALSE)	//Jump short if parity odd(PF=0).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JPE  ##################################################
//JPE rel8		7A
void d_1_16_16_JPE_rel8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JPE_rel8(tpEmulator pEm){
	if(FlagsGetPFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == TRUE)	//Jump short if parity even(PF=1).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JNO  ##################################################
//JNO rel8		71
void d_1_16_16_JNO_rel8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JNO_rel8(tpEmulator pEm){
	if(FlagsGetOFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == FALSE)	//Jump short if not overflow(OF=0).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JNC  ##################################################
//JNC rel8		73
void d_1_16_16_JNC_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JNC_rel8(tpEmulator pEm){
	if(FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == FALSE)	//Jump short if not carry(CF=0).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JCXZ  ##################################################
//JCXZ rel8		E3
void d_1_16_16_JCXZ_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JCXZ_rel8(tpEmulator pEm){
	if(pEm->pReg->_CX == 0)	//Jump short if CX register is 0.
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JNA  ##################################################
//JNA rel8	76
void d_1_16_16_JNA_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}
void e_1_16_16_JNA_rel8(tpEmulator pEm){
	if((FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == TRUE)
			||
		(FlagsGetZFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == TRUE)
		)	//Jump short if not above(CF=1 or ZF=1).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

////##############################################  JL  ##################################################
//JL rel8		7C
void d_1_16_16_JL_rel8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JL_rel8(tpEmulator pEm){
	if(FlagsGetSFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS))
			!=
		FlagsGetOFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS))
		)	//Jump short if less (SF OF).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JNS  ##################################################
//JNS rel8		79
void d_1_16_16_JNS_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JNS_rel8(tpEmulator pEm){
	if(FlagsGetSFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == FALSE)	//Jump short if not sign(SF=0).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JG  ##################################################
//JG rel8		7F
void d_1_16_16_JG_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JG_rel8(tpEmulator pEm){
	if((FlagsGetZFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == FALSE)
			&&
		(FlagsGetSFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS))
			==
		 FlagsGetOFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS))
		 )
		)	//Jump short if greater (ZF=0 and SF=OF)..
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}

//##############################################  JLE  ##################################################
//JLE rel8		7E
void d_1_16_16_JLE_rel8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s8 = *(signed char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_JLE_rel8(tpEmulator pEm){
	if((FlagsGetZFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS)) == TRUE)
			||
		(FlagsGetSFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS))
			!=
		 FlagsGetOFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS))
		 )
		)	//Jump short if less or equal(ZF=1 or SF OF).
	{
		//֧ת
		pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s8+2;
		pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
		pEm->Instr.len = 0;	//תתЧ
	}
	else
	{
		//δ֧ת
		pEm->pCIS += 2;
	}
}