#include "general.h"
#include "VMM/Emulator/A2ZH/_Define.h"
#include "VMM/Emulator/A2ZH/I__.h"
#include "Function.h"

//##############################################  INC  ##################################################
//INC r/m16		/0		FF
void d_1_16_16_INC_rm16(tpEmulator pEm){
	//Ӧӱ亯ѽݷ
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_INC_rm16(tpEmulator pEm){
	unsigned short value;
	FatchRM_1_16(pEm);
	value = GetModrm_rm_value_1_16(pEm);
	//INCֻӰCFλλǰCFλ
	FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	Delay_Get_Flag_16(&(pEm->FlagsAbout),value,1,value+1,FLAG_CN_ADD16,1);
	SetModrm_rm_value_1_16(pEm,value+1);
}

//INC r/m8		/0		FE
void d_1_16_16_INC_rm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_INC_rm8(tpEmulator pEm){
	unsigned char value;
	FatchRM_1_16(pEm);
	value = GetModrm_rm_value_1_8(pEm);
	//INCֻӰCFλλǰCFλ
	FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	Delay_Get_Flag_8(&(pEm->FlagsAbout),value,1,value+1,FLAG_CN_ADD8,1);
	SetModrm_rm_value_1_8(pEm,value+1);
}

//INC r16	40 41 42 43 44 45 46 47
void d_1_16_16_INC_r16(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.r = *pEm->pCIS-0x40;
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_INC_r16(tpEmulator pEm){
	unsigned short value;
	value = GetModrm_r_value_16(pEm);
	//INCֻӰCFλλǰCFλ
	FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	Delay_Get_Flag_16(&(pEm->FlagsAbout),value,1,value+1,FLAG_CN_ADD16,1);
	SetModrm_r_value_16(pEm,value+1);
}

//##############################################  INT  ##################################################

//INT imm8		CD		eg. 
void d_1_16_16_INT_imm8(tpEmulator pEm){	//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(unsigned char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	//pEm->pCIS += 2;	ʱȷ
}
void e_1_16_16_INT_imm8(tpEmulator pEm){
	pEm->pReg->_IP += pEm->Instr.len;//intָڵһָ	  ǰ׺lenȷ
	ExcepOrInterr_1(pEm,TRUE,pEm->Instr.argu1.u8,FALSE,0);
	pEm->Instr.len = 0;	//תתЧ

}

//INT 1			F1
void d_1_16_16_INT_1(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	//pEm->pCIS += 1;	ʱȷ
}

void e_1_16_16_INT_1(tpEmulator pEm){
	pEm->pReg->_IP += pEm->Instr.len;//intָڵһָ	  ǰ׺lenȷ
	ExcepOrInterr_1(pEm,TRUE,0x1,FALSE,0);
	pEm->Instr.len = 0;	//תתЧ
}

//INT 3		CC
void d_1_16_16_INT_3(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	//pEm->pCIS += 1;	ʱȷ
}

void e_1_16_16_INT_3(tpEmulator pEm){
	pEm->pReg->_IP += pEm->Instr.len;//intָڵһָ	  ǰ׺lenȷ
	ExcepOrInterr_1(pEm,TRUE,0x3,FALSE,0);
	pEm->Instr.len = 0;	//תתЧ
}

//INTO		CE
void d_1_16_16_INTO(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	//pEm->pCIS += 1;	ʱȷ
}

void e_1_16_16_INTO(tpEmulator pEm){
	pEm->pReg->_IP += pEm->Instr.len;//intָڵһָ	  ǰ׺lenȷ
	ExcepOrInterr_1(pEm,TRUE,0x4,FALSE,0);
	pEm->Instr.len = 0;	//תתЧ
}

//##############################################  IN  ##################################################
//IN AL, imm8		E4		eg. in al,0x71
void d_1_16_16_IN_AL_imm8(tpEmulator pEm){		//len: 2 
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(unsigned char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}
void e_1_16_16_IN_AL_imm8(tpEmulator pEm){
	unsigned char port_id;
	unsigned char handler_id;
	port_id = pEm->Instr.argu1.u8;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];
	pEm->pReg->_AL = pEm->pCVC->VM.Device.IO_Handler[handler_id].read(pEm->pCVC,port_id,1);
}

//IN AX, imm8		E5
void d_1_16_16_IN_AX_imm8(tpEmulator pEm){		//len: 2 
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(unsigned char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_IN_AX_imm8(tpEmulator pEm){
	unsigned char port_id;
	unsigned char handler_id;
	port_id = pEm->Instr.argu1.u8;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];
	pEm->pReg->_AX = pEm->pCVC->VM.Device.IO_Handler[handler_id].read(pEm->pCVC,port_id,2);
}


//IN AL,DX		EC		eg. in al,dx
void d_1_16_16_IN_AL_DX(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS += 1;
}

void e_1_16_16_IN_AL_DX(tpEmulator pEm){
	unsigned short port_id;
	unsigned char handler_id;
	port_id = pEm->pReg->_DX;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];
	pEm->pReg->_AL = pEm->pCVC->VM.Device.IO_Handler[handler_id].read(pEm->pCVC,port_id,1);
}

//IN AX,DX		ED
void d_1_16_16_IN_AX_DX(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS += 1;
}

void e_1_16_16_IN_AX_DX(tpEmulator pEm){
	unsigned short port_id;
	unsigned char handler_id;
	port_id = pEm->pReg->_DX;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];
	pEm->pReg->_AX = pEm->pCVC->VM.Device.IO_Handler[handler_id].read(pEm->pCVC,port_id,2);
}

//##############################################  INS  ##################################################
//INS m8, DX	6C
void d_1_16_16_INS_m8_DX(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_INS_m8_DX(tpEmulator pEm){
	unsigned value_u8;
	unsigned short port_id;
	unsigned char handler_id;
	port_id = pEm->pReg->_DX;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];

	//The ES segment cannot be overridden with a segment override prefix.

	//ܵĶҳ
	MemWrite_1_8(pEm,SS_SEGMENT_ES,pEm->pReg->_DI,0);

	value_u8 = (unsigned char)(pEm->pCVC->VM.Device.IO_Handler[handler_id].read(
		pEm->pCVC,
		port_id,
		1));
	MemWrite_1_8(pEm,SS_SEGMENT_ES,pEm->pReg->_DI,value_u8);

	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_DI--;
	}
	else{	//DF == 0
		pEm->pReg->_DI++;
	}
}

//INS m16, DX		6D
void d_1_16_16_INS_m16_DX(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_INS_m16_DX(tpEmulator pEm){
	unsigned value_u16;
	unsigned short port_id;
	unsigned char handler_id;
	port_id = pEm->pReg->_DX;
	handler_id = pEm->pCVC->VM.Device.Port2HandlerId[port_id];

	//The ES segment cannot be overridden with a segment override prefix.

	//ܵĶҳ
	MemWrite_1_16(pEm,SS_SEGMENT_ES,pEm->pReg->_DI,0);

	value_u16 = (unsigned short)(pEm->pCVC->VM.Device.IO_Handler[handler_id].read(
		pEm->pCVC,
		port_id,
		2));
	MemWrite_1_16(pEm,SS_SEGMENT_ES,pEm->pReg->_DI,value_u16);

	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		pEm->pReg->_DI -= 2;
	}
	else{	//DF == 0
		pEm->pReg->_DI += 2;
	}
}
//##############################################  IRET  ##################################################
//IRET		CF
void d_1_16_16_IRET(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	//pEm->Instr.len = 0;
	//pEm->pCIS += 1;	ʱȷ
}

void e_1_16_16_IRET(tpEmulator pEm){
	pEm->Instr.len = 0;	//תתЧ
	pEm->pReg->_IP = PopFromStack_1_16(pEm);
	pEm->pReg->xCS.v = PopFromStack_1_16(pEm);
	pEm->pReg->xCS.h.Base = pEm->pReg->xCS.v * 16;
	*(unsigned short *)(&pEm->pReg->_EFLAGS) = PopFromStack_1_16(pEm);
	pEm->pCIS = (unsigned char *)(pEm->pGPM + pEm->pReg->xCS.h.Base + pEm->pReg->_IP);
}

//##############################################  IMUL  ##################################################
//IMUL r16, r/m16,imm8		6b
void d_1_16_16_IMUL_r16_rm16_imm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.s8 = *(signed char *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len++;
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_IMUL_r16_rm16_imm8(tpEmulator pEm){
	signed short op2_s16,op3_s16;
	signed int res_s32;
	FatchRM_1_16(pEm);
	op2_s16 = (signed short)GetModrm_rm_value_1_16(pEm);
	op3_s16 = pEm->Instr.argu2.s8;
	res_s32 = op2_s16 * op3_s16;
	SetModrm_r_value_16(pEm,(unsigned short)res_s32);
	
	if ((res_s32 > -32768) && (res_s32 < 32767))
		FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0,0);
	else
		FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1,1);
}

//IMUL r16, r/m16,imm16		69
void d_1_16_16_IMUL_r16_rm16_imm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->Instr.argu2.s16 = *(signed short *)(pEm->pCIS-1+pEm->Instr.len);
	pEm->Instr.len += 2;
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_IMUL_r16_rm16_imm16(tpEmulator pEm){
	signed short op2_s16,op3_s16;
	signed int res_s32;
	FatchRM_1_16(pEm);
	op2_s16 = (signed short)GetModrm_rm_value_1_16(pEm);
	op3_s16 = pEm->Instr.argu2.s16;
	res_s32 = op2_s16 * op3_s16;
	SetModrm_r_value_16(pEm,(unsigned short)res_s32);
	
	if ((res_s32 > -32768) && (res_s32 < 32767))
		FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0,0);
	else
		FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1,1);
}

//IMUL r/m8		/5		F6
void d_1_16_16_IMUL_rm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_IMUL_rm8(tpEmulator pEm){
	signed char op1_s8,op2_s8;
	signed short res_s16;
	unsigned short v_u16;

	FatchRM_1_16(pEm);
	op1_s8 = pEm->pReg->_AL;
	op2_s8 = GetModrm_rm_value_1_8(pEm);
	res_s16 = op1_s8 * op2_s8;
	pEm->pReg->_AX = res_s16;

	v_u16 = res_s16 & 0xFF80;
	if(v_u16 == 0xFF80 || v_u16 == 0x0000)
		FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0,0);
	else
		FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1,1);
}

//IMUL r/m16	/5		F7
void d_1_16_16_IMUL_rm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_IMUL_rm16(tpEmulator pEm){
	signed short op1_s16,op2_s16;
	signed int res_s32;
	unsigned short res_s16h,res_s16l;

	FatchRM_1_16(pEm);
	op1_s16 = pEm->pReg->_AX;
	op2_s16 =(signed short)GetModrm_rm_value_1_16(pEm);

	res_s32 = ((signed int)op1_s16) * ((signed int)op2_s16);
	
	res_s16l = res_s32 & 0xFFFF;
	res_s16h = res_s32 >> 16;

	pEm->pReg->_AX = res_s16l;
	pEm->pReg->_DX = res_s16h;
	
	if ((res_s16h == 0xFFFF) && (res_s16l & 0x8000))
		FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0,0);
	else if((res_s16h == 0x0000) && (res_s16l < 0x8000))
		FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0,0);
	else
		FlagsSet_OF_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1,1);
}

//##############################################  IDIV  ##################################################
//IDIV r/m16	/7		F7
void d_1_16_16_IDIV_rm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_IDIV_rm16(tpEmulator pEm){
	signed int op1_s32,Quotient_s32;
	signed short op2_s16,Remainder_s16,Quotient_s16l;
	FatchRM_1_16(pEm);
	op1_s32 = (((unsigned int)(pEm->pReg->_DX)) << 16) | ((unsigned int)(pEm->pReg->_AX));
	op2_s16 = GetModrm_rm_value_1_16(pEm);
	if(op2_s16 == 0)		//0
	{
		Exception_1(FALSE,EOI_DE,0);
		return;
	}
	Quotient_s32 = op1_s32 / op2_s16;
	Remainder_s16 = op1_s32 % op2_s16;
	Quotient_s16l = Quotient_s32 & 0xFFFF;
	
	if(Quotient_s32 != Quotient_s16l)
	{
		Exception_1(FALSE,EOI_DE,0);
		return;
	}
	pEm->pReg->_AX = (unsigned short)Quotient_s32;
	pEm->pReg->_DX = Remainder_s16;
}

//IDIV r/m8		/7		F6
void d_1_16_16_IDIV_rm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_IDIV_rm8(tpEmulator pEm){
	signed char op2_s8,Remainder_s8,Quotient_s8l;
	signed short op1_s16,Quotient_s16;

	FatchRM_1_16(pEm);
	op1_s16 = pEm->pReg->_AX;
	op2_s8 = GetModrm_rm_value_1_8(pEm);

	if(op2_s8 == 0)		//0
	{
		Exception_1(FALSE,EOI_DE,0);
		return;
	}
	Quotient_s16 = op1_s16 / op2_s8;
	Remainder_s8 = op1_s16 % op2_s8;
	Quotient_s8l = Quotient_s16 & 0xFF;
	if(Quotient_s16 != Quotient_s8l)
	{
		Exception_1(FALSE,EOI_DE,0);
		return;
	}
	
	pEm->pReg->_AL = Quotient_s8l;
	pEm->pReg->_AH = Remainder_s8;
}