#include "general.h"
#include "VMM/Emulator/A2ZH/D__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//##############################################  DEC  ##################################################
//DEC r16	48 49 4A 4B 4C 4D 4E 4F
void d_1_16_16_DEC_r16(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.r = *pEm->pCIS-0x48;
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_DEC_r16(tpEmulator pEm){
	unsigned short value;
	value = GetModrm_r_value_16(pEm);
	//DECֻӰCFλλǰCFλ
	FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	Delay_Get_Flag_16(&(pEm->FlagsAbout),value,1,value-1,FLAG_CN_SUB16,1);
	SetModrm_r_value_16(pEm,value-1);
}

//DEC r/m8		/1		FE
void d_1_16_16_DEC_rm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_DEC_rm8(tpEmulator pEm){
	unsigned char value;
	FatchRM_1_16(pEm);
	value = GetModrm_rm_value_1_8(pEm);
	//DECֻӰCFλλǰCFλ
	FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	Delay_Get_Flag_8(&(pEm->FlagsAbout),value,1,value-1,FLAG_CN_SUB8,1);
	SetModrm_rm_value_1_8(pEm,value-1);
}

//DEC r/m16		/1		FF
void d_1_16_16_DEC_rm16(tpEmulator pEm){
	//Ӧӱ亯ѽݷ
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_DEC_rm16(tpEmulator pEm){
	unsigned short value;
	FatchRM_1_16(pEm);
	value = GetModrm_rm_value_1_16(pEm);
	//DECֻӰCFλλǰCFλ
	FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	Delay_Get_Flag_16(&(pEm->FlagsAbout),value,1,value-1,FLAG_CN_SUB16,1);
	SetModrm_rm_value_1_16(pEm,value-1);
}

//##############################################  DIV  ##################################################
//DIV r/m16		/6		F7
void d_1_16_16_DIV_rm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}
void e_1_16_16_DIV_rm16(tpEmulator pEm){
	unsigned int op1_u32,Quotient_u32;
	unsigned short op2_u16,Remainder_u16,Quotient_u16l;
	FatchRM_1_16(pEm);
	op1_u32 = (((unsigned int)(pEm->pReg->_DX)) << 16) | ((unsigned int)(pEm->pReg->_AX));
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	if(op2_u16 == 0)		//0
	{
		Exception_1(FALSE,EOI_DE,0);
		return;
	}
	Quotient_u32 = op1_u32 / op2_u16;
	Remainder_u16 = op1_u32 % op2_u16;
	Quotient_u16l = Quotient_u32 & 0xFFFF;
	if(Quotient_u32 != Quotient_u16l)
	{
		Exception_1(FALSE,EOI_DE,0);
		return;
	}
	pEm->pReg->_AX = (unsigned short)Quotient_u32;
	pEm->pReg->_DX = Remainder_u16;
}

//DIV r/m8		/6		F6
void d_1_16_16_DIV_rm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_DIV_rm8(tpEmulator pEm){
	unsigned short op1_u16,Quotient_u16;
	unsigned char op2_u8,Remainder_u8,Quotient_u8l;
	FatchRM_1_16(pEm);
	op1_u16 = pEm->pReg->_AX;
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	if(op2_u8 == 0)		//0
	{
		Exception_1(FALSE,EOI_DE,0);
		return;
	}
	Quotient_u16 = op1_u16 / op2_u8;
	Remainder_u8 = op1_u16 % op2_u8;
	Quotient_u8l = Quotient_u16 & 0xFF;
	if(Quotient_u16 != Quotient_u8l)	//8λΪ0
	{
		pEm->pReg->_AL = (unsigned char)Quotient_u16;
		pEm->pReg->_AH = Remainder_u8;
		Exception_1(FALSE,EOI_DE,0);
		return;
	}
	pEm->pReg->_AL = (unsigned char)Quotient_u16;
	pEm->pReg->_AH = Remainder_u8;
}

//##############################################  DAA  ##################################################
//DAA		27
void d_1_16_16_DAA(tpEmulator pEm){		//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_DAA(tpEmulator pEm){
	unsigned char al;
	al = pEm->pReg->_AL;

	if (((al & 0x0F) > 0x09) || FlagsGetAFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS)){
		al = al + 0x06;
		FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
	}
	else
		FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);

	if ((al > 0x9F) || FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS)){
		al = al + 0x60;
		FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
	}
	else
		FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);

	pEm->pReg->_AL = al;

	FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,al >> 7);
	FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,al == 0);
	FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,al);
}

//##############################################  DAS  ##################################################
//DAS		2F
void d_1_16_16_DAS(tpEmulator pEm){		//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_DAS(tpEmulator pEm){
	unsigned char al,temp_al,C_cf;

	C_cf = 0;
	al = pEm->pReg->_AL;
	temp_al = pEm->pReg->_AL;

	if (((temp_al & 0x0F) > 0x09) || FlagsGetAFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS)){
		FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
		C_cf = (al < 0x06) || FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS);
		al = al - 0x06;
	}

	if ((temp_al > 0x99) || FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS)){
		al = al - 0x60;
		C_cf = 1;
	}

	pEm->pReg->_AL = al;

	FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,C_cf);
	FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,al >> 7);
	FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,al == 0);
	FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,al);
}