#include "general.h"
#include "VMM/Emulator/A2ZH/C__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//##############################################  CLI  ##################################################
//CLI		FA
void d_1_16_16_CLI(tpEmulator pEm){		//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_CLI(tpEmulator pEm){
	FlagsClearIF(&(pEm->pReg->_EFLAGS));
}

//##############################################  CLD  ##################################################
//CLD	FC
void d_1_16_16_CLD(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_CLD(tpEmulator pEm){
	FlagsClearDF(&(pEm->pReg->_EFLAGS));
}

//##############################################  CLC  ##################################################
//CLC	F8
void d_1_16_16_CLC(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_CLC(tpEmulator pEm){
	FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
}
//##############################################  CMP  ##################################################
//CMP AL, imm8		3C		eg. cmp al,0x0
void d_1_16_16_CMP_AL_imm8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(unsigned char *)(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}
void e_1_16_16_CMP_AL_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	res_u8 = op1_u8-op2_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_CMP8,0);
}

//CMP AX, imm16		3D		cmp ax,0x5555
void d_1_16_16_CMP_AX_imm16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_CMP_AX_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = pEm->Instr.argu1.u16;
	res_u16 = op1_u16-op2_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_CMP16,0);
}
//CMP r/m8, r8	38
void d_1_16_16_CMP_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_CMP_rm8_r8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = GetModrm_r_value_8(pEm);
	res_u8 = op1_u8-op2_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_CMP8,0);
}

//CMP r/m16, r16	39
void d_1_16_16_CMP_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_CMP_rm16_r16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = GetModrm_r_value_16(pEm);
	res_u16 = op1_u16-op2_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_CMP16,0);
}

//CMP r/m8, imm8	/7	80
void d_1_16_16_CMP_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_CMP_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = pEm->Instr.argu2.u8;
	res_u8 = op1_u8-op2_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_CMP8,0);
}

//CMP r/m16,imm16	/7	81		eg. cmp dx,0xf600
void d_1_16_16_CMP_rm16_imm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_CMP_rm16_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.u16;
	res_u16 = op1_u16-op2_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_CMP16,0);
}

//CMP r/m16, imm8	/7		83
void d_1_16_16_CMP_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_CMP_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = (unsigned short)pEm->Instr.argu2.s8;	//չ
	res_u16 = op1_u16-op2_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_CMP16,0);
}

//CMP r8, r/m8		3A		cmp dl,dh
void d_1_16_16_CMP_r8_rm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_CMP_r8_rm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_r_value_8(pEm);
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	res_u8 = op1_u8-op2_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_CMP8,0);
}

//CMP r16, r/m16		3B		eg. cmp dx,[di]
void d_1_16_16_CMP_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m	Ĭõargu1
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}
void e_1_16_16_CMP_r16_rm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_r_value_16(pEm);
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	res_u16 = op1_u16-op2_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_CMP16,0);
}

//##############################################  CBW  ##################################################
//CBW			98
void d_1_16_16_CBW(tpEmulator pEm){		//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_CBW(tpEmulator pEm){
	pEm->pReg->_AX = *(signed char *)(&pEm->pReg->_AL);
}

//##############################################  CALL  ##################################################
//CALL rel16	E8		eg. call word 0x1b3
void d_1_16_16_CALL_rel16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.s16 = *(signed short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_CALL_rel16(tpEmulator pEm){
	Push2Stack_1_16(pEm,pEm->pReg->_IP + pEm->Instr.len);
	pEm->pReg->_IP = pEm->pReg->_IP+pEm->Instr.argu1.s16+pEm->Instr.len;
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
	pEm->Instr.len = 0;	//תתЧ
}

//CALL m16:16	/3		FF
void d_1_16_16_CALL_m16_16(tpEmulator pEm){
	//Ӧӱ亯ѽݷ
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
	
	//sregѾӱ亯л
	//if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
	//	pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_CALL_m16_16(tpEmulator pEm){
	unsigned short _Rmv,ip,cs;
	FatchRM_1_16(pEm);

	if(pEm->Instr.mod == 3)
	{
		InvalidOpcode_1(pEm);
		return;
	}

	//rmλʾƫƵַ
	_Rmv = pEm->Instr._Rmv.u16;
	ip = pEm->pReg->_IP;
	cs = pEm->pReg->xCS.v;

	pEm->pReg->_IP = MemRead_1_16(pEm,pEm->Instr.sreg,_Rmv);		//ȶڴ
	pEm->pReg->xCS.v = MemRead_1_16(pEm,pEm->Instr.sreg,_Rmv+2);
	pEm->pReg->xCS.h.Base = pEm->pReg->xCS.v * 16;

	Push2Stack_1_16(pEm,cs);										//ٽջ
	Push2Stack_1_16(pEm,ip+pEm->Instr.len);

	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
	pEm->Instr.len = 0;	//תתЧ
}

//CALL r/m16	/2		FF
void d_1_16_16_CALL_rm16(tpEmulator pEm){
	//Ӧӱ亯ѽݷ
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
	
	//sregѾӱ亯л
	//if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
	//	pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_CALL_rm16(tpEmulator pEm){
	FatchRM_1_16(pEm);
	Push2Stack_1_16(pEm,pEm->pReg->_IP+pEm->Instr.len);
	pEm->pReg->_IP = GetModrm_rm_value_1_16(pEm);
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
	pEm->Instr.len = 0;	//תתЧ
}

//CALL ptr16:16		9A
void d_1_16_16_CALL_ptr16_16(tpEmulator pEm){	//len: 5
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.argu2.u16 = *(unsigned short *)(pEm->pCIS+3);
	pEm->Instr.len = 5;
	//pEm->pCSI ʱ(Ժӿָ)ֻʱȷ
}

void e_1_16_16_CALL_ptr16_16(tpEmulator pEm){
	Push2Stack_1_16(pEm,pEm->pReg->xCS.v);
	Push2Stack_1_16(pEm,pEm->pReg->_IP + pEm->Instr.len);	//ǰ׺lenֵȷ
	pEm->pReg->xCS.v = pEm->Instr.argu2.u16;
	pEm->pReg->xCS.h.Base = pEm->pReg->xCS.v * 0x10;
	pEm->pReg->_IP = pEm->Instr.argu1.u16;
	pEm->pCIS = (unsigned char *)pEm->pGPM+pEm->pReg->xCS.h.Base+pEm->pReg->_IP;
	pEm->Instr.len = 0;
}

//##############################################  CMC  ##################################################
//CMC	F5
void d_1_16_16_CMC(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_CMC(tpEmulator pEm){
	FlagsSet_CF(&pEm->pReg->_EFLAGS,
		&pEm->FlagsAbout,
		!FlagsGetCFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS));
}

//##############################################  CMPS  ##################################################
//CMPS m8, m8	A6
void d_1_16_16_CMPS_m8_m8(tpEmulator pEm){	//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_CMPS_m8_m8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	unsigned short si,di;
	si = pEm->pReg->_SI;
	di = pEm->pReg->_DI;

	op1_u8 = MemRead_1_8(pEm,pEm->Instr.sreg,si);
	op2_u8 = MemRead_1_8(pEm,SS_SEGMENT_ES,di);

	res_u8 = op1_u8 - op2_u8;

	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_CMPS8,0);

	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		si--;
		di--;
	}
	else{	//DF == 0
		si++;
		di++;
	}
	pEm->pReg->_SI = si;
	pEm->pReg->_DI = di;
}

//CMPS m16, m16		A7
void d_1_16_16_CMPS_m16_m16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
		pEm->Instr.sreg = SS_SEGMENT_DS;
}

void e_1_16_16_CMPS_m16_m16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned short si,di;
	si = pEm->pReg->_SI;
	di = pEm->pReg->_DI;

	op1_u16 = MemRead_1_16(pEm,pEm->Instr.sreg,si);
	op2_u16 = MemRead_1_16(pEm,SS_SEGMENT_ES,di);

	res_u16 = op1_u16 - op2_u16;

	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_CMPS16,0);

	if(FlagsGetDF(&(pEm->pReg->_EFLAGS))){	//DF == 1
		si -= 2;
		di -= 2;
	}
	else{	//DF == 0
		si += 2;
		di += 2;
	}
	pEm->pReg->_SI = si;
	pEm->pReg->_DI = di;
}

//##############################################  CWD  ##################################################
//CWD		99
void d_1_16_16_CWD(tpEmulator pEm){		//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_CWD(tpEmulator pEm){
	if(pEm->pReg->_AX & 0x8000)
	{
		pEm->pReg->_DX = 0xFFFF;
	}
	else
	{
		pEm->pReg->_DX = 0x0000;
	}
}
