#include "general.h"
#include "VMM/Emulator/A2ZH/A__.h"
#include "VMM/Emulator/A2ZH/_Define.h"

//##############################################  ADD  ##################################################
//ADD AL, imm8		04			eg. add al,0xc3
void d_1_16_16_ADD_AL_imm8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_ADD_AL_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	res_u8 = op1_u8+op2_u8;
	pEm->pReg->_AL = res_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_ADD8,0);
}

//ADD AX, imm16		05		eg. add ax,0x1
void d_1_16_16_ADD_AX_imm16(tpEmulator pEm){		//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short*)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_ADD_AX_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = pEm->Instr.argu1.u16;
	res_u16 = op1_u16+op2_u16;
	pEm->pReg->_AX = res_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADD16,0);
}

//ADD r8, r/m8		02		eg. add ah,[bp+di+0x413]
void d_1_16_16_ADD_r8_rm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_ADD_r8_rm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_r_value_8(pEm);
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	res_u8 = op1_u8+op2_u8;
	SetModrm_r_value_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_ADD8,0);
}

//ADD r16, r/m16		03		eg. add ax,[bp+0x1c]
void d_1_16_16_ADD_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_ADD_r16_rm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_r_value_16(pEm);
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	res_u16 = op1_u16+op2_u16;
	SetModrm_r_value_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADD16,0);
}

//ADD r/m8, r8	00
void d_1_16_16_ADD_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_ADD_rm8_r8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = GetModrm_r_value_8(pEm);
	res_u8 = op1_u8+op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_ADD8,0);
}

//ADD r/m16, r16		01		eg. add [bp-0x4],ax
void d_1_16_16_ADD_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_ADD_rm16_r16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = GetModrm_r_value_16(pEm);
	res_u16 = op1_u16+op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADD16,0);
}

//ADD r/m8, imm8		/0			80
void d_1_16_16_ADD_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ADD_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = pEm->Instr.argu2.u8;
	res_u8 = op1_u8+op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_ADD8,0);
}

//ADD r/m16, imm8	/0	83
void d_1_16_16_ADD_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}
void e_1_16_16_ADD_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = (unsigned short)pEm->Instr.argu2.s8;	//չ
	res_u16 = op1_u16+op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADD16,0);
}

//ADD r/m16,imm16	/0	81		eg. add dx,0x80
void d_1_16_16_ADD_rm16_imm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ADD_rm16_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.u16;	//չ
	res_u16 = op1_u16+op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADD16,0);
}
//##############################################  ADC  ##################################################
//ADC r8, r/m8		12
void d_1_16_16_ADC_r8_rm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_ADC_r8_rm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_r_value_8(pEm);
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u8 = op1_u8+op2_u8+PreCF;
	SetModrm_r_value_8(pEm,res_u8);
	Delay_Get_Flag_With_PreCF_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_ADC8,0,PreCF);
}

//ADC r16, r/m16	13		eg. adc dx,[bp+0x1e]
void d_1_16_16_ADC_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_ADC_r16_rm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_r_value_16(pEm);
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16+op2_u16+PreCF;
	SetModrm_r_value_16(pEm,res_u16);
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADC16,0,PreCF);
}

//ADC r/m8, r8		10
void d_1_16_16_ADC_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_ADC_rm8_r8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = GetModrm_r_value_8(pEm);
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u8 = op1_u8+op2_u8+PreCF;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_With_PreCF_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_ADC8,0,PreCF);
}

//ADC r/m16, r16	11		eg. adc [bp-0x2],cx
void d_1_16_16_ADC_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_ADC_rm16_r16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = GetModrm_r_value_16(pEm);
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16+op2_u16+PreCF;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADC16,0,PreCF);
}

//ADC r/m8, imm8	/2		80	eg. adc ch,0x0
void d_1_16_16_ADC_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ADC_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = pEm->Instr.argu2.u8;
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u8 = op1_u8+op2_u8+PreCF;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_With_PreCF_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_ADC8,0,PreCF);
}

//ADC r/m16, imm8		/2		83
void d_1_16_16_ADC_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ADC_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.s8;		//չ
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16+op2_u16+PreCF;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADC16,0,PreCF);
}

//ADC r/m16,imm16		/2		81
void d_1_16_16_ADC_rm16_imm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_ADC_rm16_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.u16;
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16+op2_u16+PreCF;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADC16,0,PreCF);
}

//ADC AL, imm8		14
void d_1_16_16_ADC_AL_imm8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_ADC_AL_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	unsigned char PreCF;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u8 = op1_u8 + op2_u8+PreCF;
	pEm->pReg->_AL = res_u8;
	Delay_Get_Flag_With_PreCF_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_ADC8,0,PreCF);
}

//ADC AX, imm16	15
void d_1_16_16_ADC_AX_imm16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short*)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_ADC_AX_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	unsigned char PreCF;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = pEm->Instr.argu1.u16;
	PreCF = FlagsGetCFByFlagAb(&(pEm->FlagsAbout),&(pEm->pReg->_EFLAGS));
	res_u16 = op1_u16 + op2_u16+PreCF;
	pEm->pReg->_AX = res_u16;
	Delay_Get_Flag_With_PreCF_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_ADC16,0,PreCF);
}

//##############################################  AND  ##################################################
//AND AL, imm8	24		eg. and al,0x7
void d_1_16_16_AND_AL_imm8(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len = 2;
	pEm->pCIS += 2;
}

void e_1_16_16_AND_AL_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	op1_u8 = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	res_u8 = op1_u8 & op2_u8;
	pEm->pReg->_AL = res_u8;
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_AND8,0);
}

//AND AX, imm16		25
void d_1_16_16_AND_AX_imm16(tpEmulator pEm){	//len: 3
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u16 = *(unsigned short *)(pEm->pCIS+1);
	pEm->Instr.len = 3;
	pEm->pCIS += 3;
}

void e_1_16_16_AND_AX_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	op1_u16 = pEm->pReg->_AX;
	op2_u16 = pEm->Instr.argu1.u16;
	res_u16 = op1_u16 & op2_u16;
	pEm->pReg->_AX = res_u16;
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_AND16,0);
}

//AND r/m8, imm8	/4	80		eg. and bl,0x30
void d_1_16_16_AND_rm8_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_AND_rm8_imm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = pEm->Instr.argu2.u8;
	res_u8 = op1_u8 & op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_AND8,0);
}

//AND r/m16, imm8		/4		83
void d_1_16_16_AND_rm16_imm8(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_AND_rm16_imm8(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = (unsigned short)pEm->Instr.argu2.s8;	//չ
	res_u16 = op1_u16 & op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_AND16,0);
}

//AND r/m16,imm16	/4		81
void d_1_16_16_AND_rm16_imm16(tpEmulator pEm){
	//Ӧӱ亯ѽȫ
}

void e_1_16_16_AND_rm16_imm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = pEm->Instr.argu2.u16;
	res_u16 = op1_u16 & op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_AND16,0);
}

//AND r/m8, r8		20
void d_1_16_16_AND_rm8_r8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_AND_rm8_r8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_rm_value_1_8(pEm);
	op2_u8 = GetModrm_r_value_8(pEm);
	res_u8 = op1_u8 & op2_u8;
	SetModrm_rm_value_1_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_AND8,0);
}

//AND r/m16, r16	21
void d_1_16_16_AND_rm16_r16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_AND_rm16_r16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_rm_value_1_16(pEm);
	op2_u16 = GetModrm_r_value_16(pEm);
	res_u16 = op1_u16 & op2_u16;
	SetModrm_rm_value_1_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_AND16,0);
}

//AND r8, r/m8		22
void d_1_16_16_AND_r8_rm8(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_AND_r8_rm8(tpEmulator pEm){
	unsigned char op1_u8,op2_u8,res_u8;
	FatchRM_1_16(pEm);
	op1_u8 = GetModrm_r_value_8(pEm);
	op2_u8 = GetModrm_rm_value_1_8(pEm);
	res_u8 = op1_u8 & op2_u8;
	SetModrm_r_value_8(pEm,res_u8);
	Delay_Get_Flag_8(&(pEm->FlagsAbout),op1_u8,op2_u8,res_u8,FLAG_CN_AND8,0);
}

//AND r16, r/m16	23
void d_1_16_16_AND_r16_rm16(tpEmulator pEm){
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
	pEm->Instr.mod = (*pEm->pCIS)>>6;
	pEm->Instr.rm = (*pEm->pCIS)&7;
	pEm->Instr.r = (*pEm->pCIS>>3)&7;
	PreFatchRM_1_16(pEm);		//r/m
	pEm->pCIS = pEm->pCIS-1+pEm->Instr.len;
}

void e_1_16_16_AND_r16_rm16(tpEmulator pEm){
	unsigned short op1_u16,op2_u16,res_u16;
	FatchRM_1_16(pEm);
	op1_u16 = GetModrm_r_value_16(pEm);
	op2_u16 = GetModrm_rm_value_1_16(pEm);
	res_u16 = op1_u16 & op2_u16;
	SetModrm_r_value_16(pEm,res_u16);
	Delay_Get_Flag_16(&(pEm->FlagsAbout),op1_u16,op2_u16,res_u16,FLAG_CN_AND16,0);
}

//##############################################  AAM  ##################################################
//AAM	D4
void d_1_16_16_AAM(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len += 2;
	pEm->pCIS += 2;
}

void e_1_16_16_AAM(tpEmulator pEm){
	unsigned char al,op2_u8;
	al = pEm->pReg->_AL;
	op2_u8 = pEm->Instr.argu1.u8;
	if(op2_u8 == 0)
	{
		Exception_1(FALSE,EOI_DE,0);
		return;
	}
	pEm->pReg->_AH = al / op2_u8;
	pEm->pReg->_AL = al % op2_u8;

	FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
	FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
	FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(pEm->pReg->_AL & 0x80) > 0);
	FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,pEm->pReg->_AL == 0);
	FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,pEm->pReg->_AL);
}

//##############################################  AAA  ##################################################
//AAA		37
void d_1_16_16_AAA(tpEmulator pEm){		//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_AAA(tpEmulator pEm){
	unsigned char al,ah,alcarry;
	al = pEm->pReg->_AL;
	ah = pEm->pReg->_AH;
	alcarry = al > 0xF9;

	if(((al & 0x0F) > 9) || FlagsGetAFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS)){
		al = (al + 6) & 0x0F;
		ah = ah + 1 + alcarry;
		FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
		FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
	}
	else{
		FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
		FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
		al = al & 0x0F;
	}
	pEm->pReg->_AL = al;
	pEm->pReg->_AH = ah;
}

//##############################################  AAS  ##################################################
//AAS		3F
void d_1_16_16_AAS(tpEmulator pEm){		//len: 1
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.len = 1;
	pEm->pCIS++;
}

void e_1_16_16_AAS(tpEmulator pEm){
	unsigned char al,ah,alborrow;
	al = pEm->pReg->_AL;
	ah = pEm->pReg->_AH;
	alborrow = al < 6;

	if(((al & 0x0F) > 9) || FlagsGetAFByFlagAb(&pEm->FlagsAbout,&pEm->pReg->_EFLAGS)){
		al = (al - 6) & 0x0F;
		ah = ah - 1 - alborrow;
		FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
		FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,1);
	}
	else{
		FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
		FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,0);
		al = al & 0x0F;
	}
	pEm->pReg->_AL = al;
	pEm->pReg->_AH = ah;
}

//##############################################  AAD  ##################################################
//
void d_1_16_16_AAD(tpEmulator pEm){		//len: 2
	LinkExeFunToInstr_1_16_16(pEm);
	pEm->Instr.argu1.u8 = *(pEm->pCIS+1);
	pEm->Instr.len += 2;
	pEm->pCIS += 2;
}

void e_1_16_16_AAD(tpEmulator pEm){
	unsigned char al;
	unsigned short ax1,ax2;
	
	ax1 = pEm->pReg->_AH * pEm->Instr.argu1.u8;
	ax2 = ax1 + pEm->pReg->_AL;
	al = pEm->pReg->_AL;
	pEm->pReg->_AL = (unsigned char)ax2;
	pEm->pReg->_AH = 0;

	FlagsSet_AF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(ax1 & 0x08) != (ax2 & 0x08));
	FlagsSet_CF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,ax2 > 0xFF);
	FlagsSet_OF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,(pEm->pReg->_AL & 0x80) != (al & 0x80));
	FlagsSet_SF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,pEm->pReg->_AL >= 0x80);
	FlagsSet_ZF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,pEm->pReg->_AL == 0);
	FlagsSet_PF(&pEm->pReg->_EFLAGS,&pEm->FlagsAbout,pEm->pReg->_AL);
}