#include "general.h"
#include "VMM/EMR0.h"
#include "VMM/CVCR0.h"
#include "VMM/Emulator/Emulator.h"
#include "Function.h"
#include "VMM/Emulator/ExcepOrInterr.h"
#include "VMM/Emulator/EmuData.h"
#include "VMM/Emulator/CodeName.h"

#ifndef __E
#	define __E(__a)	&(pThread->Events[__a])
#endif

#ifndef __S
#	define __S(__a)	&(pThread->SpinLocks[__a])
#endif

static void EmThread(PVOID pThreadAug);

typedef struct tThreadAug{
	tpCVC pCVC;
	int ThreadID;
	int *pEInum;
}tThreadAug, *tpThreadAug;

EXERESULT EMR0Create(tpEM pEM){
	EXERESULT rt = SS_SUCCESS;
	int count,ThreadID;
	tThreadAug TAug;
	count = pEM->CpuCount;
	KdPrint(("EMR0Create\n"));

	for(ThreadID = 0;count<=MAX_LOGIC_CPU_COUNT&&ThreadID<count;ThreadID++)
		pEM->EmuAsynEvent[ThreadID] = EM_ASYN_EVENT_NONE;

	for(ThreadID = 0;count<=MAX_LOGIC_CPU_COUNT&&ThreadID<count;ThreadID++)
	{
		pEM->ET[ThreadID].ThreadEntry = EmThread;
		TAug.pCVC = (tpCVC)(pEM->pCVC);
		TAug.ThreadID = ThreadID;
		TAug.pEInum = &(pEM->EInum[ThreadID]);
		rt = ThrR0Create(&pEM->ET[ThreadID],&TAug);
		if(rt != SS_SUCCESS)		//һֹReleaseȫִ
			break;
	}
	return rt;
}

/*
 * ʼУֱн;ǿн
 */
EXERESULT EMR0Start(tpCVC pCVC){
	EXERESULT rt = SS_SUCCESS;
	int count,ThreadID;
	tpThread pThread;

	KdPrint(("EMR0Start\n"));
	count = pCVC->VM.Cpu.count;
	for(ThreadID = 0;count<=MAX_LOGIC_CPU_COUNT&&ThreadID<count;ThreadID++)
	{
#ifdef SS_DEBUG
		KeInitializeEvent(&pCVC->VMM.EM.ehGetOneDbgCmd[ThreadID],SynchronizationEvent, FALSE);
#endif
		pThread = &(pCVC->VMM.EM.ET[ThreadID]);
		if(pThread->pThrObj != NULL && !IS_TERMINATED_STATE(pThread->ThrState))
		{
			if(pThread->ThrState == THREAD_IS_BLOCKING)
			{
				EmR0OffSuspendThread(pThread);
				KdPrint(("߳ %d Կʼ\n",ThreadID));
			}
		}
	}
	return rt;
}
EXERESULT EMR0Release(tpEM pEM){
	EXERESULT rt = SS_SUCCESS;
	int count,ThreadID;
	tpThread pThread;

	KdPrint(("EMR0Release\n"));
	count = pEM->CpuCount;
	for(ThreadID = 0;count<=MAX_LOGIC_CPU_COUNT&&ThreadID<count;ThreadID++)
	{
#ifdef SS_DEBUG
		KeSetEvent(&pEM->ehGetOneDbgCmd[ThreadID],IO_NO_INCREMENT,FALSE);
#endif
		pThread = &(pEM->ET[ThreadID]);

		// "ֹ" 첽¼
		pEM->EmuAsynEvent[ThreadID] = EM_ASYN_EVENT_HALT_NORMAL;
		//ֹ߳
		ThrR0Term(pThread);
	}
	return rt;
}

EXERESULT EmR0SuspendThread(tpEM pEM,int ThreadID){
	EXERESULT rt = SS_SUCCESS;
	KIRQL OldIrql;
	tpThread pThread = &pEM->ET[ThreadID];
#ifdef SS_DEBUG
	//Ƚָĵع
	KeSetEvent(&pEM->ehGetOneDbgCmd[ThreadID],IO_NO_INCREMENT,FALSE);
#endif
	if(pThread->pThrObj != NULL && !IS_TERMINATED_STATE(pThread->ThrState)){
		if(KeGetCurrentIrql() <= DISPATCH_LEVEL){
			KeAcquireSpinLock(__S(THREAD_SUSPEND_SPIN_LOCK),&OldIrql);
			// "" 첽¼
			pEM->EmuAsynEvent[ThreadID] = EM_ASYN_EVENT_SUSPEND;
			pThread->ToBeSuspended = TRUE;
			KeWaitForSingleObject(__E(THREAD_EVENTS_SUSPEND), Executive, KernelMode, FALSE, NULL);
			KeReleaseSpinLock(__S(THREAD_SUSPEND_SPIN_LOCK),OldIrql);
			KdPrint(("̹߳ɹ\n"));
		}
		else{
			rt = SS_IRQ_LEVEL_ERR;
			KdPrint(("IRQ ERR in EmR0SuspendThread\n"));
		}
	}
	return rt;
}

EXERESULT EmR0OffSuspendThread(tpThread pThread){
	EXERESULT rt = SS_SUCCESS;
	KIRQL OldIrql;
	if(pThread->pThrObj != NULL && !IS_TERMINATED_STATE(pThread->ThrState)){
		if(KeGetCurrentIrql() <= DISPATCH_LEVEL){
			KeAcquireSpinLock(__S(THREAD_SUSPEND_SPIN_LOCK),&OldIrql);
			pThread->ToBeSuspended = FALSE;
			ThrR0OffSuspend(pThread);
			KeReleaseSpinLock(__S(THREAD_SUSPEND_SPIN_LOCK),OldIrql);
			KdPrint(("߳̽ɹ\n"));
		}
		else{
			rt = SS_IRQ_LEVEL_ERR;
			KdPrint(("IRQ ERR in EmR0OffSuspendThread\n"));
		}
	}
	return rt;
}

static void EmThread(PVOID pThreadAug){
	EXERESULT rt = SS_SUCCESS;

	tpCVC pCVC;
	int * pEInum;
	tpThread pThread;
	tpEM pEM;
	int ThreadID;
	tpEmulator pEmulator;
	int * pEmAsynEvent;
	unsigned __int64 * pCurTime;

	//>
	int delay;
	bool *pBC;
	unsigned __int64 *pCur_IC;
	unsigned __int64 *pIC;
	bool HasIntBef;
	unsigned short CS_ret;
	unsigned short IP_ret;
	unsigned short PreSI;
	//<

	pCVC = ((tpThreadAug)pThreadAug)->pCVC;
	pEInum = ((tpThreadAug)pThreadAug)->pEInum;
	*pEInum = EOI_NONE;
	ThreadID = ((tpThreadAug)pThreadAug)->ThreadID;
	pThread = &(pCVC->VMM.EM.ET[ThreadID]);
	pThread->ThrState = THREAD_IS_RUNNING;
	pEM = &pCVC->VMM.EM;
	pEmAsynEvent = &pCVC->VMM.EM.EmuAsynEvent[ThreadID];
	pCurTime = &pCVC->VMM.EM.CurrentTime[ThreadID];

	*pCurTime = 0;

	//ģ߳άһģбָҪһЩݡ
	rt = EmulatorCreate(&pEmulator);						//ͷڵǰеEmulatorRelease
	if(rt != SS_SUCCESS)
	{
		KeSetEvent(__E(THREAD_EVENTS_END_SUSS),IO_NO_INCREMENT,FALSE);
		pThread->rt = rt;
		pThread->ThrState = THREAD_IS_TERMINATED_IN_UNNORMAL;
		PsTerminateSystemThread(STATUS_SUCCESS);
	}
	//ʼģ
	EmulatorInit(pEmulator,pCVC,ThreadID);

	KdPrint((" ----ģ߳ %d ɹ----\n",ThreadID));
	

	//߳¼
	KeSetEvent(__E(THREAD_EVENTS_START_SUSS),IO_NO_INCREMENT,FALSE);
	//һУ߳̽ѹһڲSuspend
	pThread->ThrState = THREAD_IS_BLOCKING;
	ThrR0SuspendItSel(pThread);
	pThread->ThrState = THREAD_IS_RUNNING;

	//################################# while ʼ ###################################
	while(1){
		
		//첽¼
		if(*pEmAsynEvent != EM_ASYN_EVENT_NONE){
			switch(*pEmAsynEvent){
			case EM_ASYN_EVENT_DMA:
				EmDMA_Run(pCVC);
				*pEmAsynEvent = EM_ASYN_EVENT_NONE;
				break;
#ifdef SS_DEBUG
			case EM_ASYN_EVENT_DEBUG_BREAK:
				*pEmAsynEvent = EM_ASYN_EVENT_NONE;
				//ǰָڵǰеָ,
#endif
				break;
			case EM_ASYN_EVENT_SUSPEND:
				//Ƿ,Caller ̹߳һⲿSuspend
				*pEmAsynEvent = EM_ASYN_EVENT_NONE;
				if(pThread->ToBeSuspended){
					//֪ͨCalleṛ߳߳
					KeSetEvent(__E(THREAD_EVENTS_SUSPEND),IO_NO_INCREMENT,FALSE);
					pThread->ThrState = THREAD_IS_BLOCKING;
					ThrR0SuspendItSel(pThread);	//ջǵڲSuspend;
					pThread->ThrState = THREAD_IS_RUNNING;
				}
				break;
			default:
				break;
			}//switch

			if(*pEmAsynEvent == EM_ASYN_EVENT_HALT_NORMAL)
			{
				//Ƿ,ֻ߳ⲿ޸Ĵ˱־
				if(pThread->ToBeTerminated)
				{
					pThread->ThrState = THREAD_IS_TERMINATED_OUT;
					*pEmAsynEvent = EM_ASYN_EVENT_NONE;
					break;	//break while
				}
			}
			else if(*pEmAsynEvent == EM_ASYN_EVENT_HALT_UNNORMAL)
			{
				pThread->ThrState = THREAD_IS_TERMINATED_IN_UNNORMAL;
				*pEmAsynEvent = EM_ASYN_EVENT_NONE;
				break;	//break while
			}
		}//if(*pEmAsynEvent != EM_ASYN_EVENT_NONE)

		//ǰ汾cpuִ̫죨ӦʵcpuΪ8086/8088,Ҫһӳ

		delay = 2400;
		while(delay--){};


		//ʱһģ
		rt = EmulateOneInstr(pEmulator);
		//޸ϵͳʱ
		AdvanceTime(pCurTime,EM_TIME_FOR_ONE_INSTR);

		if(rt != SS_SUCCESS)
		{
			pThread->rt = rt;
			pThread->ThrState = THREAD_IS_TERMINATED_IN_UNNORMAL;
			KdPrint(("ģָʱִ󣡣\n"));
			break;
		}
		//쳣ⲿж
		if(*pEInum != EOI_NONE)
		{
			//жϻ쳣
			//NMI
			if(FlagsGetIF(&pEmulator->pReg->_EFLAGS))	//ж
			{
				//if 8259... жϿϢ ĬϿж
				//ģһIntָ
				if(pEmulator->CpuMode == REAL_ADDRESS_MODE)
				{
					//ǰpEm->pReg->_IPΪIntغĵһָIP
					ExcepOrInterr_1(pEmulator,TRUE,*pEInum,FALSE,0);
					//pEmulator->Instr.len = 0;	//תתЧ
				}
				else
				{
					//ǰpEm->pReg->_IPΪIntغĵһָIP
					ExcepOrInterr_0(pEmulator,TRUE,*pEInum,FALSE,0);
					//pEmulator->Instr.len = 0;	//תתЧ
				}
				*pEInum = EOI_NONE;
				//֪ͨжϿ̣߳ǰж
				KeSetEvent(&pCVC->VMM.IntFinishEvent,IO_NO_INCREMENT,FALSE);
			}
		}//if(*pEInum != EOI_NONE)
	}
	//################################# while  ###################################


	//ģ̼߳˳ʱӡϢ
	KdPrint(("һָƣ%s ȣ%X  ǰָϢCS: %X  IP: %X\n",((pIais)(pEmulator->Instr.pi))->Instruction,
					pEmulator->Instr.len,
					pEmulator->pReg->xCS.v,
					pEmulator->pReg->_IP));
	KdPrint(("ǰָӦָδִ,ֽΪ\n"));
	DumpMem(pEmulator->pCIS,LARGEST_INSTRUCTION_LEN,(int)pEmulator->pCIS-(int)pEmulator->pGPM);
	KdPrint(("ָΪ%d\n",pEmulator->Instr.len));
	KdPrint(("ָĩǰֽΪ\n"));
	DumpMem(pEmulator->pCIS-LARGEST_INSTRUCTION_LEN,LARGEST_INSTRUCTION_LEN,(int)pEmulator->pCIS-(int)pEmulator->pGPM-LARGEST_INSTRUCTION_LEN);
	DumpCpu(pEmulator);

#ifdef SS_LOG
	//Dumpڴ
	//ֻ0ģܹ߳Dumpڴ
	if(ThreadID == 0)
	{
		KdPrint(("Dump 1M ڴ浽־...\n"));
		DumpMemToFile(pCVC->VM.Log.FileHanle1,(unsigned char *)pEmulator->pGPM,1024*1024,0);
		KdPrint(("Ѿɹ 1M ڴDump־...\n"));
	}
#endif

	//ͷģ
	EmulatorRelease(pEmulator);

	//˳߳¼
	KeSetEvent(__E(THREAD_EVENTS_END_SUSS),IO_NO_INCREMENT,FALSE);
	if(!IS_TERMINATED_STATE(pThread->ThrState))			//δ֮ǰùս״̬
		pThread->ThrState = THREAD_IS_TERMINATED_IN_NORMAL;
	PsTerminateSystemThread(STATUS_SUCCESS);
}


void EmDMA_Run(tpCVC pCVC){
	int CurDMA;
	int CurChannel;
	tpDMA pDMA = &pCVC->VM.Device.DMA;

	for(CurDMA = 0; CurDMA < DMA_MAX_COUNT ; CurDMA++)
	{
		for(CurChannel = 0; CurChannel < DMA_MAX_CHANNEL_COUNT ; CurChannel++)
		{
			//ڵǰͨͨûб
			if((pDMA->data[CurDMA].SR & (1 << (CurChannel + 4))) 
				&& (!pDMA->data[CurDMA].ChanMask[CurChannel]))
			{
				DMAGetHLDAFromCpu(pCVC,CurDMA,CurChannel);
			}
		}
	}

}