#include "general.h"
#include "VMM/Device/Timer.h"
#include "VMM/CVCR0.h"

#define	TIMER_INTERRUPT_8_CYCLE		200

#ifndef __E
#	define __E(__a)	&(pThread->Events[__a])
#endif

#ifndef __S
#	define __S(__a)	&(pThread->SpinLocks[__a])
#endif

typedef struct tThreadAug{
	tpCVC pCVC;
}tThreadAug, *tpThreadAug;

static void TimerCountMode3Update(tpTimer pTimer,int Channel,unsigned __int64 IntervalClocks);
static void TimerSetGate(tpTimer pTimer,int Channel,bool IsHigh);
static void TimerUpdate(tpTimer pTimer,int Channel);
static int TimerConvertCount2Num(tpTimer pTimer,int Channel,unsigned short count);
static int TimerConvertNum2Count(tpTimer pTimer,int Channel,unsigned short count);

static void TimerThread(PVOID pThreadAug);

EXERESULT TimerCreate(tpTimer pTimer,PVOID pCVC){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("TimerCreate\n"));

	pTimer->pCVC = pCVC;

	KeInitializeEvent(&pTimer->eWaitLastTimerRet,SynchronizationEvent, FALSE);

	TimerCreateTimerThread((tpCVC)(pTimer->pCVC),&pTimer->TimerThread);
	return rt;
}
EXERESULT TimerCreateTimerThread(tpCVC pCVC,tpThread pThread){
	EXERESULT rt = SS_SUCCESS;
	tThreadAug TAug;

	TAug.pCVC = pCVC;
	//߳ 
	pThread->ThreadEntry = TimerThread;
	rt = ThrR0Create(pThread,&TAug);
	return rt;
}


EXERESULT TimerRelease(tpTimer pTimer){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("TimerRelease\n"));

	KeSetEvent(&pTimer->eWaitLastTimerRet,IO_NO_INCREMENT,FALSE);
	TimerReleaseTimerThread((tpCVC)(pTimer->pCVC),&pTimer->TimerThread);
	return rt;
}

EXERESULT TimerReleaseTimerThread(tpCVC pCVC,tpThread pThread){
	EXERESULT rt = SS_SUCCESS;

	ThrR0Term(pThread);
	return rt;
}
EXERESULT TimerInit(tpTimer pTimer,PVOID pCVC){
	EXERESULT rt = SS_SUCCESS;
	int t;
	pTimer->pCVC = pCVC;

	pTimer->CurrentTime = 0;

	for(t = 0;t < TIMER_CHANNEL_MAX_COUNT; t++)
	{
		pTimer->Channel[t].IfReadOutputLatchedMSB = FALSE;
		pTimer->Channel[t].IfWriteCounterRegisterMSB = FALSE;
		pTimer->Channel[t].IsBCD = FALSE;
		pTimer->Channel[t].CounterRegister = 0;
		pTimer->Channel[t].CountMode = 0;
		pTimer->Channel[t].ReadWriteMode = 0;

		pTimer->Channel[t].IsOutputLatched = FALSE;
		pTimer->Channel[t].OutputLatchRegister = 0;

		pTimer->Channel[t].IsStatusLatched = FALSE;
		pTimer->Channel[t].StatusLatchRegister = 0;

		pTimer->Channel[t].IsGateHigh = FALSE;	//ߵƽĬΪ͵,ûźţʱֹͣ
		pTimer->Channel[t].IsTriggerred = FALSE;

		pTimer->Channel[t].counter = 0;
		pTimer->Channel[t].TimeStamp = 0;
		pTimer->Channel[t].IfOutputValue = FALSE;
		pTimer->Channel[t].IsNullCount = TRUE;
		pTimer->Channel[t].IsActive = FALSE;
	}

	TimerSetGate(pTimer,0,TRUE);
	TimerSetGate(pTimer,1,TRUE);

	return rt;
}
//######################## Դغ ############################


static __inline unsigned __int64 TimerGetCurrentTime(tpTimer pTimer){
	//ϵͳʱ0cpuʱΪ׼
	return ((tpCVC)(pTimer->pCVC))->VMM.EM.CurrentTime[0];
}

//ʱתʱ
static __inline unsigned __int64 TimerTimeToClock(unsigned __int64 time){
	//1000000000 ns = 1s
	return (time / 1000000000)*TIMER_CLOCK_PULES_FREQ +
		((time % 1000000000)*TIMER_CLOCK_PULES_FREQ) / 1000000000;
}


static void TimerUpdate(tpTimer pTimer,int Channel){
	//ϴθ
	unsigned __int64 IntervalClocks = TimerTimeToClock(pTimer->CurrentTime)-
		TimerTimeToClock(pTimer->Channel[Channel].TimeStamp);
	switch(pTimer->Channel[Channel].CountMode){
	case 0:	//¼ʱ
		KdPrint(("ڶʱУصδĲģʽ %X\n",pTimer->Channel[Channel].CountMode));
		break;
	case 1:	//´һ壨ONE-SHORT
		KdPrint(("ڶʱУصδĲģʽ %X\n",pTimer->Channel[Channel].CountMode));
		break;
	case 2:	//ʷ
		KdPrint(("ڶʱУصδĲģʽ %X\n",pTimer->Channel[Channel].CountMode));
		break;
	case 3:	//ģʽ
		//KdPrint(("---------------------------- Timer ͨ %X  ģʽ\n",Channel));
		TimerCountMode3Update(pTimer,Channel,IntervalClocks);
		break;
	case 4:	//ѡͨʱ
		KdPrint(("ڶʱУصδĲģʽ %X\n",pTimer->Channel[Channel].CountMode));
		break;
	case 5:	//Ӳɴѡͨ
		KdPrint(("ڶʱУصδĲģʽ %X\n",pTimer->Channel[Channel].CountMode));
		break;
	}
	pTimer->Channel[Channel].IsTriggerred = FALSE;
	pTimer->Channel[Channel].TimeStamp = pTimer->CurrentTime;
}

static int TimerConvertCount2Num(tpTimer pTimer,int Channel,unsigned short count){
	if(count == 0){
		return (pTimer->Channel[Channel].IsBCD) ? 10000 : 0x10000;
	}
	else{
		if(pTimer->Channel[Channel].IsBCD)	//BCD
		{
			return ((count >> 12) & 0xF) * 1000 +
				((count >> 8)  & 0xF) * 100 +
				((count >> 4)  & 0xF) * 10 +
				(count & 0xF);
		}
		else{	//Binary
			return count;
		}
	}
}

static int TimerConvertNum2Count(tpTimer pTimer,int Channel,unsigned short count){
	if(pTimer->Channel[Channel].IsBCD){
		count %= 10000;
		return
			((count / 1000) % 10) << 12 |
			((count /  100) % 10) << 8  |
			((count /   10) % 10) << 4  |
			(count % 10);
	}
	else{
		return count % 0x10000;
	}
}

static void TimerSetGate(tpTimer pTimer,int Channel,bool IsHigh){
	TimerUpdate(pTimer,Channel);

	if(IsHigh && !pTimer->Channel[Channel].IsGateHigh)
		pTimer->Channel[Channel].IsTriggerred = TRUE;

	pTimer->Channel[Channel].IsGateHigh = IsHigh;

	if(!IsHigh && 
		(pTimer->Channel[Channel].CountMode == 2 || pTimer->Channel[Channel].CountMode == 3)){

			pTimer->Channel[Channel].IfOutputValue = TRUE;
	}
}

static void TimerThread(PVOID pThreadAug){
	tpThread pThread;
	tpCVC pCVC;
	tpTimer pTimer;
	pCVC = ((tpThreadAug)pThreadAug)->pCVC;
	pTimer = &((tpCVC)pCVC)->VM.Device.Timer;

	KdPrint(("-------ʱ̴߳ɹ-------\n"));

	pThread = &pCVC->VM.Device.Timer.TimerThread;
	//Callerͳɹ߳¼
	KeSetEvent(__E(THREAD_EVENTS_START_SUSS),IO_NO_INCREMENT,FALSE);
	//һУ߳̽ѹһڲSuspend
	pThread->ThrState = THREAD_IS_BLOCKING;
	ThrR0SuspendItSel(pThread);
	pThread->ThrState = THREAD_IS_RUNNING;

	while(TRUE){
		//Ƿ,ֻ߳ⲿ޸Ĵ˱־
		if(pThread->ToBeTerminated)
		{
			pThread->ThrState = THREAD_IS_TERMINATED_OUT;
			break;	//break while
		}

		if(pThread->ToBeSuspended){
			//֪ͨCalleṛ߳߳
			KeSetEvent(__E(THREAD_EVENTS_SUSPEND),IO_NO_INCREMENT,FALSE);
			pThread->ThrState = THREAD_IS_BLOCKING;
			ThrR0SuspendItSel(pThread);	//ջǵڲSuspend;
			pThread->ThrState = THREAD_IS_RUNNING;
		}

		pTimer->CurrentTime = TimerGetCurrentTime(pTimer);
		TimerUpdate(pTimer,0);
		IntListAddTail(pCVC,0x08);
		HaveASLeep(TIMER_INTERRUPT_8_CYCLE);
	}

	KeSetEvent(__E(THREAD_EVENTS_END_SUSS),IO_NO_INCREMENT,FALSE);
	if(!IS_TERMINATED_STATE(pThread->ThrState))			//δ֮ǰùս״̬
		pThread->ThrState = THREAD_IS_TERMINATED_IN_NORMAL;
	PsTerminateSystemThread(STATUS_SUCCESS);
}

void TimerCountRegChanged(tpTimer pTimer,int Channel){
	TimerUpdate(pTimer,Channel);
	if(pTimer->Channel[Channel].CountMode == 0){
		pTimer->Channel[Channel].IfOutputValue = FALSE;
	}
	else{
		if(!pTimer->Channel[Channel].IsActive)
			pTimer->Channel[Channel].IsTriggerred = TRUE;
	}
	pTimer->Channel[Channel].IsNullCount = TRUE;
	if(pTimer->Channel[Channel].CountMode != 5)
		pTimer->Channel[Channel].IsActive = TRUE;
}

//ģʽ
static void TimerCountMode3Update(tpTimer pTimer,int Channel,unsigned __int64 IntervalClocks){
	int v;
	int c;
	if(pTimer->Channel[Channel].IsTriggerred)
	{
		pTimer->Channel[Channel].counter = pTimer->Channel[Channel].CounterRegister & (~2);
		pTimer->Channel[Channel].IsNullCount = FALSE;
		pTimer->Channel[Channel].IfOutputValue = TRUE;
		IntervalClocks--;
	}
	if(IntervalClocks < 0)
		return;

	if(pTimer->Channel[Channel].IsActive &&
		pTimer->Channel[Channel].IsGateHigh)
	{
		v = TimerConvertCount2Num(pTimer,Channel,pTimer->Channel[Channel].counter);
		if(pTimer->Channel[Channel].counter == 0 &&
			pTimer->Channel[Channel].IfOutputValue &&
			(pTimer->Channel[Channel].CounterRegister & 1) != 0)
			v = 0;
		if(2 * IntervalClocks < v)
			v -= 2 * IntervalClocks;
		else{
			IntervalClocks -= v/2;
			v = TimerConvertCount2Num(pTimer,Channel,pTimer->Channel[Channel].CounterRegister);
			c = (int)(IntervalClocks % v);
			v &= (~2);
			pTimer->Channel[Channel].IsNullCount = FALSE;
			if(!pTimer->Channel[Channel].IfOutputValue){
				pTimer->Channel[Channel].IfOutputValue = TRUE;
				if(2 * c < v){
					v -= 2*c;
					pTimer->Channel[Channel].counter = TimerConvertNum2Count(pTimer,Channel,v);
					return;
				}
				c -= v/2;
			}
			if((pTimer->Channel[Channel].CounterRegister & 1) != 0){
				if(IntervalClocks == 0)
				{
					pTimer->Channel[Channel].counter = 0;
					return;
				}
				IntervalClocks--;
			}
			pTimer->Channel[Channel].IfOutputValue = FALSE;
			if(2 * c >= v)
			{
				c -= v/2;
				pTimer->Channel[Channel].IfOutputValue = TRUE;
			}
			v -= 2 * c;
		}
		pTimer->Channel[Channel].counter = TimerConvertNum2Count(pTimer,Channel,v);
	}
}

//------------------------------40 PORT-----------------------------------
//out...
static void Timer_Write_40(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	tpCVC p = (tpCVC)pCVC;
	tpTimer pTimer = &((tpCVC)pCVC)->VM.Device.Timer;
	tpThread pThread = &pTimer->TimerThread;

	pTimer->CurrentTime = TimerGetCurrentTime(pTimer);

	//putByte

	switch(pTimer->Channel[0].ReadWriteMode){
	case 1:	//LSB
		pTimer->Channel[0].CounterRegister = value & 0xFF;
		TimerCountRegChanged(pTimer,0);
		break;
	case 2:	//MSB
		pTimer->Channel[0].CounterRegister = (value << 8) & 0xFF00;
		TimerCountRegChanged(pTimer,0);
		break;
	case 3:	//LSB ȻMSB
		if(pTimer->Channel[0].IfWriteCounterRegisterMSB){
			pTimer->Channel[0].CounterRegister = 
				(pTimer->Channel[0].CounterRegister & 0x00FF) |
                                    ((value << 8) & 0xFF00);
			pTimer->Channel[0].IfWriteCounterRegisterMSB = FALSE;
			TimerCountRegChanged(pTimer,0);
		}
		else{
			pTimer->Channel[0].CounterRegister = 
				(pTimer->Channel[0].CounterRegister & 0xFF00) | 
				(value & 0xFF);
			pTimer->Channel[0].IfWriteCounterRegisterMSB = TRUE;
		}
		break;
	default://case 0:
		KdPrint(("------------ERROR: ڳд %X ˿ڣ˿ڶдģʽΪ %X\n",portid,pTimer->Channel[0].ReadWriteMode));
	}
	pTimer->Channel[0].counter = value;

	//߳
	//߳ѾȽ
	ThrR0OffSuspend(pThread);
	pThread->ToBeSuspended = TRUE;
	KeWaitForSingleObject(__E(THREAD_EVENTS_SUSPEND), Executive, KernelMode, FALSE, NULL);

	//޸

	//
	ThrR0OffSuspend(pThread);
}
//in...
static unsigned int Timer_Read_40(PVOID pCVC,unsigned short portid,unsigned char len){
	tpCVC p = (tpCVC)pCVC;
	unsigned int ret;
	tpTimer pTimer = &((tpCVC)pCVC)->VM.Device.Timer;
	pTimer->CurrentTime = TimerGetCurrentTime(pTimer);

	/*
	KdPrint(("4444444444444444444444444444444440    IsStatusLatched: %X   IsOutputLatched: %X ReadWriteMode: %X\n",
		pTimer->Channel[0].IsStatusLatched,
		pTimer->Channel[0].IsOutputLatched,
		pTimer->Channel[0].ReadWriteMode
		));
	*/
	//getByte
	if(pTimer->Channel[0].IsStatusLatched)
	{
		pTimer->Channel[0].IsStatusLatched = FALSE;
		return pTimer->Channel[0].StatusLatchRegister;
	}

	if(!pTimer->Channel[0].IsOutputLatched)
	{
		TimerUpdate(pTimer,0);
		pTimer->Channel[0].OutputLatchRegister = pTimer->Channel[0].counter;
	}

	switch(pTimer->Channel[0].ReadWriteMode){
	case 1:
		pTimer->Channel[0].IsOutputLatched = FALSE;
		return pTimer->Channel[0].OutputLatchRegister & 0xFF;
		break;
	case 2:
		pTimer->Channel[0].IsOutputLatched = FALSE;
		return pTimer->Channel[0].OutputLatchRegister >> 8;
		break;
	case 3:
		if(pTimer->Channel[0].IfReadOutputLatchedMSB){
			pTimer->Channel[0].IsOutputLatched = FALSE;
			pTimer->Channel[0].IfReadOutputLatchedMSB = FALSE;
			//KdPrint(("----------------------------Timer 40 port MSB %X",pTimer->Channel[0].OutputLatchRegister >> 8));
			return pTimer->Channel[0].OutputLatchRegister >> 8;
		}
		else{
			pTimer->Channel[0].IfReadOutputLatchedMSB = TRUE;
			//KdPrint(("----------------------------Timer 40 port LSB %X",pTimer->Channel[0].OutputLatchRegister & 0xFF));
			return pTimer->Channel[0].OutputLatchRegister & 0xFF;
		}
		break;
	default://case 0:
		KdPrint(("------------ERROR: ڳԶ %X ˿ڣ˿ڶдģʽΪ %X\n",portid,pTimer->Channel[0].ReadWriteMode));
	}
	return 0xFF;
}
EXERESULT TimerRegister_40(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = Timer_Write_40;
	pIO_Handler->read  = Timer_Read_40;
	return rt;
}

//------------------------------41 PORT-----------------------------------
//out...
static void Timer_Write_41(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	KdPrint(("˿ %X δģȫ\n" ,portid));
}
//in...
static unsigned int Timer_Read_41(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("˿ %X δģȫ\n" ,portid));
	return 0;
}
EXERESULT TimerRegister_41(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = Timer_Write_41;
	pIO_Handler->read  = Timer_Read_41;
	return rt;
}

//------------------------------42 PORT-----------------------------------
//out...
static void Timer_Write_42(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	KdPrint(("˿ %X δģȫ\n" ,portid));
}
//in...
static unsigned int Timer_Read_42(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("˿ %X δģȫ\n" ,portid));
	return 0;
}
EXERESULT TimerRegister_42(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = Timer_Write_42;
	pIO_Handler->read  = Timer_Read_42;
	return rt;
}

//------------------------------43 PORT-----------------------------------
/*
Bits 7,6:	Channel ID (11 is illegal)
Bits 5,4:	Read/load mode for two-byte count value:
			00 -- latch count for reading
			01 -- read/load high byte only
			10 -- read/load low byte only
			11 -- read/load low byte then high byte
Bits 3,2,1:	Count mode selection (000 to 101)
Bit 0:		0/1: Count in binary/BCD
*/
//out...
static void Timer_Write_43(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	unsigned int CurChannel;
	unsigned int ReadWriteMode;
	unsigned int CountMode;
	bool IsBCD;
	tpTimer pTimer = &((tpCVC)pCVC)->VM.Device.Timer;
	tpThread pThread = &pTimer->TimerThread;

	CurChannel = (value >> 6) & 3;
	ReadWriteMode   = (value >> 4) & 3;
	CountMode  = (value >> 1) & 7;
	if(CountMode > 5)
		CountMode &= 3;
	IsBCD = !!(value & 1);

	//KdPrint(("޸ĶʱģʽΪ %X (CurChannel:%X ReadWriteMode:%X CountMode:%X)\n",value,CurChannel,ReadWriteMode,CountMode));

	pTimer->CurrentTime = TimerGetCurrentTime(pTimer);

	if(CurChannel < 3)
	{
		if(ReadWriteMode == 0)
		{
			//ֵ䵽Ĵ
			if(pTimer->Channel[CurChannel].IsOutputLatched == FALSE)
			{	
				TimerUpdate(pTimer,CurChannel);
				//δ
				//
				pTimer->Channel[CurChannel].IsOutputLatched = TRUE;
				pTimer->Channel[CurChannel].OutputLatchRegister = pTimer->Channel[CurChannel].counter;
				pTimer->Channel[CurChannel].IfReadOutputLatchedMSB = FALSE;		//һδOutputLatchжȡΪ8λ
			}
		}
		else{
			//޸ģʽ
			pTimer->Channel[CurChannel].CountMode = CountMode;
			pTimer->Channel[CurChannel].ReadWriteMode = ReadWriteMode;
			pTimer->Channel[CurChannel].IsBCD = IsBCD;
			pTimer->Channel[CurChannel].CounterRegister = 0;
			pTimer->Channel[CurChannel].IsOutputLatched = FALSE;
			pTimer->Channel[CurChannel].IsStatusLatched = FALSE;
			pTimer->Channel[CurChannel].IfReadOutputLatchedMSB = FALSE;
			pTimer->Channel[CurChannel].IfWriteCounterRegisterMSB = FALSE;

			pTimer->Channel[CurChannel].IsTriggerred = FALSE;

			//Timer Internal Info
			pTimer->Channel[CurChannel].counter = 0;
			pTimer->Channel[CurChannel].TimeStamp = TimerGetCurrentTime(pTimer);
			pTimer->Channel[CurChannel].IfOutputValue = (CountMode == 0) ? FALSE : TRUE;
			pTimer->Channel[CurChannel].IsNullCount = TRUE;
			pTimer->Channel[CurChannel].IsActive = FALSE;

			if(CurChannel == 0){
				//߳
				//߳ѾȽ
				ThrR0OffSuspend(pThread);
				pThread->ToBeSuspended = TRUE;
				KeWaitForSingleObject(__E(THREAD_EVENTS_SUSPEND), Executive, KernelMode, FALSE, NULL);

				//޸

				//
				ThrR0OffSuspend(pThread);
			}
			else if(CurChannel == 1){
				KdPrint(("޸ĶʱģʽʱһδģChannel ID: %X\n",CurChannel));
			}
			else if(CurChannel == 2){
				KdPrint(("޸ĶʱģʽʱһδģChannel ID: %X\n",CurChannel));
			}
		}

	}
	else{
		KdPrint(("޸ĶʱģʽʱһȷChannel ID %X\n",CurChannel));
	}

}
//in...
static unsigned int Timer_Read_43(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("ڶһɶĶ˿ %X\n" ,portid));
	return 0xFF;
}
EXERESULT TimerRegister_43(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = Timer_Write_43;
	pIO_Handler->read  = Timer_Read_43;
	return rt;
}

//---------------------------------------241 port----------------------------------
static void TempTimer_241_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
}
static unsigned int TempTimer_241_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	return 0xFF;
}

//---------------------------------------341 port----------------------------------
static void TempTimer_341_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
}
static unsigned int TempTimer_341_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	return 0xFF;
}

EXERESULT TimerRegister(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
	tpDevice pDev = (tpDevice)pDevice;

	//40
	//TimerRegister_40(&pDev->IO_Handler[PROT_HANDLER_40_TIMER]);
	//pDev->Port2HandlerId[0x40] = PROT_HANDLER_40_TIMER;

	//41
	TimerRegister_41(&pDev->IO_Handler[PROT_HANDLER_41_TIMER]);
	pDev->Port2HandlerId[0x41] = PROT_HANDLER_41_TIMER;

	//42
	TimerRegister_42(&pDev->IO_Handler[PROT_HANDLER_42_TIMER]);
	pDev->Port2HandlerId[0x42] = PROT_HANDLER_42_TIMER;

	//43
	//TimerRegister_43(&pDev->IO_Handler[PROT_HANDLER_43_TIMER]);
	//pDev->Port2HandlerId[0x43] = PROT_HANDLER_43_TIMER;

	//ʱ
	pDev->Port2HandlerId[0x241] = PORT_HANDLER_241_TIMER;
	pDev->IO_Handler[PORT_HANDLER_241_TIMER].write = TempTimer_241_Write;
	pDev->IO_Handler[PORT_HANDLER_241_TIMER].read =  TempTimer_241_Read;

	//ʱ
	pDev->Port2HandlerId[0x341] = PORT_HANDLER_341_TIMER;
	pDev->IO_Handler[PORT_HANDLER_341_TIMER].write = TempTimer_341_Write;
	pDev->IO_Handler[PORT_HANDLER_341_TIMER].read =  TempTimer_341_Read;

	return rt;
}