#include "general.h"
#include "VMM/Device/SDM/FloppyR0.h"
#include "Base/File.h"
#include "VMM/Device.h"
#include "VMM/Device/DMA.h"
#include "VMM/CVCR0.h"
#include "VMM/IntList.h"

/*
ibm5160techref.pdf	page.161

߼ = ǰ * ͷ * ÿһŵ +
			ǰͷ * ÿһŵ +
			ǰ - 1
*/

static void FloppyRunCmd(tpFloppy pFloppy);
static void FloppyActTimer(tpFloppy pFloppy);

void FloppyDMAWrite(PVOID pCVC ,int PhyMem,int ByteLen);
void FloppyDMARead(PVOID pCVC ,int PhyMem,int ByteLen);

#define FLOPPY_TIMER_RESET	0x01		//鹹һFloppyָFloppy

tFloppyType FloppyTypesSupported[] ={
	{FLOPPY_CUR_TYPE_360KB,2,40,9},
	{FLOPPY_CUR_TYPE_1440KB,2,80,18}
};

KDEFERRED_ROUTINE FloppyTimerDpc;

EXERESULT FloppyLink(tpFloppy pFloppy){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("FloppyLink\n"));
	KdPrint(("Floppy Path: %ws \n",pFloppy->FilePath));
	KeInitializeTimer(&pFloppy->Timer);
	KeInitializeDpc(&pFloppy->TimerDpc,FloppyTimerDpc,pFloppy);

	rt = FileR0Open(&(pFloppy->FileHandle),pFloppy->FilePath,0);	//0 ̶߳дɾ

	return rt;
}

EXERESULT FloppyUnLink(tpFloppy pFloppy){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("FloppyUnLink\n"));
	//ȡFloppyصsystem timer queueеĶʱ
	KeCancelTimer(&pFloppy->Timer);
	FileR0Close(pFloppy->FileHandle);
	return rt;
}

void FloppyInit(tpFloppy pFloppy,PVOID pCVC){
	int t;
	
	pFloppy->pCVC = pCVC;

	//ǰĬϵFloppy Type Ϊ FLOPPY_CUR_TYPE_360KB
	pFloppy->ft.type = FLOPPY_CUR_TYPE_360KB;
	pFloppy->ft.HeadCount = FloppyTypesSupported[FLOPPY_CUR_TYPE_360KB].HeadCount;
	pFloppy->ft.CylinderCount = FloppyTypesSupported[FLOPPY_CUR_TYPE_360KB].CylinderCount;
	pFloppy->ft.SectorsPerTrack = FloppyTypesSupported[FLOPPY_CUR_TYPE_360KB].SectorsPerTrack;

	pFloppy->IsInterrputState = FALSE;
	pFloppy->DOR = 0x0C;
	pFloppy->MSR = FLOPPY_MAIN_STATUS_MRQ;	//10000000B
	pFloppy->DR  = 0x00;

	pFloppy->Cmd.IsFullCmdFetched = FALSE;
	pFloppy->Cmd.CurIntactCmd = 0;
	pFloppy->Cmd.CmdIndex = 0;
	pFloppy->Cmd.RetIndex = 0;
	pFloppy->Cmd.MaxCmdSize = 0;
	pFloppy->Cmd.MaxRetSize = 0;

	for(t=0 ; t<FLOPPY_MAX_DRIVER_COUNT ; t++)
	{
		pFloppy->Index.cylinder[t] = 0;
		pFloppy->Index.head[t] = 0;
		pFloppy->Index.sector_num[t] = 0;
		pFloppy->Index.sector_size[t] = FLOPPY_SECTOR_SIZE;
	}

	DMAHandlerRegister(pCVC,FloppyDMAWrite,FloppyDMARead,DMA_CHANNEL_FOR_FLOPPY);
}

void FloppyDMAWrite(PVOID pCVC ,int PhyMem,int ByteLen){
}

void FloppyDMARead(PVOID pCVC ,int PhyMem,int ByteLen){
	int ls;		//Logical Sector
	unsigned char CurDriver;
	LARGE_INTEGER	li;
	EXERESULT rt = SS_SUCCESS;
	tpCVC p = (tpCVC)pCVC;
	tpFloppy pFloppy = &p->VM.Device.Sdm.Floppy;

	CurDriver = pFloppy->DOR & 0x03;

	//תΪ߼
	ls = pFloppy->Index.cylinder[CurDriver] * pFloppy->ft.HeadCount * pFloppy->ft.SectorsPerTrack +
		pFloppy->Index.head[CurDriver] * pFloppy->ft.SectorsPerTrack +
		pFloppy->Index.sector_num[CurDriver] - 1;
	li.HighPart = 0;
	li.LowPart = ls * FLOPPY_SECTOR_SIZE;

	rt = FileR0Read(pFloppy->FileHandle,
		(PVOID)((int)(p->VM.Mem.pGuestPhyMem) + PhyMem),
		&li,ByteLen);
	
	//λһ
	FloppyNextSector(pFloppy ,ByteLen/FLOPPY_SECTOR_SIZE);

	if(rt != SS_SUCCESS)
	{
		KdPrint(("ڶȡʱ󣡣\n"));
	}

	pFloppy->ST0 = (pFloppy->Index.head[CurDriver] << 2 ) | CurDriver;
	pFloppy->ST1 = 0;
	pFloppy->ST2 = 0;

	DMAGetDRQFromIO(pFloppy->pCVC,DMA_CHANNEL_FOR_FLOPPY,FALSE);


	//result
	CurDriver = pFloppy->DOR & 0x03;
	pFloppy->Cmd.RetIndex = 0;
	pFloppy->MSR = FLOPPY_MAIN_STATUS_MRQ | FLOPPY_MAIN_STATUS_DIO | FLOPPY_MAIN_STATUS_BUSY;
	pFloppy->Cmd.MaxRetSize = 7;
	pFloppy->Cmd.ret[0] = pFloppy->ST0;
	pFloppy->Cmd.ret[1] = pFloppy->ST1;
	pFloppy->Cmd.ret[2] = pFloppy->ST2;
	pFloppy->Cmd.ret[3] = pFloppy->Index.cylinder[CurDriver];
	pFloppy->Cmd.ret[4] = pFloppy->Index.head[CurDriver];
	pFloppy->Cmd.ret[5] = pFloppy->Index.sector_num[CurDriver];
	pFloppy->Cmd.ret[6] = 2;
	pFloppy->IsInterrputState = TRUE;
	IntListAddTailFast(pFloppy->pCVC,0x0E);

}

void FloppyNextSector(tpFloppy pFloppy,int DiffSectorCount){
	unsigned char CurDriver;
	CurDriver = pFloppy->DOR & 0x03;
	pFloppy->Index.sector_num[CurDriver] += DiffSectorCount;
	if(pFloppy->Index.sector_num[CurDriver] > pFloppy->ft.SectorsPerTrack)
	{
		pFloppy->Index.sector_num[CurDriver] = pFloppy->Index.sector_num[CurDriver] - pFloppy->ft.SectorsPerTrack;
		if(pFloppy->Cmd.MultiTrack)
		{
			pFloppy->Index.head[CurDriver]++;
			//Floppy ͷ
			if(pFloppy->Index.head[CurDriver] > 1)
			{
				pFloppy->Index.head[CurDriver] = 0;
				pFloppy->Index.cylinder[CurDriver]++;
			}
		}
		else{
			pFloppy->Index.cylinder[CurDriver]++;
		}

		if(pFloppy->Index.cylinder[CurDriver] >= pFloppy->ft.CylinderCount)
		{
			pFloppy->Index.cylinder[CurDriver] = pFloppy->ft.CylinderCount;
		}
	}
}

void FloppyActTimer(tpFloppy pFloppy){
	LARGE_INTEGER li;
	li.QuadPart  = -50 * KTIMER_DUETIME_MS;
	KeSetTimer(&pFloppy->Timer,li,&pFloppy->TimerDpc);
}

//Ļ	page.485
VOID FloppyTimerDpc(
    IN PKDPC Dpc,
    IN PVOID DeferredContext,
    IN PVOID SystemArgument1,
    IN PVOID SystemArgument2
    ){

	tpFloppy pFloppy = (tpFloppy)DeferredContext;
	unsigned char CurDriver = pFloppy->DOR & 0x03;
	//KdPrint(("ccccccccccccccccccccccccccccccccccccc  %02X",pFloppy->Cmd.CurIntactCmd));

	switch(pFloppy->Cmd.CurIntactCmd){
	case 0x00:	//ûؽһָ
		break;
	case 0x07:
	case 0x0F:
		pFloppy->ST0 = (0x20 | (pFloppy->Index.head[CurDriver] <<2 ) | CurDriver);

		//idle
		pFloppy->MSR &= 0x0F;
		pFloppy->MSR |= FLOPPY_MAIN_STATUS_MRQ;
		pFloppy->Cmd.CmdIndex = 0x00;
		pFloppy->Cmd.MaxCmdSize = 0x00;
		pFloppy->Cmd.CurIntactCmd = 0x00;


		pFloppy->IsInterrputState = TRUE;
		IntListAddTailFast(pFloppy->pCVC,0x0E);
		break;
	case FLOPPY_TIMER_RESET:
		FloppyInit(pFloppy,pFloppy->pCVC);
		pFloppy->Cmd.CurIntactCmd = 0;
		pFloppy->ST0 = 0xC0;

		pFloppy->IsInterrputState = TRUE;
		IntListAddTailFast(pFloppy->pCVC,0x0E);

		break;
	}
}
//----------------------------------------3F2 port------------------------------------------------
/*
diskette controller DOR (Digital Output Register)		w
bit 7-6    reserved on PS/2
bit 7 = 1  drive 3 motor enable
bit 6 = 1  drive 2 motor enable
bit 5 = 1  drive 1 motor enable
bit 4 = 1  drive 0 motor enable
bit 3 = 1  diskette DMA enable (reserved PS/2)
bit 2 = 1  FDC enable	(controller reset)
	  = 0  hold FDC at reset
 bit 1-0    drive select (0=A 1=B ..)
*/
//out...
static void Floppy_Write_3F2(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	bool IfEnable,PreIfEnable;
	tpFloppy pFloppy= &((tpCVC)pCVC)->VM.Device.Sdm.Floppy;
	PreIfEnable = G8BIT_2(pFloppy->DOR);	//ǰһFloppy Diskette״̬
	IfEnable = G8BIT_2(value);				//ǰFloppy Diskette״̬
	pFloppy->DOR = (unsigned char)value;

	pFloppy->ST0 = 0xC0;
	//IntListAddTailFast(pFloppy->pCVC,0x0E);
	if(!PreIfEnable && IfEnable){		//reset -> enable Ҫһӳٵʱ
		FloppyActTimer(pFloppy);
	}
	else if(PreIfEnable && !IfEnable){
		pFloppy->MSR = FLOPPY_MAIN_STATUS_BUSY;
		pFloppy->Cmd.CurIntactCmd = FLOPPY_TIMER_RESET;
	}
}
//in...
static unsigned int Floppy_Read_3F2(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("ڶɶĶ˿ %X\n",portid));
	return 0;
}

static void FloppyRegister_3F2(tpIO_Handler pIO_Handler){
	pIO_Handler->write = Floppy_Write_3F2;
	pIO_Handler->read =  Floppy_Read_3F2;
}

//----------------------------------------3F4 port------------------------------------------------
/*
diskette controller main status register
bit 7 = 1  RQM	 data register is ready
0  no access is permitted							
bit 6 = 1  transfer is from controller to system	ݶ׼
0  transfer is from system to controller			д׼
bit 5 = 1  non-DMA mode
bit 4 = 1  diskette controller is busy
bit 3 = 1  drive 3 busy (reserved on PS/2)
bit 2 = 1  drive 2 busy (reserved on PS/2)
bit 1 = 1  drive 1 busy (= drive is in seek mode)
bit 0 = 1  drive 0 busy (= drive is in seek mode)
Note:	in non-DMA mode, all data transfers occur through
		port 03F5h and the status registers (bit 5 here
		indicates data read/write rather than than
		command/status read/write)
*/
//out...
static void Floppy_Write_3F4(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	KdPrint(("ддĶ˿ %X\n",portid));

}
//in...
static unsigned int Floppy_Read_3F4(PVOID pCVC,unsigned short portid,unsigned char len){
	return ((tpCVC)pCVC)->VM.Device.Sdm.Floppy.MSR;
}

static void FloppyRegister_3F4(tpIO_Handler pIO_Handler){
	pIO_Handler->write = Floppy_Write_3F4;
	pIO_Handler->read =  Floppy_Read_3F4;
}
//----------------------------------------3F5 port------------------------------------------------
//out...
static void Floppy_Write_3F5(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	tpFloppy pFloppy= &((tpCVC)pCVC)->VM.Device.Sdm.Floppy;
	if(pFloppy->Cmd.CmdIndex == 0){		//ǰǵһֽڣȷĳ
		pFloppy->Cmd.cmd[0] = value;
		pFloppy->Cmd.CmdIndex = 1;
		pFloppy->Cmd.IsFullCmdFetched = FALSE;
		switch(value){
		case 0x03:	//Specify	ָ
			pFloppy->Cmd.MaxCmdSize = 3;
			break;
		case 0x04:	//Sense Driver State	״̬
			pFloppy->Cmd.MaxCmdSize = 2;
			break;
		case 0x07:	//Recalibrate	У
			pFloppy->Cmd.MaxCmdSize = 2;
			break;
		case 0x08:	//Sense Interrupt Status	ж״̬
			pFloppy->Cmd.MaxCmdSize = 1;
			break;
		case 0x0F:	//Seek
			pFloppy->Cmd.MaxCmdSize = 3;
			break;
		case 0x42:	//Read A Track
			pFloppy->Cmd.MaxCmdSize = 9;
			break;
		case 0x4A:	//Read ID
			pFloppy->Cmd.MaxCmdSize = 2;
			break;
		case 0x4D:	//Format A Track
			pFloppy->Cmd.MaxCmdSize = 6;
			break;
		case 0xC5:	//Write Data
			pFloppy->Cmd.MaxCmdSize = 9;
			break;
		case 0xC9:	//Write Delete Data
			pFloppy->Cmd.MaxCmdSize = 9;
			break;
		case 0xCC:	//Read Delete Data
			pFloppy->Cmd.MaxCmdSize = 9;
			break;
		case 0xD1:	//Scan Equal
			pFloppy->Cmd.MaxCmdSize = 9;
			break;
		case 0xE6:	//Read Data
			pFloppy->Cmd.MaxCmdSize = 9;
			pFloppy->Cmd.MultiTrack = value >> 7;
			break;
		default:
			KdPrint(("Flopyy 3F5 ˿дһЧ: %02X \n",value));
			pFloppy->Cmd.MaxCmdSize = 1;
			break;
		}
	}
	else{	//ǰֽΪһ
		pFloppy->Cmd.cmd[pFloppy->Cmd.CmdIndex++] = value;
	}
	if(pFloppy->Cmd.CmdIndex == pFloppy->Cmd.MaxCmdSize)
	{
		pFloppy->Cmd.CurIntactCmd = pFloppy->Cmd.cmd[0];
		FloppyRunCmd(pFloppy);
		pFloppy->Cmd.CmdIndex = 0;
		pFloppy->Cmd.IsFullCmdFetched = TRUE;
	}
}
//in...
static unsigned int Floppy_Read_3F5(PVOID pCVC,unsigned short portid,unsigned char len){
	tpFloppy pFloppy= &((tpCVC)pCVC)->VM.Device.Sdm.Floppy;
	unsigned char rt;
	if(pFloppy->Cmd.MaxRetSize == 0)
	{
		KdPrint(("Floppy 3F5 ˿ڶȡ\n"));
		pFloppy->MSR = 0x00;
		return pFloppy->Cmd.ret[0];
	}

	rt = pFloppy->Cmd.ret[pFloppy->Cmd.RetIndex++];
	pFloppy->MSR &= 0xF0;
	if(pFloppy->Cmd.RetIndex >= pFloppy->Cmd.MaxRetSize)
	{
		pFloppy->IsInterrputState = FALSE;

		//idle
		pFloppy->MSR &= 0x0F;
		pFloppy->MSR |= FLOPPY_MAIN_STATUS_MRQ;
		pFloppy->Cmd.CmdIndex = 0x00;
		pFloppy->Cmd.MaxCmdSize = 0x00;
		pFloppy->Cmd.CurIntactCmd = 0x00;

	}
	return rt;
}

static void FloppyRegister_3F5(tpIO_Handler pIO_Handler){
	pIO_Handler->write = Floppy_Write_3F5;
	pIO_Handler->read =  Floppy_Read_3F5;
}



EXERESULT FloppyRegister(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
	tpDevice pDev = (tpDevice)pDevice;
	//3F2
	FloppyRegister_3F2(&pDev->IO_Handler[PORT_HANDLER_3F2_FLOPPY]);
	pDev->Port2HandlerId[0x3F2] = PORT_HANDLER_3F2_FLOPPY;

	//3F4
	FloppyRegister_3F4(&pDev->IO_Handler[PORT_HANDLER_3F4_FLOPPY]);
	pDev->Port2HandlerId[0x3F4] = PORT_HANDLER_3F4_FLOPPY;

	//3F5
	FloppyRegister_3F5(&pDev->IO_Handler[PORT_HANDLER_3F5_FLOPPY]);
	pDev->Port2HandlerId[0x3F5] = PORT_HANDLER_3F5_FLOPPY;

	return rt;
}




void FloppyRunCmd(tpFloppy pFloppy){
	unsigned char CurDriver;
	unsigned char head;
	unsigned char cylinder;
	unsigned char sector_num;
	unsigned char cmd = pFloppy->Cmd.cmd[0];

	switch(cmd){
	case 0x03:	//Specify	ָ
		pFloppy->MSR &= 0x0F;
		pFloppy->MSR |= FLOPPY_MAIN_STATUS_MRQ;
		pFloppy->Cmd.CmdIndex = 0x00;
		pFloppy->Cmd.MaxCmdSize = 0x00;
		pFloppy->Cmd.CurIntactCmd = 0x00;
		break;
	case 0x04:	//Sense Driver State	״̬
		KdPrint(("--------------------δģFloppy Command %X\n",cmd));
		break;
	case 0x07:	//Recalibrate	У
		CurDriver = pFloppy->Cmd.cmd[1] & 0x03;
		pFloppy->DOR &= 0xFC;
		pFloppy->DOR |= CurDriver;
		pFloppy->DOR |= (0x01 << (4+CurDriver));

		FloppyActTimer(pFloppy);
		
		pFloppy->Index.cylinder[CurDriver] = 0;
		pFloppy->MSR = (1 << CurDriver);

		break;
	case 0x08:	//Sense Interrupt Status	ж״̬
		if(!pFloppy->IsInterrputState){
			pFloppy->ST0 = 0x80;

			//
			pFloppy->Cmd.MaxRetSize = 1;
			pFloppy->Cmd.ret[0] = pFloppy->ST0;
		}
		else{
			CurDriver = pFloppy->DOR & 0x03;
			pFloppy->ST0 &= 0xF8;
			pFloppy->ST0 |= (pFloppy->Index.head[CurDriver] << 2) | CurDriver;

			//
			pFloppy->MSR = FLOPPY_MAIN_STATUS_MRQ | FLOPPY_MAIN_STATUS_DIO | FLOPPY_MAIN_STATUS_BUSY;
			pFloppy->Cmd.MaxRetSize = 2;
			pFloppy->Cmd.ret[0] = pFloppy->ST0;
			pFloppy->Cmd.ret[1] = pFloppy->Index.cylinder[CurDriver];
		}
		break;
	case 0x0F:	//Seek
		CurDriver = pFloppy->Cmd.cmd[1] & 0x03;
		pFloppy->DOR &= 0xFC;
		pFloppy->DOR |= CurDriver;

		pFloppy->Index.head[CurDriver] = (pFloppy->Cmd.cmd[1] >> 2) & 0x01;
		pFloppy->Index.cylinder[CurDriver] = pFloppy->Cmd.cmd[2];

		FloppyActTimer(pFloppy);

		pFloppy->MSR = (1 << CurDriver);

		break;
	case 0x42:	//Read A Track
		KdPrint(("--------------------δģFloppy Command %X\n",cmd));
		break;
	case 0x4A:	//Read ID
		KdPrint(("--------------------δģFloppy Command %X\n",cmd));
		break;
	case 0x4D:	//Format A Track
		KdPrint(("--------------------δģFloppy Command %X\n",cmd));
		break;
	case 0xC5:	//Write Data
		KdPrint(("--------------------δģFloppy Command %X\n",cmd));
		break;
	case 0xC9:	//Write Delete Data
		KdPrint(("--------------------δģFloppy Command %X\n",cmd));
		break;
	case 0xCC:	//Read Delete Data
		KdPrint(("--------------------δģFloppy Command %X\n",cmd));
		break;
	case 0xD1:	//Scan Equal
		KdPrint(("--------------------δģFloppy Command %X\n",cmd));
		break;
	case 0xE6:	//Read Data
		CurDriver = pFloppy->Cmd.cmd[1] & 0x03;
		pFloppy->DOR &= 0xFC;
		pFloppy->DOR |= CurDriver;

		head =  pFloppy->Cmd.cmd[3] & 0x01;
		cylinder = pFloppy->Cmd.cmd[2];
		sector_num = pFloppy->Cmd.cmd[4];

		if(head >= pFloppy->ft.HeadCount)
		{
			KdPrint(("ͷŴڵǰֵ֧ͷ\n"));
			return;
		}

		if(cylinder >= pFloppy->ft.CylinderCount)	//0....
		{
			KdPrint(("Ŵڵǰֵ֧\n"));
			return;
		}

		if(sector_num > pFloppy->ft.SectorsPerTrack)	//1...
		{
			KdPrint(("Ŵڵǰֵ֧\n"));
			pFloppy->Index.head[CurDriver] = head;
			pFloppy->Index.cylinder[CurDriver] = cylinder;
			pFloppy->Index.sector_num[CurDriver] = pFloppy->ft.SectorsPerTrack;		//޸Ϊǰֵ֧
			pFloppy->Index.sector_size[CurDriver] = pFloppy->Cmd.cmd[5];

			pFloppy->ST0 = 0x40 | (head << 2) | CurDriver;
			pFloppy->ST1 = 0x85;
			pFloppy->ST2 = 0x00;

			//result
			pFloppy->Cmd.RetIndex = 0;
			pFloppy->MSR = FLOPPY_MAIN_STATUS_MRQ | FLOPPY_MAIN_STATUS_DIO | FLOPPY_MAIN_STATUS_BUSY;
			pFloppy->Cmd.MaxRetSize = 7;
			pFloppy->Cmd.ret[0] = pFloppy->ST0;
			pFloppy->Cmd.ret[1] = pFloppy->ST1;
			pFloppy->Cmd.ret[2] = pFloppy->ST2;
			pFloppy->Cmd.ret[3] = pFloppy->Index.cylinder[CurDriver];
			pFloppy->Cmd.ret[4] = pFloppy->Index.head[CurDriver];
			pFloppy->Cmd.ret[5] = pFloppy->Index.sector_num[CurDriver];
			pFloppy->Cmd.ret[6] = 2;
			pFloppy->IsInterrputState = TRUE;
			IntListAddTailFast(pFloppy->pCVC,0x0E);
			return;
		}

		pFloppy->Index.head[CurDriver] = head;
		pFloppy->Index.cylinder[CurDriver] = cylinder;
		pFloppy->Index.sector_num[CurDriver] = sector_num;
		pFloppy->Index.sector_size[CurDriver] = pFloppy->Cmd.cmd[5];

		KdPrint(("Read Floppy Sector:\n"));
		KdPrint(("Floppy Head: %X\n",pFloppy->Index.head[CurDriver]));
		KdPrint(("Floppy Cylinder: %X\n",pFloppy->Index.cylinder[CurDriver]));
		KdPrint(("Floppy Sector Num: %X\n",pFloppy->Index.sector_num[CurDriver]));
		KdPrint(("Floppy Data Length(only valid if sector size = 0, else equal 0ffh): %x\n",pFloppy->Cmd.cmd[8]));

		//DRQdma
		DMAGetDRQFromIO(pFloppy->pCVC,DMA_CHANNEL_FOR_FLOPPY,TRUE);

		pFloppy->MSR = FLOPPY_MAIN_STATUS_BUSY;
		break;
	default:
		pFloppy->ST0 = 0x80;
		KdPrint(("--------------------δFloppy Command %X\n",cmd));
		break;
	}
}