/*
ɱжϿ(Programmable Interrupt Controller),
*/
#include "general.h"
#include "VMM/Device/Pic.h"
#include "VMM/Device.h"
#include "VMM/CVCR0.h"

/*
Intel 8259A

ʼICWͲOCW

1жʽ趨ICW1
2жͺŵ趨ICW2
3жϼʽ趨ICW3
4ضȫǶ׷ʽICW4

Master PIC    command     0x20  
Master PIC    data         0x21  
Slave PIC    command     0xA0  
Slave PIC    data         0xA1 

ICW1  20 A0		out
ICW2  21 A1		out
ICW3  21 A1		out
ICW4  21 A1		out

OCW1  21 A1		out
OCW2  20 A0		out
OCW3  20 A0		out

PCжʹ
IRQ0	8	ϵͳʱ0
IRQ1	9	
IRQ2	A	п2
IRQ3	B	2
IRQ4	C	1
IRQ5	D	Ӳ
IRQ6	E	̿
IRQ7	F	п1
*/
EXERESULT PicCreate(tpPic pPic){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("PicCreate"));
	return rt;
}
EXERESULT PicRelease(tpPic pPic){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("PicRelease"));
	return rt;
}
EXERESULT PicInit(tpPic pPic){
	EXERESULT rt = SS_SUCCESS;
	pPic->IsSinglePic = 0;

	pPic->Master.HasInitByCpu = FALSE;
	pPic->Master.CAI = 0;
	pPic->Master.LTIM = 0;
	pPic->Master.ICW4 = 1;
	pPic->Master.PreICW = 0;
	pPic->Master.Irq_Start = 0x08;
	pPic->Master.IrUsedForSlave = 0x02;
	pPic->Master.Mode = 1;
	pPic->Master.AutoEOI = FALSE;
	pPic->Master.BufMode = FALSE;
	pPic->Master.SFNM = FALSE;
	pPic->Master.IsISRInPort20 = FALSE;
	pPic->Master.IMR = 0x00;		//жϲ
	pPic->Master.IRR = 0x00;		//ж
	pPic->Master.ISR = 0x00;		//еж

	pPic->Slave.HasInitByCpu = FALSE;
	pPic->Slave.CAI = 0;
	pPic->Slave.LTIM = 0;
	pPic->Slave.ICW4 = 1;
	pPic->Slave.PreICW = 0;
	pPic->Slave.Irq_Start = 0x70;
	pPic->Slave.SlavedTo = 0x02;
	pPic->Slave.Mode = 1;
	pPic->Slave.AutoEOI = FALSE;
	pPic->Slave.BufMode = FALSE;
	pPic->Slave.SFNM = FALSE;
	pPic->Slave.IsISRInPortA0 = FALSE;
	pPic->Slave.IMR = 0;		//жϲ
	pPic->Slave.IRR = 0x00;		//ж
	pPic->Slave.ISR = 0x00;		//еж

	return rt;
}

//-------------------------------------20 port-----------------------------------------
//out...	command
static void PicMasterCmd_20_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	unsigned char v;
	tpPic pPic = &((tpCVC)pCVC)->VM.Device.Pic;
	v = (unsigned char)value;
	if(G8BIT_4(v))		//Must be set to 1 for ICW1
	{
		//ICW1 ʼ PIC
		//Ĭ ICW4=1SINGL=0CAI=0LTIM=01=1A5=0A6=0A7=0
		pPic->Master.ICW4 = G8BIT_0(v);
		pPic->IsSinglePic = G8BIT_1(v);
		pPic->Master.CAI = G8BIT_2(v);
		pPic->Master.LTIM = G8BIT_3(v);

		pPic->Master.PreICW = 1;
	}
	else{	//OCW
		if(G8BIT_3(v)){		//OCW3
			if(G8BIT_1(v)){		//ָļĴ
				if(G8BIT_0(v))
					pPic->Master.IsISRInPort20 = TRUE;
				else
					pPic->Master.IsISRInPort20 = FALSE;
			}
		}
		else{	//OCW2
			//KdPrint(("δģĿɱжϿָ,ֵΪ%X......................\n",v));
		}
	}
}
//in...
static unsigned int PicMasterCmd_20_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	tpPic pPic = &((tpCVC)pCVC)->VM.Device.Pic;
	if(pPic->Master.IsISRInPort20)
		return pPic->Master.ISR;
	else
		return pPic->Master.IRR;
}
static EXERESULT PicMasterRegister_20(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = PicMasterCmd_20_Write;
	pIO_Handler->read =  PicMasterCmd_20_Read;
	return rt;
}

//-------------------------------------21 port------------------------------------------
//out...		data 
static void PicMasterData_21_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	unsigned char v;
	unsigned slaveid = 0;
	tpPic pPic = &((tpCVC)pCVC)->VM.Device.Pic;
	v = (unsigned char)value;
	if(pPic->Master.HasInitByCpu == FALSE)	//ʼδ	value ֵΪICW
	{
		if(pPic->Master.PreICW == 1){		//ICW2
			pPic->Master.Irq_Start = (v >> 3) * 8;
			pPic->Master.PreICW = 2;
		}
		else if(pPic->Master.PreICW == 2){
			slaveid = 0;
			if(!pPic->IsSinglePic){		//Ҫִ ICW3 ģʽ
				while(v){
					v = v/2;
					slaveid++;
				}
				slaveid--;	//һ
				pPic->Master.IrUsedForSlave = slaveid;
				pPic->Master.PreICW = 3;
			}
			else{						//ΪǰҪִеICW4
				pPic->Master.Mode = G8BIT_0(v);
				pPic->Master.AutoEOI = G8BIT_1(v);
				pPic->Master.BufMode = !!(G8BIT_3(v)*2+G8BIT_2(v));
				pPic->Master.SFNM = G8BIT_4(v);
				pPic->Master.PreICW = 4;
				pPic->Master.HasInitByCpu = TRUE;		//ʼ
			}
		}
		else if(pPic->Master.ICW4 && (pPic->Master.PreICW == 3)){		//ICW4
			pPic->Master.Mode = G8BIT_0(v);
			pPic->Master.AutoEOI = G8BIT_1(v);
			pPic->Master.BufMode = !!(G8BIT_3(v)*2+G8BIT_2(v));
			pPic->Master.SFNM = G8BIT_4(v);
			pPic->Master.PreICW = 4;
			pPic->Master.HasInitByCpu = TRUE;		//ʼ
		}
	}
	else{	//ʼɣvalueֵΪOCW1
		pPic->Master.IMR = v;
	}
}
//in...
static unsigned int PicMasterData_21_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	tpPic pPic = &((tpCVC)pCVC)->VM.Device.Pic;
	return pPic->Master.IMR;
}
static EXERESULT PicMasterRegister_21(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = PicMasterData_21_Write;
	pIO_Handler->read =  PicMasterData_21_Read;
	return rt;
}

//-------------------------------------A0 port------------------------------------------
//out...
static void PicSlaveCmd_A0_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	unsigned char v;
	tpPic pPic = &((tpCVC)pCVC)->VM.Device.Pic;
	v = (unsigned char)value;
	//д20˿ڲ
	if(G8BIT_4(v))		//Must be set to 1 for ICW1
	{
		//ICW1 ʼ PIC
		//Ĭ ICW4=1SINGL=0CAI=0LTIM=01=1A5=0A6=0A7=0
		pPic->Slave.ICW4 = G8BIT_0(v);
		pPic->IsSinglePic = G8BIT_1(v);
		pPic->Slave.CAI = G8BIT_2(v);
		pPic->Slave.LTIM = G8BIT_3(v);
		pPic->Slave.PreICW = 1;
	}
	else{	//OCW
		KdPrint(("δģĿɱжϿָ,ֵΪ%X......................\n",v));
		if(G8BIT_3(v)){		//OCW3
			if(G8BIT_1(v)){		//ָļĴ
				if(G8BIT_0(v))
					pPic->Slave.IsISRInPortA0 = TRUE;
				else
					pPic->Slave.IsISRInPortA0 = FALSE;
			}
		}
		else{	//OCW2
		}
	}
}
//in...
static unsigned int PicSlaveCmd_A0_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	tpPic pPic = &((tpCVC)pCVC)->VM.Device.Pic;
	if(pPic->Slave.IsISRInPortA0)
		return pPic->Slave.ISR;
	else
		return pPic->Slave.IRR;
}
static EXERESULT PicSlaverRegister_A0(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = PicSlaveCmd_A0_Write;
	pIO_Handler->read = PicSlaveCmd_A0_Read;
	return rt;
}

//-------------------------------------A1 port------------------------------------------
//out...	data
static void PicSlaveData_A1_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	unsigned char v;
	tpPic pPic = &((tpCVC)pCVC)->VM.Device.Pic;
	v = (unsigned char)value;
	if(pPic->Slave.HasInitByCpu == FALSE)	//ʼδ	value ֵΪICW
	{
		if(pPic->Slave.PreICW == 1){		//ICW2
			pPic->Slave.Irq_Start = (v >> 3) * 8;
			pPic->Slave.PreICW = 2;
		}
		else if(pPic->Slave.PreICW == 2){
			if(!pPic->IsSinglePic){		//Ҫִ ICW3 ģʽ
				pPic->Slave.SlavedTo = v & 0x07;	//&00000111B
				pPic->Slave.PreICW = 3;
			}
			else{						//ΪǰҪִеICW4
				pPic->Slave.Mode = G8BIT_0(v);
				pPic->Slave.AutoEOI = G8BIT_1(v);
				pPic->Slave.BufMode = !!(G8BIT_3(v)*2+G8BIT_2(v));
				pPic->Slave.SFNM = G8BIT_4(v);
				pPic->Slave.PreICW = 4;
				pPic->Slave.HasInitByCpu = TRUE;	//ʼ
			}
		}
		else if(pPic->Slave.ICW4 && (pPic->Slave.PreICW == 3)){		//ICW4
			pPic->Slave.Mode = G8BIT_0(v);
			pPic->Slave.AutoEOI = G8BIT_1(v);
			pPic->Slave.BufMode = !!(G8BIT_3(v)*2+G8BIT_2(v));
			pPic->Slave.SFNM = G8BIT_4(v);
			pPic->Slave.PreICW = 4;
			pPic->Slave.HasInitByCpu = TRUE;	//ʼ
		}
	}
	else{		//ʼɣvalueֵΪOCW
		pPic->Slave.IMR = v;
	}
}
//in...
static unsigned int PicSlaveData_A1_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	tpPic pPic = &((tpCVC)pCVC)->VM.Device.Pic;
	return pPic->Slave.IMR;
}
static EXERESULT PicSlaverRegister_A1(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = PicSlaveData_A1_Write;
	pIO_Handler->read = PicSlaveData_A1_Read;
	return rt;
}



//
EXERESULT PicRegister(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
	tpDevice pDev = (tpDevice)pDevice;

	//20
	PicMasterRegister_20(&pDev->IO_Handler[PORT_HANDLER_20_PIC]);
	pDev->Port2HandlerId[0x20] = PORT_HANDLER_20_PIC;
	//21
	PicMasterRegister_21(&pDev->IO_Handler[PORT_HANDLER_21_PIC]);
	pDev->Port2HandlerId[0x21] = PORT_HANDLER_21_PIC;
#if CPU_TYPE > 0	//PC/AT++
	//A0
	PicSlaverRegister_A0(&pDevice->IO_Handler[PORT_HANDLER_A0_PIC]);
	pDevice->Port2HandlerId[0xA0] = PORT_HANDLER_A0_PIC;
	//A1
	PicSlaverRegister_A1(&pDevice->IO_Handler[PORT_HANDLER_A1_PIC]);
	pDevice->Port2HandlerId[0xA1] = PORT_HANDLER_A1_PIC;
#endif
	return rt;
}