#include "general.h"
#include "VMM/Device/Keyboard.h"
#include "VMM/CVCR0.h"

/*
8255A(Chip/8255.c) ϵ61˿Ҳм̵Ϣ

CPU Outbuf дInbuf			OutbufCPUֻ	 InbufCPUֻд

*/

KDEFERRED_ROUTINE KeyboardTimerDpc;


EXERESULT KeyboardCreate(tpKeyboard pKeyboard){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("KeyboardCreate"));

	KeInitializeTimer(&pKeyboard->Timer);
	KeInitializeDpc(&pKeyboard->TimerDpc,KeyboardTimerDpc,pKeyboard);

	return rt;
}

EXERESULT KeyboardRelease(tpKeyboard pKeyboard){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("KeyboardRelease"));

	KeCancelTimer(&pKeyboard->Timer);

	return rt;
}

EXERESULT KeyboardInit(tpKeyboard pKeyboard,PVOID pCVC){
	EXERESULT rt = SS_SUCCESS;
	tpCVC p = (tpCVC)pCVC;
	unsigned char * memstart = (unsigned char * )(p->VM.Mem.pGuestPhyMem);
	pKeyboard->pCVC = pCVC;
	pKeyboard->pStatus1 = (unsigned char *)(memstart+KB_PC_XT_DATA_SEG+KB_PC_XT_STATUS1_OFFSET);
	pKeyboard->pStatus2 = (unsigned char *)(memstart+KB_PC_XT_DATA_SEG+KB_PC_XT_STATUS2_OFFSET);
	pKeyboard->pBufHead = (unsigned char *)(memstart+KB_PC_XT_DATA_SEG+KB_PC_XT_BUF_HEAD_P);
	pKeyboard->pBufTail = (unsigned char *)(memstart+KB_PC_XT_DATA_SEG+KB_PC_XT_BUF_TAIL_P);
	*pKeyboard->pBufHead = KB_PC_XT_BUF_HEAD;
	*pKeyboard->pBufTail = KB_PC_XT_BUF_HEAD;

	return rt;
}

void KeyboardActTimer(tpKeyboard pKeyboard){
	LARGE_INTEGER li;
	li.QuadPart  = -2300 * KTIMER_DUETIME_MS;
	KeSetTimer(&pKeyboard->Timer,li,&pKeyboard->TimerDpc);
}

VOID KeyboardTimerDpc(
    IN PKDPC Dpc,
    IN PVOID DeferredContext,
    IN PVOID SystemArgument1,
    IN PVOID SystemArgument2
    ){
	tpKeyboard pKeyboard = (tpKeyboard)DeferredContext;
	tpCVC p = (tpCVC)(pKeyboard->pCVC);
}