#include "general.h"
#include "VMM/Device/Display/MDA.h"
#include "VMM/Device.h"
#include "VMM/CVCR0.h"


EXERESULT MDAInit(tpMDA pMDA){
	EXERESULT rt = SS_SUCCESS;
	unsigned char t;
	pMDA->C6845.Index = 0;
	for(t=0;t < MDA_6845_R_COUNT;t++)
		pMDA->C6845.R[t] = 0;
	pMDA->MCR = 0;
	pMDA->SR = 0;
	return rt;
}

//------------------------------3B4 PORT-----------------------------------
//out...
static void MDA_Write_3B4(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	if(value >= MDA_6845_R_COUNT)
	{
		KdPrint(("д %X ˿ʱ,һȷĲ\n",portid));
		return;
	}
	((tpCVC)pCVC)->VM.Device.Display.MDA.C6845.Index = (unsigned char)value;
}
//in...
static unsigned int MDA_Read_3B4(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("ڶȡɶĶ˿ %X\n",portid));
	return 0;
}
EXERESULT MDARegister_3B4(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = MDA_Write_3B4;
	pIO_Handler->read  = MDA_Read_3B4;
	return rt;
}
//------------------------------3B5 PORT-----------------------------------
//out...
static void MDA_Write_3B5(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	unsigned char index;
	index = ((tpCVC)pCVC)->VM.Device.Display.MDA.C6845.Index;
	((tpCVC)pCVC)->VM.Device.Display.MDA.C6845.R[index] = (unsigned char)value;
}
//in...
static unsigned int MDA_Read_3B5(PVOID pCVC,unsigned short portid,unsigned char len){
	unsigned char index;
	index = ((tpCVC)pCVC)->VM.Device.Display.MDA.C6845.Index;
	return ((tpCVC)pCVC)->VM.Device.Display.MDA.C6845.R[index];
}
EXERESULT MDARegister_3B5(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = MDA_Write_3B5;
	pIO_Handler->read  = MDA_Read_3B5;
	return rt;
}
//------------------------------3B8 PORT-----------------------------------
//out...
static void MDA_Write_3B8(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	((tpCVC)pCVC)->VM.Device.Display.MDA.MCR = (unsigned char)value;
}
//in...
static unsigned int MDA_Read_3B8(PVOID pCVC,unsigned short portid,unsigned char len){
	return ((tpCVC)pCVC)->VM.Device.Display.MDA.MCR;
}
EXERESULT MDARegister_3B8(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = MDA_Write_3B8;
	pIO_Handler->read  = MDA_Read_3B8;
	return rt;
}
//------------------------------3BA PORT-----------------------------------
//out...
static void MDA_Write_3BA(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	((tpCVC)pCVC)->VM.Device.Display.MDA.SR = (unsigned char)value;
}
//in...
static unsigned int MDA_Read_3BA(PVOID pCVC,unsigned short portid,unsigned char len){
	return ((tpCVC)pCVC)->VM.Device.Display.MDA.SR;
}
EXERESULT MDARegister_3BA(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = MDA_Write_3BA;
	pIO_Handler->read  = MDA_Read_3BA;
	return rt;
}

EXERESULT MDARegister(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
	tpDevice pDev = (tpDevice)pDevice;

	//3B4
	MDARegister_3B4(&pDev->IO_Handler[PORT_HANDLER_3B4_MDA]);
	pDev->Port2HandlerId[0x3B4] = PORT_HANDLER_3B4_MDA;
	//3B5
	MDARegister_3B5(&pDev->IO_Handler[PORT_HANDLER_3B5_MDA]);
	pDev->Port2HandlerId[0x3B5] = PORT_HANDLER_3B5_MDA;
	//3B8
	MDARegister_3B8(&pDev->IO_Handler[PORT_HANDLER_3B8_MDA]);
	pDev->Port2HandlerId[0x3B8] = PORT_HANDLER_3B8_MDA;
	//3BA
	MDARegister_3BA(&pDev->IO_Handler[PORT_HANDLER_3BA_MDA]);
	pDev->Port2HandlerId[0x3BA] = PORT_HANDLER_3BA_MDA;

	return rt;
}