#include "general.h"
#include "VMM/Device/Display/CGA.h"
#include "VMM/Device.h"
#include "VMM/CVCR0.h"

EXERESULT CGAInit(tpCGA pCGA){
	EXERESULT rt = SS_SUCCESS;
	pCGA->MCR = 0x03;
	pCGA->CSR = 0x00;
	pCGA->SR  = 0x08;
	return rt;
}

//------------------------------3D4 PORT-----------------------------------
//ڲĴĴ
//out...
static void CGA_Write_3D4(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	if(value >= CGA_6845_R_COUNT)
	{
		KdPrint(("д %X ˿ʱ,һȷĲ\n",portid));
		return;
	}
	((tpCVC)pCVC)->VM.Device.Display.CGA.C6845.Index = (unsigned char)value;
}
//in...
static unsigned int CGA_Read_3D4(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("ڶȡɶĶ˿ %X\n",portid));
	return 0;
}
EXERESULT CGARegister_3D4(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = CGA_Write_3D4;
	pIO_Handler->read  = CGA_Read_3D4;
	return rt;
}

//------------------------------3D5 PORT-----------------------------------
//ڲĴ
//out...
static void CGA_Write_3D5(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	unsigned char index;
	unsigned char v;
	bool IfUpdated;
	bool IfFlashMem;
	bool IfCursorChange;
	int vt;
	int CursorStartAddr;

	tpCVC p = (tpCVC)pCVC;
	tpCGA pCGA = &p->VM.Device.Display.CGA;
	index = pCGA->C6845.Index;
	v = (unsigned char)value;
	IfUpdated = FALSE;
	IfFlashMem = FALSE;
	IfCursorChange = FALSE;
	if(pCGA->C6845.R[index] != v)
	{
		pCGA->C6845.R[index] = v;
		
		switch(index){
		case 0x07:
		case 0x08:
		case 0x09:
			IfUpdated = TRUE;
			break;
		case 0x0A:	//Cursor Start
			break;
		case 0x0B:	//Cursor End
			break;
		case 0x0C:
			IfCursorChange = TRUE;
			break;
		case 0x0D:
			IfCursorChange = TRUE;
			break;
		case 0x0E:	//Cursor Address(High)
			IfCursorChange = TRUE;
			break;
		case 0x0F:	//Cursor Address(Low)
			IfCursorChange = TRUE;
			//IfFlashMem = TRUE;
			break;
		case 0x17:
		case 0x18:
			//IfUpdated = TRUE;
			break;
		}

	}
	if(IfCursorChange)
	{
		CursorStartAddr = ((pCGA->C6845.R[0xC] & 0x3F) << 8) | (pCGA->C6845.R[0xD] & 0xFF);
		vt = ((pCGA->C6845.R[0xE] & 0x3F) << 8) | (pCGA->C6845.R[0xF] & 0xFF);
		vt = (vt - CursorStartAddr) & 0x1FFF;
		if(vt < 0){
			*p->pSubCVCR3->DisplayR3.ANM.pCursorChar_X = 0;
			*p->pSubCVCR3->DisplayR3.ANM.pCursorChar_Y = 50;
		}
		else{
			*p->pSubCVCR3->DisplayR3.ANM.pCursorChar_X = vt % 80;
			*p->pSubCVCR3->DisplayR3.ANM.pCursorChar_Y = vt / 80;
		}
	}
	/*
	if(IfUpdated = TRUE)
	{
		memset(p->VM.Device.Display.pVideoMemR3,0,BOOT_VIDEO_MEM_SIZE);
	}
	*/
}
//in...
static unsigned int CGA_Read_3D5(PVOID pCVC,unsigned short portid,unsigned char len){
	unsigned char index;
	index = ((tpCVC)pCVC)->VM.Device.Display.CGA.C6845.Index;
	return ((tpCVC)pCVC)->VM.Device.Display.CGA.C6845.R[index];
}
EXERESULT CGARegister_3D5(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = CGA_Write_3D5;
	pIO_Handler->read  = CGA_Read_3D5;
	return rt;
}

//------------------------------3D8 PORT-----------------------------------
/*
Mode-Select Registers
Bit 0  80x25 Alphanumeric Mode
Bit 1  Graphics Select
Bit 2  Black/White Select
Bit 3  Enable Video Signal
Bit 4  High-Resolution(640x200)Black/White Mode
Bit 5  Change Background Intensity to Blink Bit
Bit 6  Not Used
Bit 7  Not Used
*/
//out...
static void CGA_Write_3D8(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	unsigned char pre_mcr;

	pre_mcr = ((tpCVC)pCVC)->VM.Device.Display.CGA.MCR;
	((tpCVC)pCVC)->VM.Device.Display.CGA.MCR = (unsigned char)value;
	if(G8BIT_0(pre_mcr) != G8BIT_0(value))
	{
		if(G8BIT_0(value))		//80*25
		{
			*((tpCVC)pCVC)->pSubCVCR3->DisplayR3.pDisplayHPixel = 640;
			*((tpCVC)pCVC)->pSubCVCR3->DisplayR3.pDisplayVPixel = 200;
		}
		else{					//40*25
			*((tpCVC)pCVC)->pSubCVCR3->DisplayR3.pDisplayHPixel = 320;
			*((tpCVC)pCVC)->pSubCVCR3->DisplayR3.pDisplayVPixel = 200;
		}
	}
}
//in...
static unsigned int CGA_Read_3D8(PVOID pCVC,unsigned short portid,unsigned char len){
	return ((tpCVC)pCVC)->VM.Device.Display.CGA.MCR;
}
EXERESULT CGARegister_3D8(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = CGA_Write_3D8;
	pIO_Handler->read  = CGA_Read_3D8;
	return rt;
}

//------------------------------3D9 PORT-----------------------------------
//out...
static void CGA_Write_3D9(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	((tpCVC)pCVC)->VM.Device.Display.CGA.CSR = (unsigned char)value;
}
//in...
static unsigned int CGA_Read_3D9(PVOID pCVC,unsigned short portid,unsigned char len){
	return ((tpCVC)pCVC)->VM.Device.Display.CGA.CSR;
}
EXERESULT CGARegister_3D9(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = CGA_Write_3D9;
	pIO_Handler->read  = CGA_Read_3D9;
	return rt;
}

//------------------------------3DA PORT-----------------------------------
//out...
static void CGA_Write_3DA(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	KdPrint(("ддĶ˿ %X\n",portid));
}
//in...
static unsigned int CGA_Read_3DA(PVOID pCVC,unsigned short portid,unsigned char len){
	unsigned char sr;
	sr = ((tpCVC)pCVC)->VM.Device.Display.CGA.SR;
	((tpCVC)pCVC)->VM.Device.Display.CGA.SR = (sr & 0xFE) | (~(sr & 0x01) & 0x01);	//ʾ״̬л
	return ((tpCVC)pCVC)->VM.Device.Display.CGA.SR;
}
EXERESULT CGARegister_3DA(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = CGA_Write_3DA;
	pIO_Handler->read  = CGA_Read_3DA;
	return rt;
}

EXERESULT CGARegister(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
	tpDevice pDev = (tpDevice)pDevice;

	//3D4
	CGARegister_3D4(&pDev->IO_Handler[PORT_HANDLER_3D4_CGA]);
	pDev->Port2HandlerId[0x3D4] = PORT_HANDLER_3D4_CGA;
	//3D5
	CGARegister_3D5(&pDev->IO_Handler[PORT_HANDLER_3D5_CGA]);
	pDev->Port2HandlerId[0x3D5] = PORT_HANDLER_3D5_CGA;
	//3D8
	CGARegister_3D8(&pDev->IO_Handler[PORT_HANDLER_3D8_CGA]);
	pDev->Port2HandlerId[0x3D8] = PORT_HANDLER_3D8_CGA;
	//3D9
	CGARegister_3D9(&pDev->IO_Handler[PORT_HANDLER_3D9_CGA]);
	pDev->Port2HandlerId[0x3D9] = PORT_HANDLER_3D9_CGA;
	//3DA
	CGARegister_3DA(&pDev->IO_Handler[PORT_HANDLER_3DA_CGA]);
	pDev->Port2HandlerId[0x3DA] = PORT_HANDLER_3DA_CGA;
	return rt;
}