#include "general.h"
#include "VMM/Device/Display.h"
#include "VMM/CVCR0.h"

EXERESULT DisplayCreate(tpDisplay pDisplay,PVOID pCVC){
	EXERESULT rt = SS_SUCCESS;
	tpCVC p = (tpCVC)pCVC;
	KdPrint(("DisplayCreate\n"));
	pDisplay->pBootVideoMemMdl = IoAllocateMdl(						//DisplayReleaseͷ
		(char *)(p->VM.Mem.pGuestPhyMem)+BOOT_VIDEO_MEM_START,
		BOOT_VIDEO_MEM_SIZE,
		FALSE,
		FALSE,
		NULL
		);
	if(!pDisplay->pBootVideoMemMdl)
	{
		rt = SS_INSUFFICIENT_RESOURCES;
		return rt;
	}

	//ϵͳص㣬ĬΪ0
	//MmGetMdlByteOffset(pDisplay->pBootVideoMemMdl);

	MmBuildMdlForNonPagedPool(pDisplay->pBootVideoMemMdl);

	p->pSubCVCR3->DisplayR3.pVideoMem = NULL;
	pDisplay->pVideoMemR3 = NULL;
	pDisplay->pVideoMemR3 = (char *)MmMapLockedPagesSpecifyCache(		//DisplayReleaseͷ
		pDisplay->pBootVideoMemMdl,
		UserMode,
		MmCached,
		NULL,
		FALSE,
		NormalPagePriority
		);
	if(!pDisplay->pVideoMemR3)
	{
		IoFreeMdl(pDisplay->pBootVideoMemMdl);
		pDisplay->pBootVideoMemMdl = NULL;
		rt = SS_INSUFFICIENT_RESOURCES;
		return rt;
	}
	p->pSubCVCR3->DisplayR3.pVideoMem = (char *)pDisplay->pVideoMemR3;
	return rt;
}

EXERESULT DisplayRelease(tpDisplay pDisplay,PVOID pCVC){
	EXERESULT rt = SS_SUCCESS;
	tpCVC p = (tpCVC)pCVC;
	KdPrint(("DisplayRelease\n"));
	if(pDisplay->pBootVideoMemMdl)
	{
		if(pDisplay->pVideoMemR3)
		{
			MmUnmapLockedPages(pDisplay->pVideoMemR3,pDisplay->pBootVideoMemMdl);
			pDisplay->pVideoMemR3 = NULL;
		}
		IoFreeMdl(pDisplay->pBootVideoMemMdl);
		pDisplay->pBootVideoMemMdl = NULL;
	}
	return rt;
}

EXERESULT DisplayInit(tpDisplay pDisplay){
	EXERESULT rt = SS_SUCCESS;
#if CPU_TYPE == 0
	pDisplay->CGA.IsSupported = TRUE;
	pDisplay->MDA.IsSupported = FALSE;
	CGAInit(&pDisplay->CGA);
	MDAInit(&pDisplay->MDA);
#endif
	return rt;
}

EXERESULT DisplayRegister(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
#if CPU_TYPE == 0
	CGARegister(pDevice);
	MDARegister(pDevice);
#endif
	return rt;
}