#include "general.h"
#include "VMM/Device/DMA.h"
#include "VMM/Device.h"
#include "VMM/CVCR0.h"

/*
//8237A.pdf

Ӧ׶:
	  DRQ		     HRQ	
   --------->     -------->
I/O			 DMAC		   CPU
   <---------     <--------
     DMACK			 HLDA

DRQ		Device Request
HRQ		Hightway Request
HLDA	Hold Acknowledge
DMACK	DMA Acknowledge
*/

EXERESULT DMACreate(tpDMA pDMA,PVOID pCVC){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("DMACreate\n"));
	return rt;
}

EXERESULT DMARelease(tpDMA pDMA,PVOID pCVC){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("DMARelease\n"));
	return rt;
}

void DMABlankWrite(PVOID pCVC ,int PhyMem,int ByteLen){
	KdPrint(("ERROR: δעѱעDMAͨ\n"));
}
void DMABlankRead(PVOID pCVC ,int PhyMem,int ByteLen){
	KdPrint(("ERROR: δעѱעDMAͨ\n"));
}

EXERESULT DMAInit(tpDMA pDMA){
	EXERESULT rt = SS_SUCCESS;
	int q,t;

	for(q = 0; q < DMA_MAX_COUNT;q++)
	{
		pDMA->data[q].Flip_Flop = FALSE;
		pDMA->data[q].CR = 0;
		pDMA->data[q].MAR = 0;
		pDMA->data[q].RR = 0;
		pDMA->data[q].SR = 0;
		pDMA->data[q].TAR = 0;
		pDMA->data[q].TR = 0;
		pDMA->data[q].TWCR = 0;
	}

	
	for(q = 0; q < DMA_MAX_COUNT;q++)
	{
		for(t=0;t<DMA_MAX_CHANNEL_COUNT;t++)
		{
			pDMA->data[q].ChanMask[t] = FALSE;

			pDMA->data[q].Channel[t].IsUsed = FALSE;
			pDMA->data[q].Channel[t].BAR = 0;
			pDMA->data[q].Channel[t].BWCR = 0;
			pDMA->data[q].Channel[t].CAR = 0;
			pDMA->data[q].Channel[t].CWCR = 0;
			pDMA->data[q].Channel[t].MOR = 0;
			pDMA->data[q].Channel[t].PR = 0;

			pDMA->data[q].Channel[t].DMAWrite  = DMABlankWrite;
			pDMA->data[q].Channel[t].DMARead   = DMABlankRead;
		}
	}

	pDMA->data[1].Channel[0].IsUsed = TRUE;

	return rt;
}



//----------------------------------------04 port------------------------------------------------
//Channel 2
//out...
static void DMA_Write_04(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	tpCVC p = (tpCVC)pCVC;
	if(!p->VM.Device.DMA.data[0].Flip_Flop)
	{
		p->VM.Device.DMA.data[0].Channel[2].BAR = value;
		p->VM.Device.DMA.data[0].Channel[2].CAR = value;
	}
	else{
		p->VM.Device.DMA.data[0].Channel[2].BAR |= (value << 8);
		p->VM.Device.DMA.data[0].Channel[2].CAR |= (value << 8);
	}
	p->VM.Device.DMA.data[0].Flip_Flop = !p->VM.Device.DMA.data[0].Flip_Flop;
}
//in...
static unsigned int DMA_Read_04(PVOID pCVC,unsigned short portid,unsigned char len){
	unsigned char rt;
	tpCVC p = (tpCVC)pCVC;
	if(!p->VM.Device.DMA.data[0].Flip_Flop)
		rt = (p->VM.Device.DMA.data[0].Channel[2].CAR & 0x0F);
	else
		rt = (p->VM.Device.DMA.data[0].Channel[2].CAR) >> 8;
	p->VM.Device.DMA.data[0].Flip_Flop = !p->VM.Device.DMA.data[0].Flip_Flop;
	return rt;
}

static void DMARegister_04(tpIO_Handler pIO_Handler){
	pIO_Handler->write = DMA_Write_04;
	pIO_Handler->read =  DMA_Read_04;
}


//----------------------------------------05 port------------------------------------------------
//Channel 2
//out...
static void DMA_Write_05(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	tpCVC p = (tpCVC)pCVC;
	if(!p->VM.Device.DMA.data[0].Flip_Flop)
	{
		p->VM.Device.DMA.data[0].Channel[2].BWCR = value;
		p->VM.Device.DMA.data[0].Channel[2].CWCR = value;
	}
	else{
		p->VM.Device.DMA.data[0].Channel[2].BWCR |= (value << 8);
		p->VM.Device.DMA.data[0].Channel[2].CWCR |= (value << 8);
	}
	p->VM.Device.DMA.data[0].Flip_Flop = !p->VM.Device.DMA.data[0].Flip_Flop;
}
//in...
static unsigned int DMA_Read_05(PVOID pCVC,unsigned short portid,unsigned char len){
	unsigned char rt;
	tpCVC p = (tpCVC)pCVC;
	if(!p->VM.Device.DMA.data[0].Flip_Flop)
		rt = (p->VM.Device.DMA.data[0].Channel[2].CWCR & 0x0F);
	else
		rt = (p->VM.Device.DMA.data[0].Channel[2].CWCR) >> 8;
	p->VM.Device.DMA.data[0].Flip_Flop = !p->VM.Device.DMA.data[0].Flip_Flop;
	return rt;
}

static void DMARegister_05(tpIO_Handler pIO_Handler){
	pIO_Handler->write = DMA_Write_05;
	pIO_Handler->read =  DMA_Read_05;
}

//----------------------------------------0A port------------------------------------------------
//Mask Register
/*
  B2    = 0 Clear Mask Bit		ֹDMAͨ
        = 1 Set Mask Bit
  B1 B1 = 00 Channel 0
		= 01 Channel 1
		= 10 Channel 2
		= 11 Channel 3
*/
//out...
static void DMA_Write_0A(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	tpCVC p = (tpCVC)pCVC;
	int channel = value & 0x03;
	bool IfMask = !!(value & 0x04);
	p->VM.Device.DMA.data[0].ChanMask[channel] = IfMask;
}
//in...
static unsigned int DMA_Read_0A(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("ڶһֻдĶ˿ %X\n",portid));
	return 0;
}

static void DMARegister_0A(tpIO_Handler pIO_Handler){
	pIO_Handler->write = DMA_Write_0A;
	pIO_Handler->read =  DMA_Read_0A;
}

//----------------------------------------0B port------------------------------------------------
//out...
static void DMA_Write_0B(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	tpCVC p = (tpCVC)pCVC;
	int channel = value & 0x03;
	p->VM.Device.DMA.data[0].Channel[channel].MOR = value;
}
//in...
static unsigned int DMA_Read_0B(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("ڶһɶĶ˿ %X \n",portid));
	return 0;
}

static void DMARegister_0B(tpIO_Handler pIO_Handler){
	pIO_Handler->write = DMA_Write_0B;
	pIO_Handler->read =  DMA_Read_0B;
}


//----------------------------------------0C port------------------------------------------------
//
//out...
static void DMA_Write_0C(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	tpCVC p = (tpCVC)pCVC;
	p->VM.Device.DMA.data[0].Flip_Flop = 0;
}
//in...
static unsigned int DMA_Read_0C(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("ڶһɶĶ˿ %X \n",portid));
	return 0;
}

static void DMARegister_0C(tpIO_Handler pIO_Handler){
	pIO_Handler->write = DMA_Write_0C;
	pIO_Handler->read =  DMA_Read_0C;
}


//----------------------------------------81 port------------------------------------------------
//Channel 2
//out...
static void DMA_Write_81(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	tpCVC p = (tpCVC)pCVC;
	p->VM.Device.DMA.data[0].Channel[2].PR = value;
}
//in...
static unsigned int DMA_Read_81(PVOID pCVC,unsigned short portid,unsigned char len){
	tpCVC p = (tpCVC)pCVC;
	return p->VM.Device.DMA.data[0].Channel[2].PR;
}

static void DMARegister_81(tpIO_Handler pIO_Handler){
	pIO_Handler->write = DMA_Write_81;
	pIO_Handler->read =  DMA_Read_81;
}


EXERESULT DMARegister(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
	tpDevice pDev = (tpDevice)pDevice;

	//0x04
	DMARegister_04(&pDev->IO_Handler[PORT_HANDLER_04_DMA]);
	pDev->Port2HandlerId[0x04] = PORT_HANDLER_04_DMA;

	//0x05
	DMARegister_05(&pDev->IO_Handler[PORT_HANDLER_05_DMA]);
	pDev->Port2HandlerId[0x05] = PORT_HANDLER_05_DMA;

	//0x0A
	DMARegister_0A(&pDev->IO_Handler[PORT_HANDLER_0A_DMA]);
	pDev->Port2HandlerId[0x0A] = PORT_HANDLER_0A_DMA;

	//0x0B
	DMARegister_0B(&pDev->IO_Handler[PORT_HANDLER_0B_DMA]);
	pDev->Port2HandlerId[0x0B] = PORT_HANDLER_0B_DMA;

	//0x0C
	DMARegister_0C(&pDev->IO_Handler[PORT_HANDLER_0C_DMA]);
	pDev->Port2HandlerId[0x0C] = PORT_HANDLER_0C_DMA;

	//0x81
	DMARegister_81(&pDev->IO_Handler[PORT_HANDLER_81_DMA]);
	pDev->Port2HandlerId[0x81] = PORT_HANDLER_81_DMA;

	return rt;
}
////////////////////////////////ж˿ע////////////////////////////////

void DMAHandlerRegister(PVOID pCVC,
	void (* DMAWrite)(PVOID pCVC ,int PhyMem,int ByteLen),
	void (* DMARead)(PVOID pCVC ,int PhyMem,int ByteLen),
	unsigned int Channel
	){
	tpCVC p = (tpCVC)pCVC;
	tpDMA pDMA = &p->VM.Device.DMA;

	if(Channel > 3)
	{
		KdPrint(("ERRORעһЧDMAͨ\n"));
		return;
	}
	pDMA->data[0].Channel[Channel].DMAWrite = DMAWrite;
	pDMA->data[0].Channel[Channel].DMARead  = DMARead;

	pDMA->data[0].Channel[Channel].IsUsed = TRUE;
}



//I/O DRQDMAC ,֪ͨ DMAC ǰҪDMAд
void DMAGetDRQFromIO(PVOID pCVC,int Channel,bool value){
	tpCVC p = (tpCVC)pCVC;
	tpDMA pDMA = &p->VM.Device.DMA;
	int CurDMA;
	int CurChannel;

	if(Channel > 7)
	{
		KdPrint(("ERROR: DMA ʱ Channel > 7 \n"));
		return;
	}

	CurDMA = (Channel > 3);
	CurChannel = Channel & 0x03;

	//ǰͨǷѾע
	if(!pDMA->data[CurDMA].Channel[CurChannel].IsUsed)
	{
		KdPrint(("ERROR: ͼδעDMAͨ\n"));
		return;
	}

	if(!value)
	{
		//ǰͨãδӦ
		pDMA->data[CurDMA].SR &= ~(1 << (CurChannel+4));
		return;
	}

	pDMA->data[CurDMA].SR |= (1 << (CurChannel+4));

	DMASendHRQ2Cpu(p);
}

void DMASendHRQ2Cpu(PVOID pCVC){
	tpCVC p = (tpCVC)pCVC;
	//Ĭcpu0dmaСͬ
	p->VMM.EM.EmuAsynEvent[0] = EM_ASYN_EVENT_DMA;
}

void DMAGetHLDAFromCpu(PVOID pCVC ,int CurDMA,int CurChannel){
	//DMA߿Ȩʼд
	DMARunChannel(pCVC,CurDMA,CurChannel);
}

void DMARunChannel(PVOID pCVC ,int CurDMA,int CurChannel){
	tpCVC p = (tpCVC)pCVC;
	tpDMA pDMA = &p->VM.Device.DMA;
	int addr;
	int t;
	int cmd;
	int len;
	bool IsAddDec;
	bool IsAutoInit;

	//ֽڳ
	len = (pDMA->data[CurDMA].Channel[CurChannel].CWCR+1) << CurDMA;

	//
	cmd = (pDMA->data[CurDMA].Channel[CurChannel].MOR >> 0x02) & 0x03;

	//ƶһλݺڴַǷ١  TRUE: Decrement		FALSE: Increment
	IsAddDec = (pDMA->data[CurDMA].Channel[CurChannel].MOR >> 0x05) & 0x01;

	//ǷԶʼ		TRUE: Զ		FALSEԶ
	IsAutoInit = (pDMA->data[CurDMA].Channel[CurChannel].MOR >> 0x04) & 0x01;

	//ڴ׵ַ
	if(IsAddDec){
		addr = (pDMA->data[CurDMA].Channel[CurChannel].PR << 16 ) |
		(pDMA->data[CurDMA].Channel[CurChannel].CAR << CurDMA);
		addr -= len;
	}
	else{
		addr = (pDMA->data[CurDMA].Channel[CurChannel].PR << 16 ) |
		(pDMA->data[CurDMA].Channel[CurChannel].CAR << CurDMA);
	}

	//KdPrint(("DMA: \n"));
	//KdPrint(("DMA Mode 0x%X\n",pDMA->data[CurDMA].Channel[CurChannel].MOR));
	//KdPrint(("DMA Physical Memory Address 0x%X\n",addr));
	//KdPrint(("DMA Data Length: %d\n",len));
	
	switch(cmd){
	case 0x00:	//У
		KdPrint(("WARN: δģDMAģʽ\n"));
		break;
	case 0x01:	//DMAI/ORAM
		pDMA->data[CurDMA].Channel[CurChannel].DMARead(pCVC,addr,len);
		break;
	case 0x02:	//DMAдRAM I/O
		KdPrint(("WARN: δģDMAģʽ\n"));
		break;
	case 0x03:	//Ч
		KdPrint(("WARN: δģDMAģʽ\n"));
		break;
	}
	pDMA->data[CurDMA].Channel[CurChannel].CWCR = 0xFFFF;
	pDMA->data[CurDMA].SR |= (1 << CurChannel);
	if(IsAutoInit == FALSE)
	{
		pDMA->data[CurDMA].ChanMask[CurChannel] = 0x01;
	}
	else{
		pDMA->data[CurDMA].Channel[CurChannel].CAR = pDMA->data[CurDMA].Channel[CurChannel].BAR;
		pDMA->data[CurDMA].Channel[CurChannel].CWCR = pDMA->data[CurDMA].Channel[CurChannel].BWCR;
	}
}