#include "general.h"
#include "VMM/Device/Chip/GameAdapter.h"
#include "VMM/CVCR0.h"

EXERESULT GameCAInit(tpGameCA pGameCA){
	EXERESULT rt = SS_SUCCESS;
	pGameCA->p201 = 0x0F;
	return rt;
}

//------------------------------------201 PORT----------------------------------------
static void GameCA_Write_201(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	((tpCVC)pCVC)->VM.Device.Chips.GameCA.p201 = (unsigned char)value;
}
static unsigned int GameCA_Read_201(PVOID pCVC,unsigned short portid,unsigned char len){
	return ((tpCVC)pCVC)->VM.Device.Chips.GameCA.p201;
}

void GameCARegister_201(tpIO_Handler pIO_Handler){
	pIO_Handler->write = GameCA_Write_201;
	pIO_Handler->read =  GameCA_Read_201;
}
EXERESULT GameCARegister(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
	tpDevice pDev = (tpDevice)pDevice;
	//0x201
	GameCARegister_201(&pDev->IO_Handler[PORT_HANDLER_201_GAMECA]);
	pDev->Port2HandlerId[0x201] = PORT_HANDLER_201_GAMECA;

	return rt;
}