#include "general.h"
#include "VMM/Device/Chip/8255.h"
#include "VMM/CVCR0.h"

#include "VMM/Device/Keyboard.h"

/*
ɱ̲I/OӿоƬ

61 port
7r/w=1	϶˿60hأżݣIRQ
     0	Ŷ˿60hأֹݣIRQ
6r/w=0	ּʱӵֵͣΪ0ܷݣ
5r/w=0	I/0żУ----NMI
4r/w=0	RAMżУ----NMI
3r/w=0	Switch
2r/w=0	RAMСĶأ˿62λ0-3
     1	Ŷÿأ˿62hλ0
1r/w=1	
0r/w=1	ʱ2

ibm5160techref.pdf	page.20

Sw-1	Loop on POST
S2-2	Co-Processor Installed
Sw-4 Sw-3	Amount of Memory On System Board
  0    0	 64K
  0    1	128K
  1    0	192K
  1    1	256K
Sw-6 Sw-5	Display at Power-Up Mode
  0    0	Reserved
  0    1	Color 40 X 25 (BW Mode)
  1    0	Color 80 X 25 (BW Mode)
  1    1	IBM Monochrome 80 X 25
Sw-8 Sw-7	Number of 5-1 14" Drives In System
  0    0	1
  0    1	2
  1    0	3
  1    1	4

*/

EXERESULT C8255Init(tpC8255 pC8255){
	EXERESULT rt = SS_SUCCESS;
	pC8255->switchs = 0x2d;		//00011100B:һCGA 4025У256Kڴ
	pC8255->PA60 = 0x00;
	pC8255->PB61 = 0x08;	//PB3 = 1 : read high swtichs
	pC8255->PC62 = pC8255->switchs >> 4;	//Ϊhigh swtichs
	pC8255->CM63 = 0x99;
	return rt;
}
//-----------------------------Command/Mode 60 PORT--------------------------------------
static void C8255_60_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	KdPrint(("WARN: дһֻĶ˿ %X\n",portid));
}
static unsigned int C8255_60_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	tpC8255 pC8255 = &((tpCVC)pCVC)->VM.Device.Chips.C8255;
	unsigned pa60 = pC8255->PA60;
	KdPrint(("-----------------------8255 R 60   %X\n",pC8255->PA60));
	if(G8BIT_7(pC8255->PB61))	//Ϊߵƽ
		return 0;
	else
	{
		pC8255->PA60 = 0;
		return pa60;
	}
}
EXERESULT C8255Register_60(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = C8255_60_Write;
	pIO_Handler->read =  C8255_60_Read;
	return rt;
}

//-----------------------------PB 61 PORT--------------------------------------
//PB
static void C8255_61_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	unsigned char pc;
	unsigned char sw;
	unsigned char pre;

	pre = ((tpCVC)pCVC)->VM.Device.Chips.C8255.PB61;
	((tpCVC)pCVC)->VM.Device.Chips.C8255.PB61 = (unsigned char)value;
	//PB3 Ӱ PCĵλ
	pc = ((tpCVC)pCVC)->VM.Device.Chips.C8255.PC62;
	sw = ((tpCVC)pCVC)->VM.Device.Chips.C8255.switchs;
	KdPrint(("-----------------------8255 W 61   %X\n",value));
	if(value & 0x08)	//High Switchs
		pc = (pc & 0xF0) + (sw >> 4);
	else				//Low Switchs
		pc = (pc & 0xF0) + (sw & 0x0F);
	((tpCVC)pCVC)->VM.Device.Chips.C8255.PC62 = pc;

}
static unsigned int C8255_61_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("-----------------------8255 R 61   %X\n",((tpCVC)pCVC)->VM.Device.Chips.C8255.PB61));
	return ((tpCVC)pCVC)->VM.Device.Chips.C8255.PB61;
}
EXERESULT C8255Register_61(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = C8255_61_Write;
	pIO_Handler->read =  C8255_61_Read;
	return rt;
}

//-----------------------------PC 62 PORT--------------------------------------
//PC
//ֻcpu <- PC
static void C8255_62_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	KdPrint(("WARN: дһֻĶ˿ %X\n",portid));
	//((tpCVC)pCVC)->VM.Device.Chips.C8255.PC62 = (unsigned char)value;
}
static unsigned int C8255_62_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("-----------------------8255 R 62   %X\n",((tpCVC)pCVC)->VM.Device.Chips.C8255.PC62));
	return ((tpCVC)pCVC)->VM.Device.Chips.C8255.PC62;
}
EXERESULT C8255Register_62(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = C8255_62_Write;
	pIO_Handler->read =  C8255_62_Read;
	return rt;
}

//-----------------------------Command/Mode 63 PORT--------------------------------------
static void C8255_63_Write(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
	KdPrint(("-----------------------8255 W 63   %X\n",value));
	((tpCVC)pCVC)->VM.Device.Chips.C8255.CM63 = (unsigned char)value;
}
static unsigned int C8255_63_Read(PVOID pCVC,unsigned short portid,unsigned char len){
	KdPrint(("WARN: ڶһֻдĶ˿ %X\n",portid));
	return 0xFF;
}
EXERESULT C8255Register_63(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = C8255_63_Write;
	pIO_Handler->read =  C8255_63_Read;
	return rt;
}

EXERESULT C8255Register(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
	tpDevice pDev = (tpDevice)pDevice;

	C8255Register_60(&pDev->IO_Handler[PORT_HANDLER_60_C8255]);
	pDev->Port2HandlerId[0x60] = PORT_HANDLER_60_C8255;

	C8255Register_61(&pDev->IO_Handler[PORT_HANDLER_61_C8255]);
	pDev->Port2HandlerId[0x61] = PORT_HANDLER_61_C8255;

	C8255Register_62(&pDev->IO_Handler[PORT_HANDLER_62_C8255]);
	pDev->Port2HandlerId[0x62] = PORT_HANDLER_62_C8255;

	C8255Register_63(&pDev->IO_Handler[PORT_HANDLER_63_C8255]);
	pDev->Port2HandlerId[0x63] = PORT_HANDLER_63_C8255;
	return rt;
}