#include "general.h"
#include "VMM/Device/Chip.h"
#include "VMM/Device.h"


EXERESULT ChipCreate(tpChip pChip){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("ChipCreate\n"));
	return rt;
}

EXERESULT ChipRelease(tpChip pChip){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("ChipRelease\n"));
	return rt;
}

EXERESULT ChipInit(tpChip pChip){
	EXERESULT rt = SS_SUCCESS;

#if CPU_TYPE == 0
	//---------------8255--------------
	//PC/XT
	pChip->C8255.IsSupported = TRUE;
	C8255Init(&pChip->C8255);
	pChip->GameCA.IsSupported = TRUE;
	GameCAInit(&pChip->GameCA);
#endif
	return rt;
}

EXERESULT ChipRegister(PVOID pDevice){
	EXERESULT rt = SS_SUCCESS;
#if CPU_TYPE == 0
	//8255
	C8255Register(pDevice);
	//GameCA
	GameCARegister(pDevice);
#endif
	return rt;
}
