#include "general.h"
#include "VMM/Device.h"

EXERESULT DeviceCreate(tpDevice pDevice,PVOID pCVC){
	EXERESULT rt = SS_SUCCESS;
	
	//Display
	rt = DisplayCreate(&pDevice->Display,pCVC);
	if(rt != SS_SUCCESS)
	{
		DeviceReleaseAllCreated(pDevice);
		return rt;
	}
	pDevice->Display.HasCreated = TRUE;

	//Printer
	rt = PrinterCreate(&pDevice->Printer);
	if(rt != SS_SUCCESS)
	{
		DeviceReleaseAllCreated(pDevice);
		return rt;
	}
	pDevice->Printer.HasCreated = TRUE;

	//Keyboard
	rt = KeyboardCreate(&pDevice->Keyboard);
	if(rt != SS_SUCCESS)
	{
		DeviceReleaseAllCreated(pDevice);
		return rt;
	}
	pDevice->Keyboard.HasCreated = TRUE;		//Keyboard was created successfully !

	//SDM
	rt = SDMR0Create(&pDevice->Sdm,pCVC);
	if(rt != SS_SUCCESS)
	{
		DeviceReleaseAllCreated(pDevice);
		return rt;
	}
	pDevice->Sdm.HasCreated = TRUE;				//SDM was created successfully !

	//PIC
	rt = PicCreate(&pDevice->Pic);
	if(rt != SS_SUCCESS)
	{
		DeviceReleaseAllCreated(pDevice);
		return rt;
	}
	pDevice->Pic.HasCreated = TRUE;

	//Chips
	rt = ChipCreate(&pDevice->Chips);
	if(rt != SS_SUCCESS)
	{
		DeviceReleaseAllCreated(pDevice);
		return rt;
	}
	pDevice->Chips.HasCreated = TRUE;

	//Timer
	rt = TimerCreate(&pDevice->Timer,pCVC);
	if(rt != SS_SUCCESS)
	{
		DeviceReleaseAllCreated(pDevice);
		return rt;
	}
	pDevice->Timer.HasCreated = TRUE;

	//DMA
	rt = DMACreate(&pDevice->DMA,pCVC);
	if(rt != SS_SUCCESS)
	{
		DeviceReleaseAllCreated(pDevice);
		return rt;
	}
	pDevice->DMA.HasCreated = TRUE;				//DMA was created successfully !

	//BIOS
	rt = BiosCreate(&pDevice->Bios,pCVC);
	if(rt != SS_SUCCESS)
	{
		DeviceReleaseAllCreated(pDevice);
		return rt;
	}
	pDevice->Bios.HasCreated = TRUE;			//BIOS was created successfully !

	return rt;
}
EXERESULT DeviceReleaseAllCreated(tpDevice pDevice){
	EXERESULT rt = SS_SUCCESS;
	//Release DMA
	if(pDevice->DMA.HasCreated)
	{
		rt = GETFIRSTERROR(rt,DMARelease(&pDevice->DMA,pDevice->pCVC));
		if(rt == SS_SUCCESS)
			pDevice->DMA.HasCreated = FALSE;
	}
	//Release Display
	if(pDevice->Display.HasCreated)
	{
		rt = GETFIRSTERROR(rt,DisplayRelease(&pDevice->Display,pDevice->pCVC));
		if(rt == SS_SUCCESS)
			pDevice->Display.HasCreated = FALSE;
	}
	//Release Printer
	if(pDevice->Printer.HasCreated)
	{
		rt = GETFIRSTERROR(rt,PrinterRelease(&pDevice->Printer));
		if(rt == SS_SUCCESS)
			pDevice->Printer.HasCreated = FALSE;
	}
	//Release Keyboard
	if(pDevice->Keyboard.HasCreated)
	{
		rt = GETFIRSTERROR(rt,KeyboardRelease(&pDevice->Keyboard));
		if(rt == SS_SUCCESS)
			pDevice->Keyboard.HasCreated = FALSE;
	}
	//Release Sdm
	if(pDevice->Sdm.HasCreated)
	{
		rt = GETFIRSTERROR(rt,SDMR0Release(&pDevice->Sdm));
		if(rt == SS_SUCCESS)
			pDevice->Sdm.HasCreated = FALSE;
	}
	//Release Pic
	if(pDevice->Pic.HasCreated)
	{
		rt = GETFIRSTERROR(rt,PicRelease(&pDevice->Pic));
		if(rt == SS_SUCCESS)
			pDevice->Pic.HasCreated = FALSE;
	}
	//Release Chips
	if(pDevice->Chips.HasCreated)
	{
		rt = GETFIRSTERROR(rt,ChipRelease(&pDevice->Chips));
		if(rt == SS_SUCCESS)
			pDevice->Chips.HasCreated = FALSE;
	}
	//Release Timer
	if(pDevice->Timer.HasCreated)
	{
		rt = GETFIRSTERROR(rt,TimerRelease(&pDevice->Timer));
		if(rt == SS_SUCCESS)
			pDevice->Timer.HasCreated = FALSE;
	}
	//Release Bios
	if(pDevice->Bios.HasCreated)
	{
		rt = GETFIRSTERROR(rt,BiosRelease(&pDevice->Bios));
		if(rt == SS_SUCCESS)
			pDevice->Bios.HasCreated = FALSE;
	}
	return rt;
}
EXERESULT DeviceRelease(tpDevice pDevice){
	EXERESULT rt = SS_SUCCESS;
	rt = DeviceReleaseAllCreated(pDevice);
	return rt;
}

EXERESULT DeviceInit(tpDevice pDevice,PVOID pCVC){
	EXERESULT rt = SS_SUCCESS;
	int used_port_handler_id;
	int port_id;

	//ʼ
	KeyboardInit(&pDevice->Keyboard,pCVC);

	//ʼPIC
	PicInit(&pDevice->Pic);

	//ʼChips
	ChipInit(&pDevice->Chips);

	//ʼTimer
	TimerInit(&pDevice->Timer,pCVC);

	//ʼDisplay
	DisplayInit(&pDevice->Display);

	//ʼPrinter
	PrinterInit(&pDevice->Printer);

	//ʼFloppy
	FloppyInit(&pDevice->Sdm.Floppy,pCVC);

	//ʼDMA
	DMAInit(&pDevice->DMA);

	//ʼ˿-ӳ
	for(port_id = 0;port_id < PORT_COUNT;port_id++)
	{
		pDevice->Port2HandlerId[port_id] = PORT_HANDLER_DEFAULT;
	}

	//Blank δ
	pDevice->IO_Handler[PORT_HANDLER_DEFAULT].write = Blank_IO_Write;
	pDevice->IO_Handler[PORT_HANDLER_DEFAULT].read = Blank_IO_Read;

	//ĳʼԷֹĿָ
	for(used_port_handler_id = 0;used_port_handler_id < USED_PORT_HANDLER_COUNT;used_port_handler_id++){
		pDevice->IO_Handler[used_port_handler_id].write = Blank_IO_Write;
		pDevice->IO_Handler[used_port_handler_id].read = Blank_IO_Read;
	}

	//Unimportant	ѶģҪģʱ
	pDevice->IO_Handler[PORT_HANDLER_UNIMPORTANT].write = UNIMPORTANT_IO_Write;
	pDevice->IO_Handler[PORT_HANDLER_UNIMPORTANT].read  = UNIMPORTANT_IO_Read;

	//עIO
	DeviceRegisterIOHandler(pDevice);
	return rt;
}

EXERESULT DeviceRegisterIOHandler(tpDevice pDevice){
	EXERESULT rt = SS_SUCCESS;
	
	//-----------ע 0x80 CheckPoint port-----------
	ChkPointRegister_80(&pDevice->IO_Handler[PORT_HANDLER_80_CHECKPOINT]);
	pDevice->Port2HandlerId[0x80] = PORT_HANDLER_80_CHECKPOINT;

#if CPU_TYPE == 0
	//----------עNMI Mask Register port-----------
	//A0	жϿ	PC/XT
	//write 80h to enable NMI, 00h disable
	//ʱǲҪ
	pDevice->Port2HandlerId[0xA0] = PORT_HANDLER_UNIMPORTANT;
#endif


	//---------------ע8042port-----------------
	//0x60
	//KeyboardRegister_60(&pDevice->IO_Handler[PORT_HANDLER_60_KB]);
	//pDevice->Port2HandlerId[0x60] = PORT_HANDLER_60_KB;
	//0x64
	//KeyboardRegister_64(&pDevice->IO_Handler[PORT_HANDLER_64_KB]);
	//pDevice->Port2HandlerId[0x64] = PORT_HANDLER_64_KB;


	//-----------------עPIC port-------------------
	//20 21
	//A0 A1ڵǰ汾PIC
	PicRegister(pDevice);

	//-----------------עCHIPS	port------------------
	//60 61 62 63
	ChipRegister(pDevice);

	//----------------עDisplay port----------------
	//3B4 3B5 3B8 3BA
	//3D4 3D5 3D8 3D9 3DA
	DisplayRegister(pDevice);

	//----------------עPrinter port----------------
	//278 378 3BC
	PrinterRegister(pDevice);

	//----------------עFloppy port-----------------
	//3F2 3F4 3F5
	FloppyRegister(pDevice);

	//-----------------עDMA port-------------------
	//0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x09 0x0A 0x0B 0x0C 0x0D 0x0E 0x0F
	//0x81
	DMARegister(pDevice);

	//-----------------ע Timer port----------------
	//241 341 ??? һʹɹеĶ˿ڶ
	TimerRegister(pDevice);
	return rt;
}


//80 port
static void ChkPointWrite(PVOID pCVC,unsigned short portid,unsigned int value,unsigned char len){
}
static unsigned int ChkPointRead(PVOID pCVC,unsigned short portid,unsigned char len){
	return 0;
}
EXERESULT ChkPointRegister_80(tpIO_Handler pIO_Handler){
	EXERESULT rt = SS_SUCCESS;
	pIO_Handler->write = ChkPointWrite;
	pIO_Handler->read =  ChkPointRead;
	return rt;
}

