/*
	CVC: Current Vm	Context
*/
#include "general.h"
#include "BI.h"
#include "VMM/MDER0.h"
#include "VMM/CVCR0.h"

EXERESULT CVCR0Create(PIRP Irp,tpBI pBI){
	EXERESULT rt = SS_SUCCESS;
	int pathlen;
	tpCVC  pCVC;
	PIO_STACK_LOCATION pSL;
	PFILE_OBJECT pFileObject;
	KdPrint(("CVCR0Create\n"));
	pSL = IoGetCurrentIrpStackLocation(Irp);
	pFileObject = pSL->FileObject;
	pFileObject->FsContext = NULL;

	pFileObject->FsContext = ExAllocatePoolWithTag(NonPagedPool,sizeof(tCVC),SS_HOST_USED_POOL);		//CVCR0Releaseͷ
	if(pFileObject->FsContext == NULL)
		return  SS_ALLOC_MEM_ERR;
	memset(pFileObject->FsContext,0,sizeof(tCVC));
	((tpCVC)(pFileObject->FsContext))->DeviceObject = pSL->DeviceObject;
	((tpCVC)(pFileObject->FsContext))->pMDE = pSL->DeviceObject->DeviceExtension;

	pCVC = CVCR0GetIt(Irp);

	//ô·
	pathlen = (wcslen(pBI->DiskPath)+1)*sizeof(WCHAR);
	pCVC->VM.Device.Sdm.Disk.FilePath = (PWCHAR)ExAllocatePoolWithTag(NonPagedPool,pathlen,SS_HOST_USED_POOL);	//CVCR0Releaseͷ
	if(pCVC->VM.Device.Sdm.Disk.FilePath == NULL)
	{
		ExFreePool(pFileObject->FsContext);			//ͷǰڴ
		return SS_ALLOC_MEM_ERR;
	}
	wcscpy(pCVC->VM.Device.Sdm.Disk.FilePath,pBI->DiskPath);

	//·
	pathlen = (wcslen(pBI->FloppyPath)+1)*sizeof(WCHAR);
	pCVC->VM.Device.Sdm.Floppy.FilePath = (PWCHAR)ExAllocatePoolWithTag(NonPagedPool,pathlen,SS_HOST_USED_POOL);	//CVCR0Releaseͷ
	if(pCVC->VM.Device.Sdm.Floppy.FilePath == NULL)
	{
		ExFreePool(pCVC->VM.Device.Sdm.Disk.FilePath);	//ͷǰڴ
		ExFreePool(pFileObject->FsContext);
		return SS_ALLOC_MEM_ERR;
	}
	wcscpy(pCVC->VM.Device.Sdm.Floppy.FilePath ,pBI->FloppyPath);

	return rt;
}

EXERESULT CVCR0Release(PIRP Irp){
	tpCVC  pCVC;
	KdPrint(("CVCR0Release\n"));
	pCVC = CVCR0GetIt(Irp);
	if(pCVC->VM.Device.Sdm.Disk.FilePath != NULL)
	{
		ExFreePool(pCVC->VM.Device.Sdm.Disk.FilePath);
		pCVC->VM.Device.Sdm.Disk.FilePath = NULL;
	}
	if(pCVC->VM.Device.Sdm.Floppy.FileHandle != NULL)
	{
		ExFreePool(pCVC->VM.Device.Sdm.Floppy.FilePath);
		pCVC->VM.Device.Sdm.Floppy.FilePath = NULL;
	}
	if(pCVC != NULL)
	{
		ExFreePool(pCVC);
		pCVC = NULL;
	}
	return SS_SUCCESS;
}

EXERESULT CVCR0Init(tpCVC pCVC,tpBI pBI){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("CVCR0Init\n"));

	//ȫԴΪδ
	pCVC->HasCreated = FALSE;
	pCVC->VM.Cpu.HasCreated = FALSE;
	pCVC->VM.Mem.HasCreated = FALSE;
	pCVC->VM.Log.HasCreated = FALSE;
	pCVC->VMM.HasCreated = FALSE;

	pCVC->VM.Device.HasCreated = FALSE;
	pCVC->VM.Device.DMA.HasCreated = FALSE;
	pCVC->VM.Device.Sdm.HasCreated = FALSE;
	pCVC->VM.Device.Bios.HasCreated = FALSE;
	pCVC->VM.Device.Keyboard.HasCreated = FALSE;
	pCVC->VM.Device.Display.HasCreated = FALSE;
	pCVC->VM.Device.Printer.HasCreated = FALSE;
	pCVC->VM.Device.Pic.HasCreated = FALSE;
	pCVC->VM.Device.Chips.HasCreated = FALSE;
	pCVC->VM.Device.Timer.HasCreated = FALSE;


	pCVC->pSubCVCR3 = pBI->pSubCVCR3;
	pCVC->VM.Cpu.count = pBI->CpuCount;
	KdPrint(("Cpu : %d\n",pCVC->VM.Cpu.count));
	pCVC->VM.Mem.size	 = pBI->MemSize;
	KdPrint(("ڴС: %d Byte\n",pCVC->VM.Mem.size));
	pCVC->VM.Device.Sdm.Disk.size = pBI->DiskSize;
	KdPrint(("̴С: %d Byte\n",pCVC->VM.Device.Sdm.Disk.size));

	pCVC->pMDE->HostHighestPhysicalMemory = pBI->HostHighestPhysicalMemory;
	pCVC->VM.Mem.HostHighestPhysicalMemory = pCVC->pMDE->HostHighestPhysicalMemory;
	KdPrint(("ڴַ: %08X\n",pCVC->pMDE->HostHighestPhysicalMemory));

	return rt;
}

tpCVC CVCR0GetIt(PIRP Irp){
	PIO_STACK_LOCATION pSL;
	pSL = IoGetCurrentIrpStackLocation(Irp);
	return (tpCVC)(pSL->FileObject->FsContext);
}