/*
	CPUM	Cpu Manager
*/
#include "general.h"
#include "VMM/CVCR0.h"
#include "VMM/CPUMR0.h"


EXERESULT CPUMR0Create(tpCpu pCpu){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("CPUMR0Create\n"));
	pCpu->pReg = (tpReg)ExAllocatePoolWithTag(NonPagedPool,sizeof(tReg)*(pCpu->count),SS_HOST_USED_POOL);
	if(pCpu->pReg == NULL)
		return  SS_ALLOC_MEM_ERR;
	return rt;
}

EXERESULT CPUMR0Release(tpCpu pCpu){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("CPUMR0Release\n"));
	ExFreePool(pCpu->pReg);
	return rt;
}

EXERESULT CPUMR0InitCpu(tpCpu pCpu){
	EXERESULT rt = SS_SUCCESS;
	int count;
	int cpuid;
	count = pCpu->count;
	if(count>MAX_LOGIC_CPU_COUNT)
		return SS_ERROR;
	//Zero ռĴ
	_Zero._Zero32 = 0;
	for(cpuid = 0;cpuid<count;cpuid++)
	{
		//Pentium 4
		//Intel 64 and IA_32 Architectures Software Developer's Manual Volume 3A	. PAGE 391
		pCpu->pReg[cpuid]._EAX = 0x00000000;
		pCpu->pReg[cpuid]._EBX = 0x00000000;
		pCpu->pReg[cpuid]._ECX = 0x00000000;
		pCpu->pReg[cpuid]._EDX = 0x00000F11;	//0x00000Fxx
		pCpu->pReg[cpuid]._ESI = 0x00000000;
		pCpu->pReg[cpuid]._EDI = 0x00000000;
		pCpu->pReg[cpuid]._EBP = 0x00000000;
		pCpu->pReg[cpuid]._ESP = 0x00000000;


		//intel 3A . page.105 page.178 page.193
		pCpu->pReg[cpuid].xCS.v = 0xF000;		//Selector = F000H Base = FFFF0000H Limit = FFFFH AR = Present, R/W, Accessed
		pCpu->pReg[cpuid].xCS.h.Base = 0x0F0000;
		pCpu->pReg[cpuid].xCS.h.Limits = 0xFFFF;
		pCpu->pReg[cpuid].xCS.h.Access = 0x001F;
		pCpu->pReg[cpuid].xDS.v = 0x0000;		//Selector = 0000H Base = 00000000H Limit = FFFFH AR = Present, R/W, Accessed	DS\SS\ES\FS\GS ͬ
		pCpu->pReg[cpuid].xDS.h.Base = 0x00000000;
		pCpu->pReg[cpuid].xDS.h.Limits = 0xFFFF;
		pCpu->pReg[cpuid].xDS.h.Access = 0x001F;
		pCpu->pReg[cpuid].xSS.v = 0x0000;
		pCpu->pReg[cpuid].xSS.h.Base = 0x00000000;
		pCpu->pReg[cpuid].xSS.h.Limits = 0xFFFF;
		pCpu->pReg[cpuid].xSS.h.Access = 0x001F;
		pCpu->pReg[cpuid].xES.v = 0x0000;
		pCpu->pReg[cpuid].xES.h.Base = 0x00000000;
		pCpu->pReg[cpuid].xES.h.Limits = 0xFFFF;
		pCpu->pReg[cpuid].xES.h.Access = 0x001F;
		pCpu->pReg[cpuid].xFS.v = 0x0000;
		pCpu->pReg[cpuid].xFS.h.Base = 0x00000000;
		pCpu->pReg[cpuid].xFS.h.Limits = 0xFFFF;
		pCpu->pReg[cpuid].xFS.h.Access = 0x001F;
		pCpu->pReg[cpuid].xGS.v = 0x0000;
		pCpu->pReg[cpuid].xGS.h.Base = 0x00000000;
		pCpu->pReg[cpuid].xGS.h.Limits = 0xFFFF;
		pCpu->pReg[cpuid].xGS.h.Access = 0x001F;

		pCpu->pReg[cpuid]._EFLAGS = 0x00000002;

		pCpu->pReg[cpuid]._EIP = 0x0000FFF0;

		pCpu->pReg[cpuid].CR0 = 0x60000010;
		pCpu->pReg[cpuid].CR1;
		pCpu->pReg[cpuid].CR2 = 0x00000000;
		pCpu->pReg[cpuid].CR3 = 0x00000000;
		pCpu->pReg[cpuid].CR4 = 0x00000000;
		pCpu->pReg[cpuid].DR0;
		pCpu->pReg[cpuid].DR1;
		pCpu->pReg[cpuid].DR2;
		pCpu->pReg[cpuid].DR3;
		pCpu->pReg[cpuid].DR4;
		pCpu->pReg[cpuid].DR5;
		pCpu->pReg[cpuid].DR6;
		pCpu->pReg[cpuid].DR7;
		pCpu->pReg[cpuid].GDTR;
		pCpu->pReg[cpuid].LDTR;
		pCpu->pReg[cpuid].IDTR.Base = 0x00000000;
		pCpu->pReg[cpuid].IDTR.Limit = 0xFFFF;
		pCpu->pReg[cpuid].TR;
		pCpu->pReg[cpuid].MTRRs;
		pCpu->pReg[cpuid].MSRs;
	}
	return rt;
}
