#include "general.h"
#include "VMM/CVCR0.h"
#include "VM/VMR0.h"
#include "VMM/VMMR0.h"
#include "BI.h"
#include "ExtInt.h"
#include "ExtCmdInfo.h"

EXERESULT VMR0PowerUp(__in PIRP Irp){
	PIO_STACK_LOCATION pSL;
	EXERESULT rt = SS_SUCCESS;
	int inBufLength;
	char *inBuf;
	tpCVC pCVC;
	KdPrint(("VMR0PowerUp\n"));
	pSL = IoGetCurrentIrpStackLocation(Irp);
	inBufLength = pSL->Parameters.DeviceIoControl.InputBufferLength;
	inBuf = (char *)(Irp->AssociatedIrp.SystemBuffer);


	//CVC
	rt = CVCR0Create(Irp,(tpBI)inBuf);
	pCVC = CVCR0GetIt(Irp);
	if(rt != SS_SUCCESS)
		return rt;
	pCVC->HasCreated = TRUE;					//CVC was created successfully !
	rt = CVCR0Init(pCVC,(tpBI)inBuf);
	if(rt != SS_SUCCESS)
	{
		VMR0ReleaseAllCreate(Irp);
		return rt;
	}

	//CPUM
	rt = CPUMR0Create(&(pCVC->VM.Cpu));
	if(rt != SS_SUCCESS)
	{
		VMR0ReleaseAllCreate(Irp);
		return rt;
	}
	pCVC->VM.Cpu.HasCreated = TRUE;				//CPUM was created successfully !


	CPUMR0InitCpu(&(pCVC->VM.Cpu));

	//MM
	rt = MMR0Create(&(pCVC->VM.Mem));
	if(rt != SS_SUCCESS)
	{
		VMR0ReleaseAllCreate(Irp);
		return rt;
	}
	pCVC->VM.Mem.HasCreated = TRUE;				//MM was created successfully !

	//Device  *  DeviceMemBiosǰ
	rt = DeviceCreate(&pCVC->VM.Device,pCVC);
	if(rt != SS_SUCCESS)
	{
		VMR0ReleaseAllCreate(Irp);
		return rt;
	}
	pCVC->VM.Device.HasCreated = TRUE;					//Device was created successfully !
	DeviceInit(&pCVC->VM.Device,pCVC);

	//LOG
	rt = LogCreate(&pCVC->VM.Log,pCVC);
	if(rt != SS_SUCCESS)
	{
		VMR0ReleaseAllCreate(Irp);
		return rt;
	}
	pCVC->VM.Log.HasCreated = TRUE;				//LOG was created successfully !

	//VMM
	rt = VMMR0Create(pCVC);
	if(rt != SS_SUCCESS)
	{
		VMR0ReleaseAllCreate(Irp);
		return rt;
	}
	else
		KdPrint(("VMMR0Create ɹ \n"));
	pCVC->VMM.HasCreated = TRUE;				//VMM was created successfully !
	//
	//	POWERGOOD
	//	豸Ѿִгʼ
	//
	rt = VMR0InitBeforeRun(pCVC);
	if(rt != SS_SUCCESS)
	{
		rt =VMR0ReleaseAllCreate(Irp);
	}
	return rt;
}

EXERESULT VMR0ReleaseAllCreate(__in PIRP Irp){
	EXERESULT rt = SS_SUCCESS;
	tpCVC pCVC;
	pCVC = CVCR0GetIt(Irp);
	KdPrint(("VMR0ReleaseAllCreate\n"));
	if(pCVC->VMM.HasCreated)		//ͷ
	{
		rt = GETFIRSTERROR(rt,VMMR0Release(pCVC));
		if(rt == SS_SUCCESS)
			pCVC->VMM.HasCreated = FALSE;
	}
	if(pCVC->VM.Device.HasCreated)	//ڶͷţԿеԴõڴϢ)
	{
		rt = GETFIRSTERROR(rt,DeviceRelease(&pCVC->VM.Device));
		if(rt == SS_SUCCESS)
			pCVC->VM.Device.HasCreated = FALSE;
	}
	if(pCVC->VM.Cpu.HasCreated)
	{
		rt = GETFIRSTERROR(rt,CPUMR0Release(&(pCVC->VM.Cpu)));
		if(rt == SS_SUCCESS)
			pCVC->VM.Cpu.HasCreated = FALSE;
	}
	if(pCVC->VM.Mem.HasCreated)
	{
		rt = GETFIRSTERROR(rt,MMR0Release(&(pCVC->VM.Mem)));
		if(rt == SS_SUCCESS)
			pCVC->VM.Mem.HasCreated = FALSE;
	}

	if(pCVC->VM.Log.HasCreated)
	{
		rt = GETFIRSTERROR(rt,LogRelease(&(pCVC->VM.Log)));
		if(rt == SS_SUCCESS)
			pCVC->VM.Log.HasCreated = FALSE;
	}
	if(pCVC->HasCreated)			//ͷ
	{
		rt = GETFIRSTERROR(rt,CVCR0Release(Irp));
		if(rt == SS_SUCCESS)
			pCVC->HasCreated = FALSE;
	}
	return rt;
}
EXERESULT VMR0PowerOff(__in PIRP Irp){
	EXERESULT rt = SS_SUCCESS;
	tpCVC pCVC;
	pCVC = CVCR0GetIt(Irp);
	KdPrint(("VMR0PowerOff\n"));
	//clear VMM,LOG,MM,CPUM,SDM,CVC
	rt = VMR0ReleaseAllCreate(Irp);
	return rt;
}


EXERESULT VMR0InitBeforeRun(tpCVC pCVC){
	EXERESULT rt = SS_SUCCESS;

	rt = BiosWriteRom2Ram(&(pCVC->VM.Device.Bios),(char *)((char *)pCVC->VM.Mem.pGuestPhyMem +pCVC->VM.Mem.size - BIOS_ROM_SIZE));
	return rt;
}

EXERESULT VMR0RunWithEmu(__in PIRP Irp){
	EXERESULT rt = SS_SUCCESS;
	KdPrint(("VMR0RunWithEmu\n"));
	rt = VMMR0StartEmu(CVCR0GetIt(Irp));
	return rt;
}

EXERESULT VMR0RunCmd(__in PIRP Irp){
	EXERESULT rt = SS_SUCCESS;
	PIO_STACK_LOCATION pSL;
	int inBufLength;
	tpExtCmdInfo  pEci;
	tpCVC pCVC;
	PKEVENT rtEvent;

	pSL = IoGetCurrentIrpStackLocation(Irp);
	//inBufLength = pSL->Parameters.DeviceIoControl.InputBufferLength;
	pEci = (tpExtCmdInfo)(Irp->AssociatedIrp.SystemBuffer);

	pCVC = (tpCVC)(pSL->FileObject->FsContext);

	switch(pEci->Type){
	case VM_EXT_CMD_TYPE_MAIN_MENU_DEBUG:
		switch(pEci->SubType){
		case VM_DBG_TYPE_NEXT_COUNT:
#ifdef SS_DEBUG
			VMMR0DbgNextCount(pCVC,pEci->Debug.NextRunCount);
#endif
			break;
		default:
			KdPrint(("WARNִһδⲿ  \n"));
			break;
		}
		break;
	default:
		KdPrint(("WARNִһδⲿ\n"));
		break;
	}
	return rt;
}